// Generated by gmmproc 2.78.0 -- DO NOT MODIFY!
#ifndef _ATKMM_EDITABLETEXT_H
#define _ATKMM_EDITABLETEXT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <atkmm/text.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
  typedef struct _AtkEditableTextIface AtkEditableTextIface;
  typedef struct _AtkEditableText      AtkEditableText;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkEditableText = struct _AtkEditableText;
using AtkEditableTextClass = struct _AtkEditableTextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class ATKMM_API EditableText_Class; } // namespace Atk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{

/** The ATK interface implemented by components containing user-editable text content.
 *
 * This should be implemented by UI components which contain text which the user can edit, via the Atk::Object
 * corresponding to that component (see Atk::Object).
 *
 * An object which implements %EditableText shall also implement Atk::Text.
 */

class ATKMM_API EditableText : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = EditableText;
  using CppClassType = EditableText_Class;
  using BaseObjectType = AtkEditableText;
  using BaseClassType = AtkEditableTextIface;

  // noncopyable
  EditableText(const EditableText&) = delete;
  EditableText& operator=(const EditableText&) = delete;

private:
  friend class EditableText_Class;
  static CppClassType editabletext_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  EditableText();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit EditableText(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit EditableText(AtkEditableText* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  EditableText(EditableText&& src) noexcept;
  EditableText& operator=(EditableText&& src) noexcept;

  ~EditableText() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkEditableText*       gobj()       { return reinterpret_cast<AtkEditableText*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkEditableText* gobj() const { return reinterpret_cast<AtkEditableText*>(gobject_); }

private:


public:
  
  /** Sets the attributes for a specified range. See the ATK_ATTRIBUTE
   * macros (such as ATK_ATTRIBUTE_LEFT_MARGIN) for examples of attributes 
   * that can be set. Note that other attributes that do not have corresponding
   * ATK_ATTRIBUTE macros may also be set for certain text widgets.
   * 
   * @param attrib_set An Atk::AttributeSet.
   * @param start_offset Start of range in which to set attributes.
   * @param end_offset End of range in which to set attributes.
   * @return <tt>true</tt> if attributes successfully set for the specified
   * range, otherwise <tt>false</tt>.
   */
  bool set_run_attributes(const std::vector<Attribute>& attrib_set, int start_offset, int end_offset);

  
  /** Set text contents of @a text.
   * 
   * @param string String to set for text contents of @a text.
   */
  void set_text_contents(const Glib::ustring& string);
  
  /** Insert text at a given position.
   * 
   * @param string The text to insert.
   * @param length The length of text to insert, in bytes.
   * @param position The caller initializes this to 
   * the position at which to insert the text. After the call it
   * points at the position after the newly inserted text.
   */
  void insert_text(const Glib::ustring& string, int length, int& position);
  
  /** Copy text from @a start_pos up to, but not including @a end_pos 
   * to the clipboard.
   * 
   * @param start_pos Start position.
   * @param end_pos End position.
   */
  void copy_text(int start_pos, int end_pos);
  
  /** Copy text from @a start_pos up to, but not including @a end_pos
   * to the clipboard and then delete from the widget.
   * 
   * @param start_pos Start position.
   * @param end_pos End position.
   */
  void cut_text(int start_pos, int end_pos);
  
  /** Delete text @a start_pos up to, but not including @a end_pos.
   * 
   * @param start_pos Start position.
   * @param end_pos End position.
   */
  void delete_text(int start_pos, int end_pos);
  
  /** Paste text from clipboard to specified @a position.
   * 
   * @param position Position to paste.
   */
  void paste_text(int position);

protected:
    virtual bool set_run_attributes_vfunc(AtkAttributeSet* attrib_set, int start_offset, int end_offset);


    virtual void set_text_contents_vfunc(const Glib::ustring& string);


    virtual void insert_text_vfunc(const Glib::ustring& string, int length, int& position);

    virtual void copy_text_vfunc(int start_pos, int end_pos);

    virtual void cut_text_vfunc(int start_pos, int end_pos);

    virtual void delete_text_vfunc(int start_pos, int end_pos);

    virtual void paste_text_vfunc(int position);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::EditableText
   */
  ATKMM_API
  Glib::RefPtr<Atk::EditableText> wrap(AtkEditableText* object, bool take_copy = false);

} // namespace Glib


#endif /* _ATKMM_EDITABLETEXT_H */

