/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class UnitTest
extends FreeColTestCase {
    private static final BuildingType carpenterHouseType = UnitTest.spec().getBuildingType("model.building.carpenterHouse");
    private static final BuildingType churchType = UnitTest.spec().getBuildingType("model.building.chapel");
    private static final GoodsType cottonType = UnitTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType foodType = UnitTest.spec().getPrimaryFoodType();
    private static final Role dragoonRole = UnitTest.spec().getRole("model.role.dragoon");
    private static final Role missionaryRole = UnitTest.spec().getRole("model.role.missionary");
    private static final Role scoutRole = UnitTest.spec().getRole("model.role.scout");
    private static final Role soldierRole = UnitTest.spec().getRole("model.role.soldier");
    private static final TileType ocean = UnitTest.spec().getTileType("model.tile.ocean");
    private static final TileType plains = UnitTest.spec().getTileType("model.tile.plains");
    private static final UnitType artilleryType = UnitTest.spec().getUnitType("model.unit.artillery");
    private static final UnitType braveType = UnitTest.spec().getUnitType("model.unit.brave");
    private static final UnitType caravelType = UnitTest.spec().getUnitType("model.unit.caravel");
    private static final UnitType colonialRegularType = UnitTest.spec().getUnitType("model.unit.colonialRegular");
    private static final UnitType colonistType = UnitTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType expertFarmerType = UnitTest.spec().getUnitType("model.unit.expertFarmer");
    private static final UnitType frigateType = UnitTest.spec().getUnitType("model.unit.frigate");
    private static final UnitType galleonType = UnitTest.spec().getUnitType("model.unit.galleon");
    private static final UnitType hardyPioneerType = UnitTest.spec().getUnitType("model.unit.hardyPioneer");
    private static final UnitType indianConvertType = UnitTest.spec().getUnitType("model.unit.indianConvert");
    private static final UnitType jesuitMissionaryType = UnitTest.spec().getUnitType("model.unit.jesuitMissionary");
    private static final UnitType kingsRegularType = UnitTest.spec().getUnitType("model.unit.kingsRegular");
    private static final UnitType merchantmanType = UnitTest.spec().getUnitType("model.unit.merchantman");
    private static final UnitType seasonedScoutType = UnitTest.spec().getUnitType("model.unit.seasonedScout");
    private static final UnitType treasureTrainType = UnitTest.spec().getUnitType("model.unit.treasureTrain");
    private static final UnitType revengerType = UnitTest.spec().getUnitType("model.unit.revenger");
    private static final UnitType undeadType = UnitTest.spec().getUnitType("model.unit.undead");
    private static final UnitType veteranSoldierType = UnitTest.spec().getUnitType("model.unit.veteranSoldier");
    private static final UnitType wagonType = UnitTest.spec().getUnitType("model.unit.wagonTrain");

    public void testIsColonist() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap(plains, true);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player sioux = game.getPlayerByNationId("model.nation.sioux");
        Tile tile1 = map.getTile(6, 8);
        Tile tile2 = map.getTile(6, 9);
        ServerUnit merchantman = new ServerUnit(game, tile1, dutch, merchantmanType);
        UnitTest.assertFalse((String)"Merchantman is not a colonist", (boolean)merchantman.isColonist());
        ServerUnit soldier = new ServerUnit(game, tile1, dutch, veteranSoldierType);
        UnitTest.assertTrue((String)"A soldier is a colonist", (boolean)soldier.isColonist());
        ServerUnit brave = new ServerUnit(game, tile2, sioux, braveType);
        UnitTest.assertFalse((String)"A brave is not a colonist", (boolean)brave.isColonist());
    }

    public void testCanAdd() {
        Game game = UnitTest.getStandardGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        ServerUnit galleon = new ServerUnit(game, null, dutch, galleonType);
        ServerUnit caravel = new ServerUnit(game, null, dutch, caravelType);
        ServerUnit colonist = new ServerUnit(game, null, dutch, colonistType);
        ServerUnit wagonTrain = new ServerUnit(game, null, dutch, wagonType);
        ServerUnit treasureTrain = new ServerUnit(game, null, dutch, treasureTrainType);
        UnitTest.assertTrue((boolean)galleon.canAdd(colonist));
        UnitTest.assertTrue((boolean)galleon.canAdd(treasureTrain));
        UnitTest.assertFalse((boolean)galleon.canAdd(wagonTrain));
        UnitTest.assertFalse((boolean)galleon.canAdd(caravel));
        UnitTest.assertFalse((boolean)galleon.canAdd(galleon));
        UnitTest.assertTrue((boolean)caravel.canAdd(colonist));
        UnitTest.assertFalse((boolean)caravel.canAdd(wagonTrain));
        UnitTest.assertFalse((boolean)caravel.canAdd(treasureTrain));
        UnitTest.assertFalse((boolean)caravel.canAdd(caravel));
        UnitTest.assertFalse((boolean)caravel.canAdd(galleon));
        int wagonTrainOldSpace = wagonTrain.getCargoCapacity();
        int wagonTrainOldSpaceTaken = wagonTrain.getCargoCapacity();
        int caravelOldSpaceTaken = caravel.getCargoCapacity();
        wagonTrain.getType().setSpace(1);
        wagonTrain.getType().setSpaceTaken(2);
        caravel.getType().setSpaceTaken(1);
        UnitTest.assertTrue((boolean)galleon.canAdd(wagonTrain));
        UnitTest.assertTrue((boolean)caravel.canAdd(wagonTrain));
        UnitTest.assertTrue((boolean)galleon.canAdd(caravel));
        UnitTest.assertFalse((boolean)caravel.canAdd(caravel));
        wagonTrain.getType().setSpace(wagonTrainOldSpace);
        wagonTrain.getType().setSpaceTaken(wagonTrainOldSpaceTaken);
        caravel.getType().setSpaceTaken(caravelOldSpaceTaken);
    }

    public void testFailedAddGoods() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap();
        game.changeMap(map);
        Colony colony = this.getStandardColony();
        int foodInColony = 300;
        colony.addGoods(foodType, foodInColony);
        UnitTest.assertEquals((String)"Setup error, colony does goods quantity wrong", (int)foodInColony, (int)colony.getGoodsCount(foodType));
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        ServerUnit wagonTrain = new ServerUnit(game, colony.getTile(), dutch, wagonType);
        UnitTest.assertEquals((String)"Setup error, unit should not carry anything", (int)0, (int)wagonTrain.getGoodsSpaceTaken());
        UnitTest.assertEquals((String)"Setup error, unit has wrong initial moves", (int)wagonTrain.getInitialMovesLeft(), (int)wagonTrain.getMovesLeft());
        int tooManyGoods = colony.getGoodsCount(foodType);
        UnitTest.assertFalse((String)"Can not add too many goods", (boolean)wagonTrain.add(new Goods(game, null, foodType, tooManyGoods)));
        UnitTest.assertEquals((String)"Unit should not carry anything", (int)0, (int)wagonTrain.getGoodsSpaceTaken());
        UnitTest.assertEquals((String)"Unit moves should not have been modified", (int)wagonTrain.getInitialMovesLeft(), (int)wagonTrain.getMovesLeft());
    }

    public void testMissionary() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap(plains, true);
        game.changeMap(map);
        Player sioux = game.getPlayerByNationId("model.nation.sioux");
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile = map.getTile(6, 9);
        Colony colony = this.getStandardColony(3);
        Building church = colony.getBuilding(churchType);
        church.upgrade();
        ServerUnit jesuit = new ServerUnit(game, tile, dutch, jesuitMissionaryType);
        ServerUnit colonist = new ServerUnit(game, colony, dutch, colonistType);
        UnitTest.assertFalse((boolean)colonist.hasAbility("model.ability.establishMission"));
        colonist.setRole(missionaryRole);
        UnitTest.assertTrue((boolean)colonist.hasAbility("model.ability.establishMission"));
        UnitTest.assertEquals((Object)missionaryRole, (Object)jesuit.getRole());
        UnitTest.assertTrue((boolean)jesuit.hasAbility("model.ability.establishMission"));
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement s = builder.player(sioux).settlementTile(tile).capital(true).build();
        s.setContacted(dutch);
        s.setMissionary(jesuit);
        UnitTest.assertTrue((String)"No missionary set", (boolean)s.hasMissionary());
        UnitTest.assertEquals((String)"Wrong missionary set", (Object)s.getMissionary(), (Object)jesuit);
        s.setMissionary(null);
        UnitTest.assertFalse((String)"Missionary not removed", (boolean)s.hasMissionary());
    }

    public void testGetLineOfSight() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap(plains, true);
        game.changeMap(map);
        Player player = game.getPlayerByNationId("model.nation.dutch");
        Tile tile = map.getTile(6, 9);
        ServerUnit frigate = new ServerUnit(game, tile, player, frigateType);
        UnitTest.assertEquals((int)2, (int)frigate.getLineOfSight());
        UnitTest.assertTrue((boolean)frigate.hasAbility("model.ability.navalUnit"));
        ServerUnit revenger = new ServerUnit(game, tile, player, revengerType);
        UnitTest.assertEquals((int)3, (int)revenger.getLineOfSight());
        ServerUnit colonist = new ServerUnit(game, tile, player, colonistType);
        UnitTest.assertEquals((int)1, (int)colonist.getLineOfSight());
        UnitTest.assertTrue((boolean)colonist.hasAbility("model.ability.canBeEquipped"));
        colonist.changeRole(scoutRole, 1);
        UnitTest.assertEquals((int)2, (int)colonist.getLineOfSight());
        FoundingFather father = UnitTest.spec().getFoundingFather("model.foundingFather.hernandoDeSoto");
        player.addFather(father);
        UnitTest.assertEquals((int)2, (int)frigate.getLineOfSight());
        UnitTest.assertEquals((int)4, (int)revenger.getLineOfSight());
        UnitTest.assertEquals((int)3, (int)colonist.getLineOfSight());
    }

    public void testUnitCanBuildColony() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap(plains, true);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player sioux = game.getPlayerByNationId("model.nation.sioux");
        Tile tile1 = map.getTile(10, 4);
        ServerUnit farmer = new ServerUnit(game, tile1, dutch, expertFarmerType);
        UnitTest.assertTrue((boolean)farmer.canBuildColony());
        ServerUnit arty = new ServerUnit(game, tile1, dutch, artilleryType);
        UnitTest.assertFalse((boolean)arty.canBuildColony());
        ServerUnit ship = new ServerUnit(game, tile1, dutch, galleonType);
        UnitTest.assertFalse((boolean)ship.canBuildColony());
        ServerUnit treasure = new ServerUnit(game, tile1, dutch, treasureTrainType);
        UnitTest.assertFalse((boolean)treasure.canBuildColony());
        ServerUnit wagon = new ServerUnit(game, tile1, dutch, wagonType);
        UnitTest.assertFalse((boolean)wagon.canBuildColony());
        ServerUnit indianConvert = new ServerUnit(game, tile1, dutch, indianConvertType);
        UnitTest.assertFalse((boolean)indianConvert.canBuildColony());
        ServerUnit brave = new ServerUnit(game, tile1, sioux, braveType);
        UnitTest.assertTrue((boolean)brave.canBuildColony());
    }

    public void testIndianDies() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap();
        game.changeMap(map);
        Player indianPlayer = game.getPlayerByNationId("model.nation.sioux");
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game).player(indianPlayer);
        IndianSettlement camp = builder.build();
        UnitTest.assertEquals((String)"Indian player owns the camp", (Object)indianPlayer, (Object)camp.getOwner());
        ServerUnit brave = new ServerUnit(game, camp, indianPlayer, braveType);
        camp.addOwnedUnit(brave);
        UnitTest.assertEquals((String)"Brave should have been added to camp", (int)2, (int)camp.getUnitCount());
        UnitTest.assertTrue((String)"Brave should be on player unit list", (boolean)indianPlayer.hasUnit(brave));
        brave.dispose();
        UnitTest.assertTrue((String)"Brave was not disposed properly", (boolean)brave.isDisposed());
        UnitTest.assertEquals((String)"Brave was not removed from camp", (int)1, (int)camp.getUnitCount());
        UnitTest.assertFalse((String)"Brave was not removed from player unit list", (boolean)indianPlayer.hasUnit(brave));
    }

    public void testUnitAvailability() {
        Game game = UnitTest.getStandardGame();
        Player indian = game.getPlayerByNationId("model.nation.sioux");
        Player european = game.getPlayerByNationId("model.nation.dutch");
        Player king = game.getPlayerByNationId("model.nation.dutchREF");
        UnitTest.assertTrue((boolean)kingsRegularType.isAvailableTo(king));
        UnitTest.assertFalse((boolean)kingsRegularType.isAvailableTo(indian));
        UnitTest.assertFalse((boolean)kingsRegularType.isAvailableTo(european));
        UnitTest.assertFalse((boolean)colonialRegularType.isAvailableTo(king));
        UnitTest.assertFalse((boolean)colonialRegularType.isAvailableTo(indian));
        UnitTest.assertFalse((boolean)colonialRegularType.isAvailableTo(european));
        UnitTest.assertFalse((boolean)braveType.isAvailableTo(king));
        UnitTest.assertTrue((boolean)braveType.isAvailableTo(indian));
        UnitTest.assertFalse((boolean)braveType.isAvailableTo(european));
        UnitTest.assertFalse((boolean)undeadType.isAvailableTo(king));
        UnitTest.assertFalse((boolean)undeadType.isAvailableTo(indian));
        UnitTest.assertFalse((boolean)undeadType.isAvailableTo(european));
        european.addAbility(new Ability("model.ability.independenceDeclared"));
        UnitTest.assertTrue((boolean)colonialRegularType.isAvailableTo(european));
    }

    public void testUnitLocationAfterBuildingColony() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile colonyTile = map.getTile(6, 8);
        ServerUnit soldier = new ServerUnit(game, colonyTile, dutch, veteranSoldierType);
        UnitTest.assertEquals((String)"Soldier location should be the colony tile", (Object)colonyTile, (Object)soldier.getLocation());
        UnitTest.assertEquals((String)"Soldier tile should be the colony tile", (Object)colonyTile, (Object)soldier.getTile());
        boolean found = false;
        for (Unit unit : colonyTile.getUnitList()) {
            if (unit != soldier) continue;
            found = true;
        }
        UnitTest.assertTrue((String)"Unit not found in tile", (boolean)found);
        ServerColony colony = new ServerColony(game, dutch, "New Amsterdam", colonyTile);
        dutch.addSettlement(colony);
        this.nonServerBuildColony(soldier, colony);
        UnitTest.assertTrue((String)"Soldier should be inside the colony", (boolean)soldier.isInColony());
        UnitTest.assertEquals((String)"Soldier tile should be the colony tile", (Object)colonyTile, (Object)soldier.getTile());
        for (Unit u : colonyTile.getUnitList()) {
            if (u != soldier) continue;
            UnitTest.fail((String)"Unit building colony still in tile");
        }
        UnitTest.assertTrue((String)"Soldier should be in a work location in the colony", (boolean)CollectionUtils.any(colony.getCurrentWorkLocations(), wl -> wl.contains(soldier)));
        WorkLocation workLocation = soldier.getWorkLocation();
        UnitTest.assertNotNull((String)"Soldier should be in a work location in the colony", (Object)workLocation);
        UnitTest.assertFalse((String)"Soldier should not be working in central tile", (colony.getColonyTile(colonyTile) == workLocation ? 1 : 0) != 0);
    }

    public void testUnitLosesExperienceWithRoleChange() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        ServerUnit colonist = new ServerUnit(game, map.getTile(6, 8), dutch, colonistType);
        colonist.modifyExperience(10);
        UnitTest.assertEquals((Object)UnitTest.spec().getDefaultRole(), (Object)colonist.getRole());
        UnitTest.assertTrue((String)"Colonist should some initial experience", (colonist.getExperience() > 0 ? 1 : 0) != 0);
        colonist.changeRole(soldierRole, 1);
        UnitTest.assertEquals((String)"Colonist should have lost all experience", (int)0, (int)colonist.getExperience());
        colonist.modifyExperience(10);
        colonist.changeRole(dragoonRole, 1);
        UnitTest.assertTrue((String)"Colonist should not have lost experience, compatible role", (colonist.getExperience() > 0 ? 1 : 0) != 0);
    }

    public void testOwnerChange() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        ServerUnit colonist = new ServerUnit(game, map.getTile(6, 8), dutch, colonistType);
        UnitTest.assertEquals((String)"Colonist should be dutch", (Object)dutch, (Object)colonist.getOwner());
        UnitTest.assertEquals((String)"Dutch player should have 1 unit", (int)1, (int)dutch.getUnitCount());
        UnitTest.assertEquals((String)"French player should have no units", (int)0, (int)french.getUnitCount());
        colonist.changeOwner(french);
        UnitTest.assertEquals((String)"Colonist should be french", (Object)french, (Object)colonist.getOwner());
        UnitTest.assertEquals((String)"Dutch player should have no units", (int)0, (int)dutch.getUnitCount());
        UnitTest.assertEquals((String)"French player should have 1 unit", (int)1, (int)french.getUnitCount());
    }

    public void testCarrierOwnerChange() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap(ocean);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        ServerUnit galleon = new ServerUnit(game, map.getTile(6, 8), dutch, galleonType);
        UnitTest.assertEquals((String)"Galleon should be empty", (int)0, (int)galleon.getUnitSpaceTaken());
        UnitTest.assertTrue((String)"Galleon should be able to carry units", (boolean)galleon.canCarryUnits());
        ServerUnit colonist = new ServerUnit(game, galleon, dutch, colonistType);
        UnitTest.assertEquals((String)"Colonist should be aboard the galleon", (Object)galleon, (Object)colonist.getLocation());
        UnitTest.assertEquals((String)"Galleon is carrying wrong number of units", (int)1, (int)galleon.getUnitSpaceTaken());
        UnitTest.assertEquals((String)"Colonist should be dutch", (Object)dutch, (Object)galleon.getOwner());
        UnitTest.assertEquals((String)"Colonist should be dutch", (Object)dutch, (Object)colonist.getOwner());
        UnitTest.assertEquals((String)"Dutch player should have 2 units", (int)2, (int)dutch.getUnitCount());
        UnitTest.assertEquals((String)"French player should have no units", (int)0, (int)french.getUnitCount());
        galleon.changeOwner(french);
        UnitTest.assertEquals((String)"Galleon should be french", (Object)french, (Object)galleon.getOwner());
        UnitTest.assertEquals((String)"Colonist should be french", (Object)french, (Object)colonist.getOwner());
        UnitTest.assertEquals((String)"Dutch player should have no units", (int)0, (int)dutch.getUnitCount());
        UnitTest.assertEquals((String)"French player should have 2 units", (int)2, (int)french.getUnitCount());
    }

    public void testGetMovesAsString() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap();
        game.changeMap(map);
        Colony colony = this.getStandardColony(1);
        Unit unit = colony.getUnitList().get(0);
        String initial = "/" + Integer.toString(unit.getInitialMovesLeft() / 3);
        String[] expected = new String[]{"0", "(1/3) ", "(2/3) ", "1", "1(1/3) ", "1(2/3) ", "2", "2(1/3) ", "2(2/3) ", "3", "3(1/3) ", "3(2/3) "};
        for (int index = 0; index < expected.length; ++index) {
            unit.setMovesLeft(index);
            String expectedString = expected[index] + initial;
            String actualString = unit.getMovesAsString();
            UnitTest.assertTrue((String)(expectedString + "!=" + actualString), (boolean)expectedString.equals(actualString));
        }
    }

    public void testTreasureTransportFee() {
        Game game = UnitTest.getStandardGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        ServerUnit treasureTrain = new ServerUnit(game, null, dutch, treasureTrainType);
        treasureTrain.setTreasureAmount(6000);
        UnitTest.spec().applyDifficultyLevel("model.difficulty.veryEasy");
        UnitTest.assertEquals((int)3000, (int)treasureTrain.getTransportFee());
        UnitTest.spec().applyDifficultyLevel("model.difficulty.easy");
        UnitTest.assertEquals((int)3300, (int)treasureTrain.getTransportFee());
        UnitTest.spec().applyDifficultyLevel("model.difficulty.medium");
        UnitTest.assertEquals((int)3600, (int)treasureTrain.getTransportFee());
        UnitTest.spec().applyDifficultyLevel("model.difficulty.hard");
        UnitTest.assertEquals((int)3900, (int)treasureTrain.getTransportFee());
        UnitTest.spec().applyDifficultyLevel("model.difficulty.veryHard");
        UnitTest.assertEquals((int)4200, (int)treasureTrain.getTransportFee());
        dutch.addFather(UnitTest.spec().getFoundingFather("model.foundingFather.hernanCortes"));
        UnitTest.spec().applyDifficultyLevel("model.difficulty.veryEasy");
        UnitTest.assertEquals((int)0, (int)treasureTrain.getTransportFee());
        UnitTest.spec().applyDifficultyLevel("model.difficulty.easy");
        UnitTest.assertEquals((int)0, (int)treasureTrain.getTransportFee());
        UnitTest.spec().applyDifficultyLevel("model.difficulty.medium");
        UnitTest.assertEquals((int)0, (int)treasureTrain.getTransportFee());
        UnitTest.spec().applyDifficultyLevel("model.difficulty.hard");
        UnitTest.assertEquals((int)0, (int)treasureTrain.getTransportFee());
        UnitTest.spec().applyDifficultyLevel("model.difficulty.veryHard");
        UnitTest.assertEquals((int)0, (int)treasureTrain.getTransportFee());
    }

    public void testCopy() {
        Game game = UnitTest.getStandardGame();
        Map map = UnitTest.getTestMap(plains, true);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile1 = map.getTile(6, 8);
        Tile tile2 = map.getTile(6, 9);
        ServerUnit merchantman = new ServerUnit(game, tile1, dutch, merchantmanType);
        ServerUnit soldier = new ServerUnit(game, merchantman, dutch, veteranSoldierType);
        Goods goods = new Goods(game, merchantman, cottonType, 44);
        merchantman.add(goods);
        Unit other = (Unit)merchantman.copy(game);
        UnitTest.assertFalse((merchantman == other ? 1 : 0) != 0);
        UnitTest.assertEquals((String)merchantman.getId(), (String)other.getId());
        UnitTest.assertEquals((Object)merchantman.getType(), (Object)other.getType());
        UnitTest.assertEquals((int)1, (int)merchantman.getUnitCount());
        UnitTest.assertEquals((int)1, (int)other.getUnitCount());
        UnitTest.assertEquals((int)44, (int)merchantman.getGoodsCount(cottonType));
        UnitTest.assertEquals((int)44, (int)other.getGoodsCount(cottonType));
        UnitTest.assertEquals((int)1, (int)merchantman.getUnitCount());
        UnitTest.assertEquals((int)1, (int)other.getUnitCount());
        UnitTest.assertFalse((merchantman.getUnitList().get(0) == other.getUnitList().get(0) ? 1 : 0) != 0);
        UnitTest.assertEquals((String)merchantman.getUnitList().get(0).getId(), (String)other.getUnitList().get(0).getId());
    }

    public void testDefaultRole() {
        for (UnitType type : UnitTest.spec().getUnitTypeList()) {
            UnitTest.assertNotNull((Object)type.getDefaultRole());
        }
    }

    public void testAttrition() {
        for (UnitType type : UnitTest.spec().getUnitTypeList()) {
            if (type == indianConvertType) {
                UnitTest.assertTrue((boolean)type.hasMaximumAttrition());
                continue;
            }
            UnitTest.assertFalse((boolean)type.hasMaximumAttrition());
        }
    }
}

