/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.graph;

public class Selection {
    private final boolean explicit;
    private final String criteria;

    public Selection(String criteria) {
        this(criteria, true);
    }

    public Selection(String criteria, boolean explicit) {
        this.criteria = criteria;
        this.explicit = explicit;
    }

    public Selection asTransitive() {
        if (this.explicit) {
            return new Selection(this.criteria, false);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Selection other = (Selection)obj;
        if (this.explicit != other.explicit) {
            return false;
        }
        return !(this.criteria == null ? other.criteria != null : !this.criteria.equals(other.criteria));
    }

    public String getCriteria() {
        return this.criteria;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.explicit ? 1231 : 1237);
        result = 31 * result + (this.criteria == null ? 0 : this.criteria.hashCode());
        return result;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (!this.explicit) {
            str.append("<transitive from> ");
        }
        str.append(this.criteria);
        return str.toString();
    }
}

