/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.Map;
import org.owasp.shim.Java8Shim;

public enum HtmlTextEscapingMode {
    PCDATA,
    CDATA,
    CDATA_SOMETIMES,
    RCDATA,
    PLAIN_TEXT,
    VOID;

    private static final Map<String, HtmlTextEscapingMode> ESCAPING_MODES;

    public static HtmlTextEscapingMode getModeForTag(String canonTagName) {
        HtmlTextEscapingMode mode = ESCAPING_MODES.get(canonTagName);
        return mode != null ? mode : PCDATA;
    }

    public static boolean isTagFollowedByLiteralContent(String canonTagName) {
        HtmlTextEscapingMode mode = HtmlTextEscapingMode.getModeForTag(canonTagName);
        return mode != PCDATA && mode != VOID;
    }

    public static boolean isVoidElement(String canonTagName) {
        return HtmlTextEscapingMode.getModeForTag(canonTagName) == VOID;
    }

    static {
        ESCAPING_MODES = Java8Shim.j8().mapOfEntries(new Map.Entry[]{Java8Shim.j8().mapEntry((Object)"iframe", (Object)CDATA), Java8Shim.j8().mapEntry((Object)"listing", (Object)CDATA_SOMETIMES), Java8Shim.j8().mapEntry((Object)"xmp", (Object)CDATA), Java8Shim.j8().mapEntry((Object)"comment", (Object)CDATA_SOMETIMES), Java8Shim.j8().mapEntry((Object)"plaintext", (Object)PLAIN_TEXT), Java8Shim.j8().mapEntry((Object)"script", (Object)CDATA), Java8Shim.j8().mapEntry((Object)"style", (Object)CDATA), Java8Shim.j8().mapEntry((Object)"textarea", (Object)RCDATA), Java8Shim.j8().mapEntry((Object)"title", (Object)RCDATA), Java8Shim.j8().mapEntry((Object)"area", (Object)VOID), Java8Shim.j8().mapEntry((Object)"base", (Object)VOID), Java8Shim.j8().mapEntry((Object)"br", (Object)VOID), Java8Shim.j8().mapEntry((Object)"col", (Object)VOID), Java8Shim.j8().mapEntry((Object)"command", (Object)VOID), Java8Shim.j8().mapEntry((Object)"embed", (Object)VOID), Java8Shim.j8().mapEntry((Object)"hr", (Object)VOID), Java8Shim.j8().mapEntry((Object)"img", (Object)VOID), Java8Shim.j8().mapEntry((Object)"input", (Object)VOID), Java8Shim.j8().mapEntry((Object)"keygen", (Object)VOID), Java8Shim.j8().mapEntry((Object)"link", (Object)VOID), Java8Shim.j8().mapEntry((Object)"meta", (Object)VOID), Java8Shim.j8().mapEntry((Object)"param", (Object)VOID), Java8Shim.j8().mapEntry((Object)"source", (Object)VOID), Java8Shim.j8().mapEntry((Object)"track", (Object)VOID), Java8Shim.j8().mapEntry((Object)"wbr", (Object)VOID), Java8Shim.j8().mapEntry((Object)"basefont", (Object)VOID), Java8Shim.j8().mapEntry((Object)"isindex", (Object)VOID)});
    }
}

