/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerObjectNameInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECT;
    public static final int POBJECTNAME;

    public VkDebugMarkerObjectNameInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDebugMarkerObjectNameInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugMarkerObjectNameInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugMarkerObjectNameInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDebugReportObjectTypeEXT")
    public int objectType() {
        return VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address());
    }

    @NativeType(value="uint64_t")
    public long object() {
        return VkDebugMarkerObjectNameInfoEXT.nobject(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pObjectName() {
        return VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address());
    }

    @NativeType(value="char const *")
    public String pObjectNameString() {
        return VkDebugMarkerObjectNameInfoEXT.npObjectNameString(this.address());
    }

    public VkDebugMarkerObjectNameInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugMarkerObjectNameInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT sType$Default() {
        return this.sType(1000022000);
    }

    public VkDebugMarkerObjectNameInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugMarkerObjectNameInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT objectType(@NativeType(value="VkDebugReportObjectTypeEXT") int value) {
        VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT object(@NativeType(value="uint64_t") long value) {
        VkDebugMarkerObjectNameInfoEXT.nobject(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT pObjectName(@NativeType(value="char const *") ByteBuffer value) {
        VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT set(int sType, long pNext, int objectType, long object, ByteBuffer pObjectName) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectType(objectType);
        this.object(object);
        this.pObjectName(pObjectName);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT set(VkDebugMarkerObjectNameInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDebugMarkerObjectNameInfoEXT malloc() {
        return (VkDebugMarkerObjectNameInfoEXT)VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT calloc() {
        return (VkDebugMarkerObjectNameInfoEXT)VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDebugMarkerObjectNameInfoEXT)VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDebugMarkerObjectNameInfoEXT create(long address) {
        return (VkDebugMarkerObjectNameInfoEXT)VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, (long)address);
    }

    @Nullable
    public static VkDebugMarkerObjectNameInfoEXT createSafe(long address) {
        return address == 0L ? null : (VkDebugMarkerObjectNameInfoEXT)VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDebugMarkerObjectNameInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugMarkerObjectNameInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkDebugMarkerObjectNameInfoEXT mallocStack() {
        return VkDebugMarkerObjectNameInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerObjectNameInfoEXT callocStack() {
        return VkDebugMarkerObjectNameInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerObjectNameInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkDebugMarkerObjectNameInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.calloc(capacity, stack);
    }

    public static VkDebugMarkerObjectNameInfoEXT malloc(MemoryStack stack) {
        return (VkDebugMarkerObjectNameInfoEXT)VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT calloc(MemoryStack stack) {
        return (VkDebugMarkerObjectNameInfoEXT)VkDebugMarkerObjectNameInfoEXT.wrap(VkDebugMarkerObjectNameInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugMarkerObjectNameInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nobjectType(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPE);
    }

    public static long nobject(long struct) {
        return UNSAFE.getLong(null, struct + (long)OBJECT);
    }

    public static ByteBuffer npObjectName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)POBJECTNAME)));
    }

    public static String npObjectNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)POBJECTNAME)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nobjectType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPE, value);
    }

    public static void nobject(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OBJECT, value);
    }

    public static void npObjectName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)POBJECTNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)POBJECTNAME)));
    }

    static {
        Struct.Layout layout = VkDebugMarkerObjectNameInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkDebugMarkerObjectNameInfoEXT.__member((int)4), VkDebugMarkerObjectNameInfoEXT.__member((int)POINTER_SIZE), VkDebugMarkerObjectNameInfoEXT.__member((int)4), VkDebugMarkerObjectNameInfoEXT.__member((int)8), VkDebugMarkerObjectNameInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECT = layout.offsetof(3);
        POBJECTNAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDebugMarkerObjectNameInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDebugMarkerObjectNameInfoEXT ELEMENT_FACTORY = VkDebugMarkerObjectNameInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDebugMarkerObjectNameInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugMarkerObjectNameInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugMarkerObjectNameInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDebugReportObjectTypeEXT")
        public int objectType() {
            return VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address());
        }

        @NativeType(value="uint64_t")
        public long object() {
            return VkDebugMarkerObjectNameInfoEXT.nobject(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pObjectName() {
            return VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address());
        }

        @NativeType(value="char const *")
        public String pObjectNameString() {
            return VkDebugMarkerObjectNameInfoEXT.npObjectNameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugMarkerObjectNameInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000022000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugMarkerObjectNameInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer objectType(@NativeType(value="VkDebugReportObjectTypeEXT") int value) {
            VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer object(@NativeType(value="uint64_t") long value) {
            VkDebugMarkerObjectNameInfoEXT.nobject(this.address(), value);
            return this;
        }

        public Buffer pObjectName(@NativeType(value="char const *") ByteBuffer value) {
            VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address(), value);
            return this;
        }
    }
}

