/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.runtime.internal.engine;

import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.impl.DefaultEvaluationContext;
import org.openhab.core.automation.module.script.ScriptExtensionAccessor;
import org.openhab.core.items.Item;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.model.script.engine.Script;
import org.openhab.core.model.script.engine.ScriptExecutionException;
import org.openhab.core.model.script.engine.ScriptParsingException;
import org.openhab.core.model.script.runtime.DSLScriptContextProvider;
import org.openhab.core.model.script.runtime.internal.engine.ScriptImpl;
import org.openhab.core.thing.events.ChannelTriggeredEvent;
import org.openhab.core.thing.events.ThingStatusInfoChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSLScriptEngine
implements ScriptEngine {
    private static final String OUTPUT_EVENT = "event";
    public static final String MIMETYPE_OPENHAB_DSL_RULE = "application/vnd.openhab.dsl.rule";
    private static final Map<String, String> IMPLICIT_VARS = Map.of("command", "receivedCommand", "state", "newState", "newState", "newState", "oldState", "previousState", "triggeringItem", "triggeringItem", "triggeringGroup", "triggeringGroup", "input", "input");
    private final Logger logger = LoggerFactory.getLogger(DSLScriptEngine.class);
    private final org.openhab.core.model.script.engine.ScriptEngine scriptEngine;
    private final @Nullable DSLScriptContextProvider contextProvider;
    private final ScriptContext context = new SimpleScriptContext();
    private final ScriptExtensionAccessor scriptExtensionAccessor;
    private @Nullable Script parsedScript;

    public DSLScriptEngine(org.openhab.core.model.script.engine.ScriptEngine scriptEngine, @Nullable DSLScriptContextProvider contextProvider, ScriptExtensionAccessor scriptExtensionAccessor) {
        this.scriptEngine = scriptEngine;
        this.contextProvider = contextProvider;
        this.scriptExtensionAccessor = scriptExtensionAccessor;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object eval(String script) throws ScriptException {
        String modelName = null;
        try {
            IEvaluationContext specificContext = null;
            Script s = null;
            if (script.stripLeading().startsWith("// context: ")) {
                String contextString = script.stripLeading().substring("// context: ".length(), script.stripLeading().indexOf(10));
                if (!contextString.contains("-")) {
                    this.logger.error("Script has an invalid context reference '{}'!", (Object)contextString);
                    return null;
                }
                int indexLastDash = contextString.lastIndexOf(45);
                modelName = contextString.substring(0, indexLastDash);
                String ruleIndex = contextString.substring(indexLastDash + 1);
                if (this.contextProvider == null) {
                    this.logger.error("Script references context '{}', but no context provider is registered!", (Object)contextString);
                    return null;
                }
                DSLScriptContextProvider cp = this.contextProvider;
                this.logger.debug("Script uses context '{}'.", (Object)contextString);
                specificContext = cp.getContext(modelName);
                XExpression xExpression = cp.getParsedScript(modelName, ruleIndex);
                if (xExpression == null) {
                    this.logger.warn("No pre-parsed script found for {}-{}.", (Object)modelName, (Object)ruleIndex);
                    return null;
                }
                s = this.scriptEngine.newScriptFromXExpression(xExpression);
            } else {
                s = this.parsedScript;
                if (s == null) {
                    this.parsedScript = s = this.scriptEngine.newScriptFromString(script);
                }
            }
            DefaultEvaluationContext evalContext = this.createEvaluationContext(s, specificContext);
            return s.execute((IEvaluationContext)evalContext);
        }
        catch (ScriptExecutionException | ScriptParsingException e) {
            this.parsedScript = null;
            throw new ScriptException(e.getMessage(), modelName, -1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private DefaultEvaluationContext createEvaluationContext(Script script, IEvaluationContext specificContext) {
        Object object;
        Object group;
        Object object2;
        Object value;
        Object value2;
        Script script2;
        IEvaluationContext parentContext = specificContext;
        if (specificContext == null && (script2 = script) instanceof ScriptImpl) {
            Resource resource;
            Resource resource2;
            void impl;
            ScriptImpl scriptImpl = (ScriptImpl)script2;
            ScriptImpl cfr_ignored_0 = (ScriptImpl)script2;
            XExpression xExpression = impl.getXExpression();
            if (xExpression != null && (resource2 = (resource = xExpression.eResource())) instanceof XtextResource) {
                Iterator<Map.Entry<String, String>> xtextResource;
                XtextResource xtextResource2 = (XtextResource)resource2;
                XtextResource cfr_ignored_1 = (XtextResource)resource2;
                IResourceServiceProvider provider = xtextResource.getResourceServiceProvider();
                parentContext = (IEvaluationContext)provider.get(IEvaluationContext.class);
            }
        }
        DefaultEvaluationContext evalContext = new DefaultEvaluationContext(parentContext);
        for (Map.Entry<String, String> entry : IMPLICIT_VARS.entrySet()) {
            value2 = this.context.getAttribute(entry.getKey());
            if (value2 == null) continue;
            QualifiedName qn = QualifiedName.create((String)entry.getValue());
            if (evalContext.getValue(qn) == null) {
                evalContext.newValue(qn, value2);
                continue;
            }
            evalContext.assignValue(qn, value2);
        }
        Map cachePreset = this.scriptExtensionAccessor.findPreset("cache", (String)this.context.getAttribute("oh.engine-identifier", 100));
        evalContext.newValue(QualifiedName.create((String)"sharedCache"), cachePreset.get("sharedCache"));
        evalContext.newValue(QualifiedName.create((String)"privateCache"), cachePreset.get("privateCache"));
        Object object3 = value = this.context.getAttribute(OUTPUT_EVENT);
        if (object3 instanceof ChannelTriggeredEvent) {
            void event;
            value2 = (ChannelTriggeredEvent)object3;
            ChannelTriggeredEvent cfr_ignored_2 = (ChannelTriggeredEvent)object3;
            evalContext.newValue(QualifiedName.create((String)"receivedEvent"), (Object)event.getEvent());
            evalContext.newValue(QualifiedName.create((String)"triggeringChannel"), (Object)event.getChannel().getAsString());
        }
        if ((object2 = value) instanceof ItemEvent) {
            void event;
            ItemEvent itemEvent = (ItemEvent)object2;
            ItemEvent cfr_ignored_3 = (ItemEvent)object2;
            evalContext.newValue(QualifiedName.create((String)"triggeringItemName"), (Object)event.getItemName());
            Object object4 = group = this.context.getAttribute("triggeringGroup");
            if (object4 instanceof Item) {
                void groupItem;
                object = (Item)object4;
                Item cfr_ignored_4 = (Item)object4;
                evalContext.newValue(QualifiedName.create((String)"triggeringGroupName"), (Object)groupItem.getName());
            }
        }
        if ((object = value) instanceof ThingStatusInfoChangedEvent) {
            void event;
            group = (ThingStatusInfoChangedEvent)object;
            ThingStatusInfoChangedEvent cfr_ignored_5 = (ThingStatusInfoChangedEvent)object;
            evalContext.newValue(QualifiedName.create((String)"triggeringThing"), (Object)event.getThingUID().toString());
            evalContext.newValue(QualifiedName.create((String)"previousThingStatus"), (Object)event.getOldStatusInfo().getStatus().toString());
            evalContext.newValue(QualifiedName.create((String)"newThingStatus"), (Object)event.getStatusInfo().getStatus().toString());
        }
        return evalContext;
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(String script, Bindings n) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(Reader reader, Bindings n) throws ScriptException {
        return null;
    }

    @Override
    public void put(String key, Object value) {
    }

    @Override
    public Object get(String key) {
        return null;
    }

    @Override
    public Bindings getBindings(int scope) {
        return null;
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext context) {
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new ScriptEngineFactory(){

            @Override
            public ScriptEngine getScriptEngine() {
                return null;
            }

            @Override
            public String getProgram(String ... statements) {
                return null;
            }

            @Override
            public Object getParameter(String key) {
                return null;
            }

            @Override
            public String getOutputStatement(String toDisplay) {
                return null;
            }

            @Override
            public List<String> getNames() {
                return null;
            }

            @Override
            public List<String> getMimeTypes() {
                return List.of(DSLScriptEngine.MIMETYPE_OPENHAB_DSL_RULE);
            }

            @Override
            public String getMethodCallSyntax(String obj, String m, String ... args) {
                return null;
            }

            @Override
            public String getLanguageVersion() {
                return "v1";
            }

            @Override
            public String getLanguageName() {
                return "Rule DSL";
            }

            @Override
            public List<String> getExtensions() {
                return null;
            }

            @Override
            public String getEngineVersion() {
                return null;
            }

            @Override
            public String getEngineName() {
                return null;
            }
        };
    }
}

