/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.console;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConsoleLine;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.console.VcsConsoleTabService;
import com.intellij.vcs.console.VcsConsoleView;
import java.util.Arrays;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001f\u0010\u000f\u001a\u00020\u000e2\r\u0010\u0010\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0017J\b\u0010\u0018\u001a\u00020\nH\u0017J\b\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0017J\b\u0010\u001d\u001a\u00020\u000eH\u0017J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/console/VcsConsoleTabServiceImpl;", "Lcom/intellij/vcs/console/VcsConsoleTabService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "hadMessages", "", "consoleView", "Lcom/intellij/vcs/console/VcsConsoleView;", "dispose", "", "addMessage", "message", "", "Lorg/jetbrains/annotations/Nls;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "line", "Lcom/intellij/openapi/vcs/VcsConsoleLine;", "isConsoleVisible", "isConsoleEmpty", "showConsoleTab", "selectContent", "onShown", "Ljava/lang/Runnable;", "showConsoleTabAndScrollToTheEnd", "createConsoleContentTab", "Lcom/intellij/ui/content/Content;", "Companion", "intellij.platform.vcs.impl"})
public final class VcsConsoleTabServiceImpl
implements VcsConsoleTabService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private boolean hadMessages;
    @NotNull
    private final VcsConsoleView consoleView;

    public VcsConsoleTabServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.consoleView = new VcsConsoleView(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.consoleView));
    }

    @Override
    public void addMessage(@Nullable String message, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.addMessage(VcsConsoleLine.create((String)message, (ConsoleViewContentType)contentType));
    }

    @Override
    public void addMessage(@Nullable VcsConsoleLine line) {
        if (line == null) {
            return;
        }
        if (this.project.isDisposed() || this.project.isDefault()) {
            return;
        }
        line.print((ConsoleView)this.consoleView);
        this.hadMessages = true;
        if (Registry.Companion.is("vcs.showConsole")) {
            ActionsKt.runInEdt((ModalityState)ModalityState.nonModal(), () -> VcsConsoleTabServiceImpl.addMessage$lambda$0(this));
        }
    }

    @Override
    @RequiresEdt
    public boolean isConsoleVisible() {
        if (this.project.isDisposed() || this.project.isDefault()) {
            return false;
        }
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, "Console");
        if (toolWindow == null) {
            return false;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManagerIfCreated();
        if (contentManager == null) {
            return false;
        }
        ContentManager contentManager2 = contentManager;
        return contentManager2.getContent(this.consoleView.getComponent()) != null;
    }

    @Override
    @RequiresEdt
    public boolean isConsoleEmpty() {
        if (this.project.isDisposed() || this.project.isDefault()) {
            return true;
        }
        return this.consoleView.getContentSize() == 0;
    }

    @Override
    public boolean hadMessages() {
        return this.hadMessages;
    }

    @Override
    @RequiresEdt
    public void showConsoleTab(boolean selectContent, @Nullable Runnable onShown) {
        block3: {
            if (this.project.isDisposed() || this.project.isDefault()) {
                return;
            }
            Content contentTab = ChangesViewContentManager.Companion.getInstance(this.project).findContent("Console");
            if (contentTab == null) {
                this.createConsoleContentTab();
            }
            if (!selectContent) break block3;
            ChangesViewContentManager.Companion.getInstance(this.project).selectContent("Console");
            ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, "Console");
            if (toolWindow != null) {
                toolWindow.activate(onShown);
            }
        }
    }

    @Override
    @RequiresEdt
    public void showConsoleTabAndScrollToTheEnd() {
        this.showConsoleTab(true, () -> VcsConsoleTabServiceImpl.showConsoleTabAndScrollToTheEnd$lambda$1(this));
    }

    private final Content createConsoleContentTab() {
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true);
        panel.setContent(this.consoleView.getComponent());
        AnAction[] anActionArray = this.consoleView.createConsoleActions();
        DefaultActionGroup actionGroup = new DefaultActionGroup(Arrays.copyOf(anActionArray, anActionArray.length));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("VcsManager", (ActionGroup)actionGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(this.consoleView.getComponent());
        panel.setToolbar(toolbar.getComponent());
        ContentImpl contentTab = new ContentImpl((JComponent)panel, VcsBundle.message((String)"vcs.console.toolwindow.display.name", (Object[])new Object[0]), true);
        contentTab.setPreferredFocusedComponent(() -> VcsConsoleTabServiceImpl.createConsoleContentTab$lambda$2(this));
        contentTab.setTabName("Console");
        contentTab.putUserData(ChangesViewContentManager.ORDER_WEIGHT_KEY, (Object)ChangesViewContentManager.TabOrderWeight.CONSOLE.getWeight());
        ChangesViewContentManager.Companion.getInstance(this.project).addContent((Content)contentTab);
        return (Content)contentTab;
    }

    private static final Unit addMessage$lambda$0(VcsConsoleTabServiceImpl this$0) {
        this$0.showConsoleTab(false, null);
        return Unit.INSTANCE;
    }

    private static final void showConsoleTabAndScrollToTheEnd$lambda$1(VcsConsoleTabServiceImpl this$0) {
        this$0.consoleView.requestScrollingToEnd();
    }

    private static final JComponent createConsoleContentTab$lambda$2(VcsConsoleTabServiceImpl this$0) {
        return this$0.consoleView.getPreferredFocusableComponent();
    }

    @JvmStatic
    @NotNull
    public static final VcsConsoleTabService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/console/VcsConsoleTabServiceImpl$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/vcs/console/VcsConsoleTabService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsConsoleTabService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsConsoleTabService.kt\ncom/intellij/vcs/console/VcsConsoleTabServiceImpl$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,183:1\n30#2,2:184\n*S KotlinDebug\n*F\n+ 1 VcsConsoleTabService.kt\ncom/intellij/vcs/console/VcsConsoleTabServiceImpl$Companion\n*L\n90#1:184,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VcsConsoleTabService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<VcsConsoleTabService> serviceClass$iv = VcsConsoleTabService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (VcsConsoleTabService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

