from _typeshed import Incomplete
from typing_extensions import TypeAlias

from networkx.classes.graph import Graph, _Node
from networkx.classes.multidigraph import MultiDiGraph

_MultiEdge: TypeAlias = tuple[_Node, _Node, int]  # noqa: Y047

class MultiGraph(Graph[_Node]):
    def __init__(self, incoming_graph_data: Incomplete | None = None, multigraph_input: bool | None = None, **attr) -> None: ...
    def new_edge_key(self, u: _Node, v: _Node) -> int: ...
    def add_edge(self, u_for_edge, v_for_edge, key: Incomplete | None = None, **attr): ...  # type: ignore[override]  # Has an additional `key` keyword argument
    def remove_edge(self, u, v, key: Incomplete | None = None): ...
    def has_edge(self, u, v, key: Incomplete | None = None): ...
    def get_edge_data(  # type: ignore[override]  # Has an additional `key` keyword argument
        self, u, v, key: Incomplete | None = None, default: Incomplete | None = None
    ): ...
    def copy(self, as_view: bool = False) -> MultiGraph[_Node]: ...
    def to_directed(self, as_view: bool = False) -> MultiDiGraph[_Node]: ...
    def to_undirected(self, as_view: bool = False) -> MultiGraph[_Node]: ...
    def number_of_edges(self, u: _Node | None = None, v: _Node | None = None) -> int: ...
