/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.AndroidNotification;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.MessagingErrorCode;
import com.google.firebase.messaging.MulticastMessage;
import com.google.firebase.messaging.Notification;
import com.google.firebase.messaging.SendResponse;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.ObjectOperation;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class NotificatorFirebase
extends Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorFirebase.class);
    private final Storage storage;
    private final CacheManager cacheManager;
    private final FirebaseMessaging firebaseMessaging;

    @Inject
    public NotificatorFirebase(Config config, NotificationFormatter notificationFormatter, Storage storage, CacheManager cacheManager) throws IOException {
        super(notificationFormatter);
        this.storage = storage;
        this.cacheManager = cacheManager;
        ByteArrayInputStream serviceAccount = new ByteArrayInputStream(config.getString(Keys.NOTIFICATOR_FIREBASE_SERVICE_ACCOUNT).getBytes());
        FirebaseOptions options = FirebaseOptions.builder().setCredentials(GoogleCredentials.fromStream((InputStream)serviceAccount)).build();
        this.firebaseMessaging = FirebaseMessaging.getInstance((FirebaseApp)FirebaseApp.initializeApp((FirebaseOptions)options, (String)"manager"));
    }

    @Override
    public void send(User user, NotificationMessage message, Event event, Position position) throws MessageException {
        if (user.hasAttribute("notificationTokens")) {
            ArrayList<String> registrationTokens = new ArrayList<String>(Arrays.asList(user.getString("notificationTokens").split("[, ]")));
            AndroidConfig.Builder androidConfig = AndroidConfig.builder().setNotification(AndroidNotification.builder().setSound("default").build());
            ApnsConfig.Builder apnsConfig = ApnsConfig.builder().setAps(Aps.builder().setSound("default").build());
            if (message.priority()) {
                androidConfig.setPriority(AndroidConfig.Priority.HIGH);
                apnsConfig.putHeader("apns-priority", "10");
            }
            MulticastMessage.Builder messageBuilder = MulticastMessage.builder().setNotification(Notification.builder().setTitle(message.subject()).setBody(message.digest()).build()).setAndroidConfig(androidConfig.build()).setApnsConfig(apnsConfig.build()).addAllTokens(registrationTokens);
            if (event != null) {
                messageBuilder.putData("eventId", String.valueOf(event.getId()));
            }
            try {
                BatchResponse result = this.firebaseMessaging.sendEachForMulticast(messageBuilder.build());
                LinkedList<String> failedTokens = new LinkedList<String>();
                ListIterator iterator = result.getResponses().listIterator();
                while (iterator.hasNext()) {
                    int index = iterator.nextIndex();
                    SendResponse response = (SendResponse)iterator.next();
                    if (response.isSuccessful()) continue;
                    MessagingErrorCode error = response.getException().getMessagingErrorCode();
                    if (error == MessagingErrorCode.INVALID_ARGUMENT || error == MessagingErrorCode.UNREGISTERED) {
                        failedTokens.add((String)registrationTokens.get(index));
                    }
                    LOGGER.warn("Firebase user {} error", (Object)user.getId(), (Object)response.getException());
                }
                if (!failedTokens.isEmpty()) {
                    registrationTokens.removeAll(failedTokens);
                    if (registrationTokens.isEmpty()) {
                        user.removeAttribute("notificationTokens");
                    } else {
                        user.set("notificationTokens", String.join((CharSequence)",", registrationTokens));
                    }
                    this.storage.updateObject(user, new Request((Columns)new Columns.Include("attributes"), new Condition.Equals("id", user.getId())));
                    this.cacheManager.invalidateObject(true, User.class, user.getId(), ObjectOperation.UPDATE);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Firebase error", (Throwable)e);
            }
        }
    }
}

