/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.openide.util.BaseUtilities;

final class ChangeFirer {
    private final ModuleManager mgr;
    private final Set<Change> changes = new LinkedHashSet<Change>(100);
    private final Set<Module> modulesCreated = new HashSet<Module>(100);
    private final Set<Module> modulesDeleted = new HashSet<Module>(10);

    public ChangeFirer(ModuleManager moduleManager) {
        this.mgr = moduleManager;
    }

    public void change(Change change) {
        this.changes.add(change);
    }

    public void created(Module module) {
        this.modulesCreated.add(module);
    }

    public void deleted(Module module) {
        if (!this.modulesCreated.remove((Object)module)) {
            this.modulesDeleted.add(module);
        }
    }

    public void fire() {
        this.mgr.readOnly(true);
        try {
            for (Change change : this.changes) {
                if (change.source instanceof Module) {
                    ((Module)((Object)change.source)).firePropertyChange0(change.prop, change.old, change.nue);
                    continue;
                }
                if (change.source == this.mgr) {
                    this.mgr.firePropertyChange(change.prop, change.old, change.nue);
                    continue;
                }
                throw new IllegalStateException("Strange source: " + change.source);
            }
            this.changes.clear();
            if (!this.modulesCreated.isEmpty() || !this.modulesDeleted.isEmpty()) {
                this.mgr.fireModulesCreatedDeleted(this.modulesCreated, this.modulesDeleted);
            }
            this.modulesCreated.clear();
            this.modulesDeleted.clear();
        }
        catch (RuntimeException runtimeException) {
            Util.err.log(Level.SEVERE, null, runtimeException);
        }
        finally {
            this.mgr.readOnly(false);
        }
    }

    public static final class Change {
        public final String prop;
        public final Object source;
        public final Object old;
        public final Object nue;

        public Change(Object object, String string, Object object2, Object object3) {
            this.source = object;
            this.prop = string;
            this.old = object2;
            this.nue = object3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Change)) {
                return false;
            }
            Change change = (Change)object;
            return BaseUtilities.compareObjects((Object)this.prop, (Object)change.prop) && BaseUtilities.compareObjects((Object)this.source, (Object)change.source) && BaseUtilities.compareObjects((Object)this.old, (Object)change.old) && BaseUtilities.compareObjects((Object)this.nue, (Object)change.nue);
        }

        public int hashCode() {
            return this.source.hashCode() ^ (this.prop == null ? 0 : this.prop.hashCode());
        }

        public String toString() {
            return "Change[" + this.source + ":" + this.prop + ";" + this.old + "->" + this.nue + "]";
        }
    }
}

