/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;

public abstract class AbstractMessageReader
implements MessageReader {
    private static final QName XSI_NIL = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi");

    public void readToEnd() {
        this.readToEnd(this);
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    public boolean isXsiNil() {
        String value;
        MessageReader nilReader = this.getAttributeReader(XSI_NIL);
        boolean nil = false;
        if (nilReader != null && (value = nilReader.getValue()) != null && (value.equals("true") || value.equals("1"))) {
            return true;
        }
        return nil;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    public char getValueAsCharacter() {
        if (this.getValue() == null) {
            return '\u0000';
        }
        return this.getValue().charAt(0);
    }

    public int getValueAsInt() {
        if (this.getValue() == null) {
            return 0;
        }
        return Integer.parseInt(this.getValue());
    }

    public long getValueAsLong() {
        if (this.getValue() == null) {
            return 0L;
        }
        return Long.parseLong(this.getValue());
    }

    public double getValueAsDouble() {
        if (this.getValue() == null) {
            return 0.0;
        }
        return Double.parseDouble(this.getValue());
    }

    public float getValueAsFloat() {
        if (this.getValue() == null) {
            return 0.0f;
        }
        return Float.parseFloat(this.getValue());
    }

    public boolean getValueAsBoolean() {
        String value = this.getValue();
        if (value == null) {
            return false;
        }
        if ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            return false;
        }
        throw new XFireRuntimeException("Invalid boolean value: " + value);
    }

    public XMLStreamReader getXMLStreamReader() {
        throw new UnsupportedOperationException();
    }
}

