/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.util;

import com.intellij.gradle.toolingExtension.util.GradleReflectionUtil;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleIdeaPluginUtil {
    private static final boolean is47OrBetter = GradleVersionUtil.isCurrentGradleAtLeast((String)"4.7");
    private static final boolean is74OrBetter = GradleVersionUtil.isCurrentGradleAtLeast((String)"7.4");

    @Nullable
    public static IdeaModule getIdeaModule(@NotNull Project project) {
        PluginContainer plugins;
        IdeaPlugin ideaPlugin;
        if (project == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(0);
        }
        if ((ideaPlugin = (IdeaPlugin)(plugins = project.getPlugins()).findPlugin(IdeaPlugin.class)) == null) {
            return null;
        }
        IdeaModel ideaPluginModel = ideaPlugin.getModel();
        if (ideaPluginModel == null) {
            return null;
        }
        return ideaPluginModel.getModule();
    }

    @Nullable
    public static String getIdeaModuleName(@NotNull Project project) {
        IdeaModule ideaPluginModule;
        if (project == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(1);
        }
        if ((ideaPluginModule = GradleIdeaPluginUtil.getIdeaModule(project)) == null) {
            return null;
        }
        String ideaPluginModuleName = ideaPluginModule.getName();
        if (ideaPluginModuleName == null) {
            return null;
        }
        return ideaPluginModuleName;
    }

    @NotNull
    public static Set<File> getSourceDirectories(@NotNull IdeaModule ideaPluginModule) {
        if (ideaPluginModule == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(2);
        }
        return new LinkedHashSet<File>(ideaPluginModule.getSourceDirs());
    }

    @NotNull
    public static Set<File> getResourceDirectories(@NotNull IdeaModule ideaPluginModule) {
        if (ideaPluginModule == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(3);
        }
        if (is47OrBetter) {
            return new LinkedHashSet<File>(ideaPluginModule.getResourceDirs());
        }
        if (GradleReflectionUtil.hasMethod((Object)ideaPluginModule, (String)"getResourceDirs", (Class[])new Class[0])) {
            return new LinkedHashSet<File>(ideaPluginModule.getResourceDirs());
        }
        Set<File> set = Collections.emptySet();
        if (set == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public static Set<File> getTestSourceDirectories(@NotNull IdeaModule ideaPluginModule) {
        if (ideaPluginModule == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(5);
        }
        if (is74OrBetter) {
            Set set = ideaPluginModule.getTestSources().getFiles();
            if (set == null) {
                GradleIdeaPluginUtil.$$$reportNull$$$0(6);
            }
            return set;
        }
        return new LinkedHashSet<File>(ideaPluginModule.getTestSourceDirs());
    }

    @NotNull
    public static Set<File> getTestResourceDirectories(@NotNull IdeaModule ideaPluginModule) {
        if (ideaPluginModule == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(7);
        }
        if (is74OrBetter) {
            Set set = ideaPluginModule.getTestResources().getFiles();
            if (set == null) {
                GradleIdeaPluginUtil.$$$reportNull$$$0(8);
            }
            return set;
        }
        if (is47OrBetter) {
            return new LinkedHashSet<File>(ideaPluginModule.getTestResourceDirs());
        }
        if (GradleReflectionUtil.hasMethod((Object)ideaPluginModule, (String)"getTestResourceDirs", (Class[])new Class[0])) {
            return new LinkedHashSet<File>(ideaPluginModule.getTestResourceDirs());
        }
        Set<File> set = Collections.emptySet();
        if (set == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static Set<File> getGeneratedSourceDirectories(@NotNull IdeaModule ideaPluginModule) {
        if (ideaPluginModule == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(10);
        }
        if (GradleReflectionUtil.hasMethod((Object)ideaPluginModule, (String)"getGeneratedSourceDirs", (Class[])new Class[0])) {
            return new LinkedHashSet<File>(ideaPluginModule.getGeneratedSourceDirs());
        }
        Set<File> set = Collections.emptySet();
        if (set == null) {
            GradleIdeaPluginUtil.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaPluginModule";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/util/GradleIdeaPluginUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/util/GradleIdeaPluginUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSourceDirectories";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestResourceDirectories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourceDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIdeaModule";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIdeaModuleName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSourceDirectories";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDirectories";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestSourceDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestResourceDirectories";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedSourceDirectories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

