/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.WritableProperty;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgColors;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\b\u0010\u0010\u001a\u00020\nH\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "builder", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;)V", "myLineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "myPath", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathElement;", "buildComponent", "", "color", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/WritableProperty;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "fill", "lineType", "updatePathDashArray", "width", "", "Companion", "plot-base"})
public final class LinePath
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SvgPathElement myPath;
    @Nullable
    private LineType myLineType;
    @Nullable
    private static final DoubleVector END_OF_SUBPATH;

    public LinePath(@NotNull SvgPathDataBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.myPath = new SvgPathElement(builder.build());
        this.myPath.fill().set(SvgColors.NONE);
        double lineWidth = 1.0;
        this.myPath.strokeWidth().set(lineWidth);
        this.add(this.myPath);
    }

    @Override
    protected void buildComponent() {
    }

    @NotNull
    public final WritableProperty<Color> color() {
        return this.myPath.strokeColor();
    }

    @NotNull
    public final WritableProperty<Color> fill() {
        return this.myPath.fillColor();
    }

    @NotNull
    public final WritableProperty<Double> width() {
        return new WritableProperty<Double>(this){
            final /* synthetic */ LinePath this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(double value) {
                LinePath.access$getMyPath$p(this.this$0).strokeWidth().set(value);
                LinePath.access$updatePathDashArray(this.this$0);
            }
        };
    }

    @NotNull
    public final WritableProperty<LineType> lineType() {
        return new WritableProperty<LineType>(this){
            final /* synthetic */ LinePath this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(@NotNull LineType value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                LinePath.access$setMyLineType$p(this.this$0, value);
                LinePath.access$updatePathDashArray(this.this$0);
            }
        };
    }

    private final void updatePathDashArray() {
        if (this.myLineType != null) {
            Double d = (Double)this.myPath.strokeWidth().get();
            double width2 = d != null ? d : 1.0;
            SvgShape svgShape = this.myPath;
            LineType lineType2 = this.myLineType;
            Intrinsics.checkNotNull((Object)lineType2);
            StrokeDashArraySupport.INSTANCE.apply(svgShape, width2, lineType2);
        }
    }

    public static final /* synthetic */ SvgPathElement access$getMyPath$p(LinePath $this) {
        return $this.myPath;
    }

    public static final /* synthetic */ void access$updatePathDashArray(LinePath $this) {
        $this.updatePathDashArray();
    }

    public static final /* synthetic */ void access$setMyLineType$p(LinePath $this, LineType lineType2) {
        $this.myLineType = lineType2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012J \u0010\u0013\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0016\u0010\u0015\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0012R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath$Companion;", "", "()V", "END_OF_SUBPATH", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getEND_OF_SUBPATH", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "buildSegment", "", "builder", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;", "curSegment", "", "interpolate", "", "line", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "points", "", "pathBuilder", "isPolygon", "polygon", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DoubleVector getEND_OF_SUBPATH() {
            return END_OF_SUBPATH;
        }

        @NotNull
        public final LinePath line(@NotNull Iterable<DoubleVector> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return new LinePath(this.pathBuilder(points2, false));
        }

        @NotNull
        public final LinePath polygon(@NotNull Iterable<DoubleVector> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return new LinePath(this.pathBuilder(points2, true));
        }

        private final SvgPathDataBuilder pathBuilder(Iterable<DoubleVector> points2, boolean isPolygon) {
            SvgPathDataBuilder builder = new SvgPathDataBuilder(true);
            List curSegment = new ArrayList();
            boolean interpolate = false;
            for (DoubleVector point : points2) {
                if (point == this.getEND_OF_SUBPATH()) {
                    this.buildSegment(builder, curSegment, interpolate);
                    if (isPolygon) {
                        builder.closePath();
                    }
                    curSegment = new ArrayList();
                    continue;
                }
                DoubleVector doubleVector = point;
                Intrinsics.checkNotNull((Object)doubleVector);
                curSegment.add(doubleVector);
            }
            this.buildSegment(builder, curSegment, interpolate);
            if (isPolygon) {
                builder.closePath();
            }
            return builder;
        }

        private final void buildSegment(SvgPathDataBuilder builder, List<DoubleVector> curSegment, boolean interpolate) {
            if (curSegment.isEmpty()) {
                return;
            }
            builder.moveTo(curSegment.get(0));
            builder.interpolatePoints((Collection<DoubleVector>)curSegment, interpolate ? SvgPathDataBuilder.Interpolation.CARDINAL : SvgPathDataBuilder.Interpolation.LINEAR);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

