/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.web.xml;

import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.ProposalTransformer;
import com.intellij.ml.inline.completion.web.xml.WebEnclosuresUtilsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016R\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/inline/completion/web/xml/TrimAlreadyClosingTagPartTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/ProposalTransformer;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;I)V", "closestTag", "Lcom/intellij/psi/xml/XmlTag;", "getClosestTag", "()Lcom/intellij/psi/xml/XmlTag;", "closestTag$delegate", "Lkotlin/Lazy;", "isTagAlreadyClosed", "", "()Z", "isTagAlreadyClosed$delegate", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "getOrder", "intellij.fullLine.web"})
public final class TrimAlreadyClosingTagPartTransformer
implements ProposalTransformer {
    @NotNull
    private final Lazy closestTag$delegate;
    @NotNull
    private final Lazy isTagAlreadyClosed$delegate;

    public TrimAlreadyClosingTagPartTransformer(@NotNull PsiFile file, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.closestTag$delegate = LazyKt.lazy(() -> TrimAlreadyClosingTagPartTransformer.closestTag_delegate$lambda$0(file, document, offset));
        this.isTagAlreadyClosed$delegate = LazyKt.lazy(() -> TrimAlreadyClosingTagPartTransformer.isTagAlreadyClosed_delegate$lambda$1(this));
    }

    private final XmlTag getClosestTag() {
        Lazy lazy = this.closestTag$delegate;
        return (XmlTag)lazy.getValue();
    }

    private final boolean isTagAlreadyClosed() {
        Lazy lazy = this.isTagAlreadyClosed$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        XmlTag closestTag = this.getClosestTag();
        if (closestTag == null || !this.isTagAlreadyClosed()) {
            return proposal;
        }
        String string = closestTag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        return proposal.withSuggestion(StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)proposal.getSuggestion(), (CharSequence)("</" + name)), (CharSequence)("</" + name + ">")));
    }

    @Override
    public int getOrder() {
        return 40;
    }

    private static final XmlTag closestTag_delegate$lambda$0(PsiFile $file, Document $document, int $offset) {
        return WebEnclosuresUtilsKt.findClosestTagOnSameLine($file, $document, $offset);
    }

    private static final boolean isTagAlreadyClosed_delegate$lambda$1(TrimAlreadyClosingTagPartTransformer this$0) {
        XmlTag xmlTag = this$0.getClosestTag();
        return xmlTag != null ? WebEnclosuresUtilsKt.isTagClosed(xmlTag) : false;
    }
}

