/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.dom.inspections.MavenParentMissedCoordinatesInspection;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenParentMissedVersionInspection;", "Lorg/jetbrains/idea/maven/dom/inspections/MavenParentMissedCoordinatesInspection;", "<init>", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getParentVersion", "", "parentElement", "Lorg/jetbrains/idea/maven/dom/model/MavenDomParent;", "getShortName", "intellij.maven"})
public final class MavenParentMissedVersionInspection
extends MavenParentMissedCoordinatesInspection {
    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder2) {
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        MavenDomParent mavenDomParent = this.getParentIfExists(domFileElement);
        if (mavenDomParent == null) {
            return;
        }
        MavenDomParent parent = mavenDomParent;
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile pom = xmlFile;
        if (!parent.getVersion().exists()) {
            VirtualFile virtualFile = pom.getVirtualFile();
            Project project = pom.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!MavenConsumerPomUtil.isAutomaticVersionFeatureEnabled(virtualFile, project)) {
                String version = this.getParentVersion(parent);
                this.reportMissedChildTagProblem(holder2, parent, "version", version);
            }
        }
    }

    private final String getParentVersion(MavenDomParent parentElement) {
        PsiFile psiFile = (PsiFile)parentElement.getRelativePath().getValue();
        if (psiFile == null) {
            return "";
        }
        PsiFile parentPom = psiFile;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomModel(parentPom, MavenDomProjectModel.class);
        if (mavenDomProjectModel == null) {
            return "";
        }
        MavenDomProjectModel parentModel = mavenDomProjectModel;
        if (Intrinsics.areEqual((Object)parentModel.getArtifactId().getValue(), (Object)parentElement.getArtifactId().getValue()) && Intrinsics.areEqual((Object)parentModel.getGroupId().getValue(), (Object)parentElement.getGroupId().getValue())) {
            String string = (String)parentModel.getVersion().getValue();
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    @NotNull
    public String getShortName() {
        return "MavenParentMissedVersionInspection";
    }
}

