/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterInterface;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenPathWrapper;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenRootModelAdapter
implements MavenRootModelAdapterInterface {
    private final MavenRootModelAdapterInterface myDelegate;

    public MavenRootModelAdapter(MavenRootModelAdapterInterface delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public void init(boolean isNewlyCreatedModule) {
        this.myDelegate.init(isNewlyCreatedModule);
    }

    @Override
    public ModifiableRootModel getRootModel() {
        return this.myDelegate.getRootModel();
    }

    @Override
    public Module getModule() {
        return this.myDelegate.getModule();
    }

    @Override
    public <P extends JpsElement> void addSourceFolder(String path, JpsModuleSourceRootType<P> rootType) {
        this.myDelegate.addSourceFolder(path, rootType);
    }

    @Override
    public void addGeneratedJavaSourceFolder(String path, JavaSourceRootType rootType) {
        this.myDelegate.addGeneratedJavaSourceFolder(path, rootType);
    }

    @Override
    public boolean isAlreadyExcluded(File f) {
        return this.myDelegate.isAlreadyExcluded(f);
    }

    @Override
    public void addExcludedFolder(String path) {
        this.myDelegate.addExcludedFolder(path);
    }

    @Override
    public void unregisterAll(String path, boolean under, boolean unregisterSources) {
        this.myDelegate.unregisterAll(path, under, unregisterSources);
    }

    @Override
    public boolean hasCollision(String sourceRootPath) {
        return this.myDelegate.hasCollision(sourceRootPath);
    }

    @Override
    public void useModuleOutput(String production, String test) {
        this.myDelegate.useModuleOutput(production, test);
    }

    @Override
    public MavenPathWrapper toPath(String path) {
        return this.myDelegate.toPath(path);
    }

    @Override
    public void addModuleDependency(@NotNull String moduleName, @NotNull DependencyScope scope, boolean testJar) {
        if (moduleName == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(1);
        }
        this.myDelegate.addModuleDependency(moduleName, scope, testJar);
    }

    @Override
    @Nullable
    public Module findModuleByName(String moduleName) {
        return this.myDelegate.findModuleByName(moduleName);
    }

    @Override
    public void addSystemDependency(MavenArtifact artifact, DependencyScope scope) {
        this.myDelegate.addSystemDependency(artifact, scope);
    }

    @Override
    public LibraryOrderEntry addLibraryDependency(MavenArtifact artifact, DependencyScope scope, IdeModifiableModelsProvider provider, MavenProject project) {
        return this.myDelegate.addLibraryDependency(artifact, scope, provider, project);
    }

    @Override
    public Library findLibrary(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(2);
        }
        return this.myDelegate.findLibrary(artifact);
    }

    @Override
    public void setLanguageLevel(LanguageLevel level) {
        this.myDelegate.setLanguageLevel(level);
    }

    public static boolean isChangedByUser(Library library) {
        String[] classRoots = library.getUrls(OrderRootType.CLASSES);
        if (classRoots.length != 1) {
            return true;
        }
        String classes = classRoots[0];
        if (!classes.endsWith("!/")) {
            return true;
        }
        int dotPos = classes.lastIndexOf("/", classes.length() - 2);
        if (dotPos == -1) {
            return true;
        }
        String pathToJar = classes.substring(0, dotPos);
        if (MavenRootModelAdapter.hasUserPaths(OrderRootType.SOURCES, library, pathToJar)) {
            return true;
        }
        return MavenRootModelAdapter.hasUserPaths(JavadocOrderRootType.getInstance(), library, pathToJar);
    }

    private static boolean hasUserPaths(OrderRootType rootType, Library library, String pathToJar) {
        String[] sources;
        for (String each : sources = library.getUrls(rootType)) {
            if (FileUtil.startsWith((String)each, (String)pathToJar)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMavenLibrary(@Nullable Library library) {
        return library != null && MavenArtifact.isMavenLibrary((String)library.getName());
    }

    public static ProjectModelExternalSource getMavenExternalSource() {
        return ExternalProjectSystemRegistry.getInstance().getSourceById("Maven");
    }

    @Nullable
    public static OrderEntry findLibraryEntry(@NotNull Module m, @NotNull MavenArtifact artifact) {
        if (m == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(4);
        }
        String name = artifact.getLibraryName();
        for (OrderEntry each : ModuleRootManager.getInstance((Module)m).getOrderEntries()) {
            if (!(each instanceof LibraryOrderEntry) || !name.equals(((LibraryOrderEntry)each).getLibraryName())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public static MavenArtifact findArtifact(@NotNull MavenProject project, @Nullable Library library) {
        if (project == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(5);
        }
        if (library == null) {
            return null;
        }
        String name = library.getName();
        if (!MavenArtifact.isMavenLibrary((String)name)) {
            return null;
        }
        for (MavenArtifact each : project.getDependencies()) {
            if (!each.getLibraryName().equals(name)) continue;
            return each;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenRootModelAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addModuleDependency";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findLibrary";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findLibraryEntry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findArtifact";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

