/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinPsiUpdateModCommandAction;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.CallableReturnTypeUpdaterUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.ConvertPropertyInitializerToGetterUtilsKt;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B!\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/ConvertPropertyInitializerToGetterFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinPsiUpdateModCommandAction$ElementBased;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/CallableReturnTypeUpdaterUtils$TypeInfo;", "element", "elementContext", "familyName", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/CallableReturnTypeUpdaterUtils$TypeInfo;Ljava/lang/String;)V", "getFamilyName", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.fixes.k2"})
public final class ConvertPropertyInitializerToGetterFix
extends KotlinPsiUpdateModCommandAction.ElementBased<KtProperty, CallableReturnTypeUpdaterUtils.TypeInfo> {
    @NotNull
    private final String familyName;

    public ConvertPropertyInitializerToGetterFix(@NotNull KtProperty element, @NotNull CallableReturnTypeUpdaterUtils.TypeInfo elementContext, @IntentionFamilyName @NotNull String familyName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        super((PsiElement)element, elementContext);
        this.familyName = familyName;
    }

    public /* synthetic */ ConvertPropertyInitializerToGetterFix(KtProperty ktProperty, CallableReturnTypeUpdaterUtils.TypeInfo typeInfo, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = KotlinBundle.message((String)"convert.property.initializer.to.getter", (Object[])new Object[0]);
        }
        this(ktProperty, typeInfo, string);
    }

    @NotNull
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtProperty element, @NotNull CallableReturnTypeUpdaterUtils.TypeInfo elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        Project project = actionContext.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        ConvertPropertyInitializerToGetterUtilsKt.convertPropertyInitializerToGetter(project, element, elementContext, updater2);
    }
}

