/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.copyPaste;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.j2k.copyPaste.ElementAndTextList;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a8\u0006\u000b"}, d2={"collectElementsToConvert", "", "Lorg/jetbrains/kotlin/j2k/copyPaste/ElementAndTextList;", "file", "Lcom/intellij/psi/PsiJavaFile;", "fileText", "", "range", "Lcom/intellij/openapi/util/TextRange;", "extractSignificantImportsAndPackage", "sourceFile", "kotlin.j2k.shared"})
public final class ConversionDataKt {
    private static final void collectElementsToConvert(ElementAndTextList $this$collectElementsToConvert, PsiJavaFile file, String fileText, TextRange range2) {
        Collection collection = PsiUtilsKt.elementsInRange((PsiFile)((PsiFile)file), (TextRange)range2);
        if (collection.isEmpty()) {
            boolean bl = false;
            String string = fileText.substring(range2.getStartOffset(), range2.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$collectElementsToConvert.addText(string);
            return;
        }
        List elements = (List)collection;
        String string = fileText.substring(range2.getStartOffset(), ((PsiElement)CollectionsKt.first((List)elements)).getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String prefix2 = string;
        $this$collectElementsToConvert.addText(prefix2);
        for (PsiElement element : elements) {
            PsiElement psiElement = element;
            if (psiElement instanceof PsiComment) continue;
            if (psiElement instanceof PsiModifierList) {
                $this$collectElementsToConvert.addElements(SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)element))));
                continue;
            }
            $this$collectElementsToConvert.addElement(element);
        }
        String string2 = fileText.substring(((PsiElement)CollectionsKt.last((List)elements)).getTextRange().getEndOffset(), range2.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String postfix = string2;
        $this$collectElementsToConvert.addText(postfix);
    }

    private static final String extractSignificantImportsAndPackage(PsiJavaFile sourceFile) {
        StringBuilder stringBuilder;
        StringBuilder $this$extractSignificantImportsAndPackage_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string = sourceFile.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        if (((CharSequence)packageName).length() > 0) {
            $this$extractSignificantImportsAndPackage_u24lambda_u241.append("package " + packageName + "\n");
        }
        PsiImportList psiImportList = sourceFile.getImportList();
        if (psiImportList != null) {
            PsiImportList importList = psiImportList;
            for (PsiImportStatement psiImportStatement : importList.getImportStatements()) {
                StringBuilder stringBuilder2;
                String qualifiedName;
                if (psiImportStatement.getQualifiedName() == null) continue;
                if (psiImportStatement.isOnDemand()) {
                    stringBuilder2 = $this$extractSignificantImportsAndPackage_u24lambda_u241.append("import " + qualifiedName + ".*\n");
                    continue;
                }
                FqNameUnsafe fqName2 = new FqNameUnsafe(qualifiedName);
                if (fqName2.isSafe() && JavaToKotlinClassMap.INSTANCE.isJavaPlatformClass(fqName2.toSafe())) continue;
                stringBuilder2 = $this$extractSignificantImportsAndPackage_u24lambda_u241.append("import " + qualifiedName + "\n");
            }
        }
        return stringBuilder.toString();
    }

    public static final /* synthetic */ String access$extractSignificantImportsAndPackage(PsiJavaFile sourceFile) {
        return ConversionDataKt.extractSignificantImportsAndPackage(sourceFile);
    }

    public static final /* synthetic */ void access$collectElementsToConvert(ElementAndTextList $receiver, PsiJavaFile file, String fileText, TextRange range2) {
        ConversionDataKt.collectElementsToConvert($receiver, file, fileText, range2);
    }
}

