/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.tables;

import com.intellij.jupyter.core.jupyter.editor.outputs.NotebookStreamOutputDataKeyExtractor;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v4.ToV4JsonKt;
import com.intellij.jupyter.core.premium.JupyterFeatureAvailabilityCheckerKt;
import com.intellij.jupyter.tables.ExtractingKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.TableDataTypeDetector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/tables/TableStreamOutputDataKeyExtractor;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/NotebookStreamOutputDataKeyExtractor;", "<init>", "()V", "extractKey", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/NotebookStreamOutputDataKeyExtractor$ExtractionResult;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "output", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutput;", "isLastForCell", "", "noOutput", "intellij.jupyter.tables"})
public final class TableStreamOutputDataKeyExtractor
implements NotebookStreamOutputDataKeyExtractor {
    @NotNull
    private final NotebookStreamOutputDataKeyExtractor.ExtractionResult noOutput = new NotebookStreamOutputDataKeyExtractor.ExtractionResult(null, false);

    @NotNull
    public NotebookStreamOutputDataKeyExtractor.ExtractionResult extractKey(@NotNull Editor editor, @NotNull NotebookIntervalPointer cellPointer, @NotNull JupyterOutput output, boolean isLastForCell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (!JupyterFeatureAvailabilityCheckerKt.getJupyterFeatureAvailabilityChecker((Editor)editor).areModernTableOutputsAvailable()) {
            return this.noOutput;
        }
        boolean hasOutputInCurrentSession = JupyterInlayProgressStatusManager.Companion.hasOutputInCurrentSession(editor, cellPointer);
        DSTableDataType dataType = TableDataTypeDetector.Companion.getTableDataType(ToV4JsonKt.toV4Json((JupyterOutput)output), hasOutputInCurrentSession);
        if (dataType == DSTableDataType.PYSPARK_TABLE) {
            NotebookOutputDataKey key = ExtractingKt.getTableOutputDataKey(editor, cellPointer, ToV4JsonKt.toV4Json((JupyterOutput)output), null, isLastForCell, dataType);
            return new NotebookStreamOutputDataKeyExtractor.ExtractionResult(key, true);
        }
        return this.noOutput;
    }
}

