/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.jetbrains.rd.ide.model.GotoInput;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rd.ide.model.GotoResultListBase;
import com.jetbrains.rd.ide.model.SearchItemData;
import com.jetbrains.rd.ide.model.SearchPopup;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rdclient.gotoType.GotoResult;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItem;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItemRendererData;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.SyncEventWithInterrupt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 52\u00020\u0001:\u00015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000eJ-\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010%J?\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0018\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001f\u0012\u0004\u0012\u00020'0*\u00a2\u0006\u0002\u0010+JQ\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0018\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001f\u0012\u0004\u0012\u00020'0*H\u0002\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e012\u0006\u00102\u001a\u00020\fJ\u000e\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rb\u0010\n\u001aV\u0012\u0004\u0012\u00020\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f0\u000bj*\u0012\u0004\u0012\u00020\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0\u000bj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/jetbrains/rdclient/gotoType/GotoPopupSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "popupLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "gotoKey", "Lcom/jetbrains/rd/ide/model/GotoKey;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/GotoKey;)V", "shortNameToItemsMap", "Ljava/util/HashMap;", "", "Lcom/jetbrains/rd/ide/model/SearchItemData;", "Lcom/jetbrains/rdclient/gotoType/GotoResult;", "Lkotlin/collections/HashMap;", "requestLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "sequentialLifetimesLocks", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "perTypeRequestIds", "Ljava/util/concurrent/atomic/AtomicInteger;", "getModelSearchPopup", "Lcom/jetbrains/rd/ide/model/SearchPopup;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "navItemCache", "Lcom/jetbrains/rdclient/gotoType/ProtocolNavigationItem;", "getCachedPerResultNavItem", "gotoRes", "getItemsSync", "", "text", "searchInLibraries", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Ljava/lang/String;Ljava/lang/Boolean;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "getItemsAsync", "", "lifetime", "whenReady", "Lkotlin/Function1;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)V", "getItemsAsyncFromBackend", "requestId", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;ILcom/jetbrains/rdclient/services/IdeBackend;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)V", "getItemByShortName", "", "shortName", "getRecentVersionOfResult", "data", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nGotoPopupSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotoPopupSession.kt\ncom/jetbrains/rdclient/gotoType/GotoPopupSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,189:1\n1#2:190\n68#3,4:191\n68#3,4:198\n68#3,4:202\n68#3,4:206\n66#4,3:195\n1491#5:210\n1516#5,3:211\n1519#5,3:221\n1869#5,2:231\n382#6,7:214\n382#6,7:224\n37#7:233\n36#7,3:234\n*S KotlinDebug\n*F\n+ 1 GotoPopupSession.kt\ncom/jetbrains/rdclient/gotoType/GotoPopupSession\n*L\n51#1:191,4\n142#1:198,4\n58#1:202,4\n147#1:206,4\n78#1:195,3\n167#1:210\n167#1:211,3\n167#1:221,3\n170#1:231,2\n167#1:214,7\n169#1:224,7\n176#1:233\n176#1:234,3\n*E\n"})
public final class GotoPopupSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime popupLifetime;
    @NotNull
    private final GotoKey gotoKey;
    @NotNull
    private final HashMap<String, HashMap<SearchItemData, GotoResult>> shortNameToItemsMap;
    @NotNull
    private final SequentialLifetimes requestLifetimes;
    @NotNull
    private final ReentrantReadWriteLock sequentialLifetimesLocks;
    @NotNull
    private AtomicInteger perTypeRequestIds;
    @NotNull
    private final HashMap<GotoResult, ProtocolNavigationItem> navItemCache;
    @NotNull
    private static final Logger logger;

    public GotoPopupSession(@NotNull Project project, @NotNull Lifetime popupLifetime, @NotNull GotoKey gotoKey) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)popupLifetime, (String)"popupLifetime");
        Intrinsics.checkNotNullParameter((Object)gotoKey, (String)"gotoKey");
        this.project = project;
        this.popupLifetime = popupLifetime;
        this.gotoKey = gotoKey;
        this.shortNameToItemsMap = new HashMap();
        this.requestLifetimes = new SequentialLifetimes(this.popupLifetime);
        this.sequentialLifetimesLocks = new ReentrantReadWriteLock();
        this.perTypeRequestIds = new AtomicInteger(0);
        this.navItemCache = new HashMap();
    }

    @NotNull
    public final SearchPopup getModelSearchPopup(@NotNull IdeBackend backend) {
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        IMutableViewableMap popupModel = backend.getGotoModel().getSearchPopups();
        SearchPopup searchPopup = (SearchPopup)popupModel.get((Object)this.gotoKey);
        if (searchPopup == null) {
            boolean bl;
            GotoPopupSession $this$getModelSearchPopup_u24lambda_u247 = this;
            boolean bl2 = false;
            SearchPopup searchPopup2 = new SearchPopup($this$getModelSearchPopup_u24lambda_u247.gotoKey);
            boolean bl3 = bl = !popupModel.containsKey((Object)$this$getModelSearchPopup_u24lambda_u247.gotoKey);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-GotoPopupSession$getModelSearchPopup$1$22 = false;
                String $i$a$-assert-GotoPopupSession$getModelSearchPopup$1$22 = "May not execute overlapping popup of type " + $this$getModelSearchPopup_u24lambda_u247.gotoKey;
                throw new AssertionError((Object)$i$a$-assert-GotoPopupSession$getModelSearchPopup$1$22);
            }
            ((Map)popupModel).put($this$getModelSearchPopup_u24lambda_u247.gotoKey, searchPopup2);
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl4 = false;
                logger.trace("Putting protocol popup model for type " + $this$getModelSearchPopup_u24lambda_u247.gotoKey);
            }
            $this$getModelSearchPopup_u24lambda_u247.popupLifetime.onTermination(() -> GotoPopupSession.getModelSearchPopup$lambda$7$lambda$6($this$getModelSearchPopup_u24lambda_u247, popupModel, searchPopup2));
            searchPopup = searchPopup2;
        }
        return searchPopup;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProtocolNavigationItem getCachedPerResultNavItem(@NotNull GotoResult gotoRes) {
        void $this$getOrCreate$iv;
        Intrinsics.checkNotNullParameter((Object)gotoRes, (String)"gotoRes");
        SearchItemData searchItemData = gotoRes.component1();
        SearchPopup searchPopup = gotoRes.component2();
        Map map = this.navItemCache;
        GotoResult key$iv = gotoRes;
        boolean $i$f$getOrCreate = false;
        Object object = $this$getOrCreate$iv.get(key$iv);
        if (object == null) {
            GotoResult it = key$iv;
            boolean bl = false;
            VirtualFile virtualFile = ProtocolNavigationItem.Companion.calculateVirtualFile(searchItemData, true, this.project);
            ProtocolNavigationItemRendererData renderData = ProtocolNavigationItemRendererData.Companion.calculateRenderData$default(ProtocolNavigationItemRendererData.Companion, virtualFile, true, this.project, null, 8, null);
            ProtocolNavigationItem it$iv = new ProtocolNavigationItem(searchItemData, searchPopup, this.project, this, virtualFile, renderData, null, 64, null);
            boolean bl2 = false;
            $this$getOrCreate$iv.put(key$iv, it$iv);
            object = it$iv;
        }
        return (ProtocolNavigationItem)((Object)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String[] getItemsSync(@NotNull String text, @Nullable Boolean searchInLibraries, @Nullable ProgressIndicator progressIndicator) {
        LifetimeDefinition lifetimeDefinition;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        result2.element = new String[0];
        SyncEventWithInterrupt syncEvent = new SyncEventWithInterrupt();
        ReentrantReadWriteLock reentrantReadWriteLock = this.sequentialLifetimesLocks;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            lifetimeDefinition = this.requestLifetimes.next();
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        LifetimeDefinition getItemsLifetime = lifetimeDefinition;
        ApplicationManager.getApplication().invokeLater(() -> GotoPopupSession.getItemsSync$lambda$12(this, getItemsLifetime, text, searchInLibraries, result2, syncEvent), ModalityState.any());
        SyncEventWithInterrupt.waitFor$default(syncEvent, (Lifetime)getItemsLifetime, false, () -> GotoPopupSession.getItemsSync$lambda$13(progressIndicator), 2, null);
        return (String[])result2.element;
    }

    public final void getItemsAsync(@NotNull Lifetime lifetime, @NotNull String text, @Nullable Boolean searchInLibraries, @NotNull Function1<? super String[], Unit> whenReady) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(whenReady, (String)"whenReady");
        IdeBackend backend = IdeBackend.Companion.getInstance(this.project);
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)backend.getSolution().isLoaded()))) {
            whenReady.invoke((Object)new String[0]);
            return;
        }
        this.getItemsAsyncFromBackend(lifetime, this.perTypeRequestIds.incrementAndGet(), backend, text, searchInLibraries, (Function1<? super String[], Unit>)((Function1)arg_0 -> GotoPopupSession.getItemsAsync$lambda$14(whenReady, arg_0)));
    }

    private final void getItemsAsyncFromBackend(Lifetime lifetime, int requestId, IdeBackend backend, String text, Boolean searchInLibraries, Function1<? super String[], Unit> whenReady) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("getItemsAsync.Start text: '" + text + "', kind: '" + this.gotoKey + "', searchInLibraries: '" + searchInLibraries + "'");
        }
        Ref.BooleanRef hadResult = new Ref.BooleanRef();
        lifetime.onTermination(() -> GotoPopupSession.getItemsAsyncFromBackend$lambda$17(hadResult, text, this, searchInLibraries));
        SearchPopup modelSearchPopup = this.getModelSearchPopup(backend);
        IAsyncSignal iAsyncSignal = modelSearchPopup.getGetItemsTask();
        IScheduler iScheduler = backend.getProtocol().getScheduler();
        Intrinsics.checkNotNull((Object)iScheduler, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.protocol.IRdDispatcher");
        iAsyncSignal.adviseOn(lifetime, ((IRdDispatcher)iScheduler).getBackgroundScheduler(), arg_0 -> GotoPopupSession.getItemsAsyncFromBackend$lambda$22(hadResult, text, searchInLibraries, this, requestId, whenReady, modelSearchPopup, arg_0));
        modelSearchPopup.getInput().set((Object)new GotoInput(text, searchInLibraries, requestId));
    }

    @NotNull
    public final Collection<GotoResult> getItemByShortName(@NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        HashMap<SearchItemData, GotoResult> hashMap = this.shortNameToItemsMap.get(shortName);
        if (hashMap == null || (hashMap = hashMap.values()) == null) {
            hashMap = CollectionsKt.emptyList();
        }
        return hashMap;
    }

    @NotNull
    public final SearchItemData getRecentVersionOfResult(@NotNull SearchItemData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = this.shortNameToItemsMap.get(data.getShortName());
        if (object == null || (object = ((HashMap)object).get(data)) == null || (object = ((GotoResult)object).getSearchItemData()) == null) {
            object = data;
        }
        return object;
    }

    private static final void getModelSearchPopup$lambda$7$lambda$6$lambda$5$lambda$4(IMutableViewableMap $popupModel, GotoPopupSession $this_run, SearchPopup $searchPopup) {
        boolean bl;
        boolean bl2 = bl = $popupModel.get((Object)$this_run.gotoKey) == $searchPopup;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GotoPopupSession$getModelSearchPopup$1$3$1$1$22 = false;
            String $i$a$-assert-GotoPopupSession$getModelSearchPopup$1$3$1$1$22 = "Removing non-own popup from popup model for goto kind " + $this_run.gotoKey + ", bug?";
            throw new AssertionError((Object)$i$a$-assert-GotoPopupSession$getModelSearchPopup$1$3$1$1$22);
        }
        $popupModel.remove((Object)$this_run.gotoKey);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl3 = false;
            logger.trace("Removing protocol model for type " + $this_run.gotoKey);
        }
    }

    private static final void getModelSearchPopup$lambda$7$lambda$6$lambda$5(GotoPopupSession $this_run, IMutableViewableMap $popupModel, SearchPopup $searchPopup) {
        FocusManagerImpl.getInstance((Project)$this_run.project).doWhenFocusSettlesDown(() -> GotoPopupSession.getModelSearchPopup$lambda$7$lambda$6$lambda$5$lambda$4($popupModel, $this_run, $searchPopup));
    }

    private static final Unit getModelSearchPopup$lambda$7$lambda$6(GotoPopupSession $this_run, IMutableViewableMap $popupModel, SearchPopup $searchPopup) {
        SwingUtilities.invokeLater(() -> GotoPopupSession.getModelSearchPopup$lambda$7$lambda$6$lambda$5($this_run, $popupModel, $searchPopup));
        return Unit.INSTANCE;
    }

    private static final Unit getItemsSync$lambda$12$lambda$11$lambda$10(Ref.ObjectRef $result, SyncEventWithInterrupt $syncEvent, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $result.element = it;
        $syncEvent.set();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getItemsSync$lambda$12(GotoPopupSession this$0, LifetimeDefinition $getItemsLifetime, String $text, Boolean $searchInLibraries, Ref.ObjectRef $result, SyncEventWithInterrupt $syncEvent) {
        ReentrantReadWriteLock.ReadLock readLock = this$0.sequentialLifetimesLocks.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)$getItemsLifetime))) {
                return;
            }
            this$0.getItemsAsync((Lifetime)$getItemsLifetime, $text, $searchInLibraries, (Function1<? super String[], Unit>)((Function1)arg_0 -> GotoPopupSession.getItemsSync$lambda$12$lambda$11$lambda$10($result, $syncEvent, arg_0)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private static final Unit getItemsSync$lambda$13(ProgressIndicator $progressIndicator) {
        ProgressIndicator progressIndicator = $progressIndicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        ProgressManager.checkCanceled();
        if (ApplicationManagerEx.getApplicationEx().isWriteActionPending()) {
            throw new ProcessCanceledException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit getItemsAsync$lambda$14(Function1 $whenReady, String[] resultFromBackend) {
        Intrinsics.checkNotNullParameter((Object)resultFromBackend, (String)"resultFromBackend");
        $whenReady.invoke((Object)resultFromBackend);
        return Unit.INSTANCE;
    }

    private static final Unit getItemsAsyncFromBackend$lambda$17(Ref.BooleanRef $hadResult, String $text, GotoPopupSession this$0, Boolean $searchInLibraries) {
        if (!$hadResult.element) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("getItemsAsync.Cancel text: '" + $text + "', kind: '" + this$0.gotoKey + "', searchInLibraries: '" + $searchInLibraries + "'");
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getItemsAsyncFromBackend$lambda$22(Ref.BooleanRef $hadResult, String $text, Boolean $searchInLibraries, GotoPopupSession this$0, int $requestId, Function1 $whenReady, SearchPopup $modelSearchPopup, GotoResultListBase resultFromBackend) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resultFromBackend, (String)"resultFromBackend");
        $hadResult.element = true;
        if (!Intrinsics.areEqual((Object)resultFromBackend.getRequestText(), (Object)$text) || !Intrinsics.areEqual((Object)resultFromBackend.getRequestScope(), (Object)$searchInLibraries) || this$0.perTypeRequestIds.get() != $requestId) {
            logger.trace("Got response for wrong goto request, ignoring it");
            return Unit.INSTANCE;
        }
        logger.debug("Search items task for " + $text + " from " + this$0.gotoKey + " is done. Got " + ((Collection)resultFromBackend.getItems()).size() + " items");
        ArrayList<String> result2 = new ArrayList<String>();
        Iterable iterable = resultFromBackend.getItems();
        boolean $i$f$groupBy = false;
        Iterable iterable2 = iterable;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SearchItemData it = (SearchItemData)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getShortName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            Object object;
            void $this$getOrPut$iv;
            String mainText = (String)entry.getKey();
            List value = (List)entry.getValue();
            result2.add(mainText);
            Map $i$f$groupByTo22 = this$0.shortNameToItemsMap;
            String key$iv = mainText;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                HashMap answer$iv = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            HashMap itemsForText = (HashMap)object;
            Iterable $this$forEach$iv = value;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SearchItemData itemData = (SearchItemData)element$iv;
                boolean bl = false;
                GotoResult it = new GotoResult(itemData, $modelSearchPopup, this$0);
                boolean bl3 = false;
                ((Map)itemsForText).put(itemData, it);
            }
        }
        Collection $this$toTypedArray$iv = result2;
        boolean bl = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $whenReady.invoke((Object)thisCollection$iv.toArray(new String[0]));
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(GotoPopupSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GotoPopupSession.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/gotoType/GotoPopupSession$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

