/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.factories;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.EncryptedAssertionType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.holders.IssuerInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class JBossSAMLAuthnResponseFactory {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static StatusType createStatusType(String statusCodeURI) {
        StatusCodeType sct = new StatusCodeType();
        sct.setValue(URI.create(statusCodeURI));
        StatusType statusType = new StatusType();
        statusType.setStatusCode(sct);
        return statusType;
    }

    public static StatusType createStatusTypeForResponder(String statusCodeURI) {
        StatusCodeType topLevelCode = new StatusCodeType();
        topLevelCode.setValue(JBossSAMLURIConstants.STATUS_RESPONDER.getUri());
        StatusCodeType secondLevelCode = new StatusCodeType();
        secondLevelCode.setValue(URI.create(statusCodeURI));
        topLevelCode.setStatusCode(secondLevelCode);
        StatusType statusType = new StatusType();
        statusType.setStatusCode(topLevelCode);
        return statusType;
    }

    public static ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertionType) {
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        ResponseType responseType = new ResponseType(ID, issueInstant);
        NameIDType issuer = issuerInfo.getIssuer();
        responseType.setIssuer(issuer);
        String statusCode = issuerInfo.getStatusCode();
        if (statusCode == null) {
            throw logger.issuerInfoMissingStatusCodeError();
        }
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusType(statusCode));
        responseType.addAssertion(new ResponseType.RTChoiceType(assertionType));
        return responseType;
    }

    public static ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, Element encryptedAssertion) {
        ResponseType responseType = new ResponseType(ID, XMLTimeUtil.getIssueInstant());
        NameIDType issuer = issuerInfo.getIssuer();
        responseType.setIssuer(issuer);
        String statusCode = issuerInfo.getStatusCode();
        if (statusCode == null) {
            throw logger.issuerInfoMissingStatusCodeError();
        }
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusType(statusCode));
        responseType.addAssertion(new ResponseType.RTChoiceType(new EncryptedAssertionType(encryptedAssertion)));
        return responseType;
    }
}

