/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp;

import org.logstash.snmp.OidFieldMapper;
import org.snmp4j.smi.OID;

public class RubySnmpOidFieldMapper
implements OidFieldMapper {
    @Override
    public String map(OID oid, OidFieldMapper.ResolvedIdentifier[] resolvedOidIdentifiers) {
        if (resolvedOidIdentifiers == null || resolvedOidIdentifiers.length == 0) {
            return oid.toDottedString();
        }
        OidFieldMapper.ResolvedIdentifier lastResolvedIdentifier = resolvedOidIdentifiers[resolvedOidIdentifiers.length - 1];
        if (lastResolvedIdentifier.getData() == null) {
            return oid.toDottedString();
        }
        StringBuilder mappedIdentifier = new StringBuilder();
        String moduleName = lastResolvedIdentifier.getData().getModuleName();
        if (moduleName != null && !moduleName.isEmpty()) {
            mappedIdentifier.append(moduleName);
            mappedIdentifier.append("::");
        }
        mappedIdentifier.append(lastResolvedIdentifier.getData().getName());
        for (int unresolvedIdentifiers = oid.size() - resolvedOidIdentifiers.length; unresolvedIdentifiers > 0; --unresolvedIdentifiers) {
            mappedIdentifier.append(".");
            mappedIdentifier.append(oid.get(oid.size() - unresolvedIdentifiers));
        }
        return mappedIdentifier.toString();
    }
}

