/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.usbserial.ser2net.internal;

import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscovery;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscoveryListener;
import org.openhab.core.io.transport.mdns.MDNSClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={UsbSerialDiscovery.class})
public class Ser2NetUsbSerialDiscovery
implements ServiceListener,
UsbSerialDiscovery {
    private final Logger logger = LoggerFactory.getLogger(Ser2NetUsbSerialDiscovery.class);
    static final String SERVICE_TYPE = "_iostream._tcp.local.";
    static final String PROPERTY_PROVIDER = "provider";
    static final String PROPERTY_DEVICE_TYPE = "devicetype";
    static final String PROPERTY_GENSIO_STACK = "gensiostack";
    static final String PROPERTY_VENDOR_ID = "idVendor";
    static final String PROPERTY_PRODUCT_ID = "idProduct";
    static final String PROPERTY_SERIAL_NUMBER = "serial";
    static final String PROPERTY_MANUFACTURER = "manufacturer";
    static final String PROPERTY_PRODUCT = "product";
    static final String PROPERTY_INTERFACE_NUMBER = "bInterfaceNumber";
    static final String PROPERTY_INTERFACE = "interface";
    static final String SER2NET = "ser2net";
    static final String SERIALUSB = "serialusb";
    static final String TELNET_RFC2217_TCP = "telnet(rfc2217),tcp";
    static final Duration SINGLE_SCAN_DURATION = Duration.ofSeconds(5L);
    static final String SERIAL_PORT_NAME_FORMAT = "rfc2217://%s:%s";
    private final Set<UsbSerialDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<UsbSerialDiscoveryListener>();
    private final MDNSClient mdnsClient;
    private boolean notifyListeners = false;
    private Set<UsbSerialDeviceInformation> lastScanResult = new HashSet<UsbSerialDeviceInformation>();

    @Activate
    public Ser2NetUsbSerialDiscovery(@Reference MDNSClient mdnsClient) {
        this.mdnsClient = mdnsClient;
    }

    public void registerDiscoveryListener(UsbSerialDiscoveryListener listener) {
        this.discoveryListeners.add(listener);
        for (UsbSerialDeviceInformation deviceInfo : this.lastScanResult) {
            listener.usbSerialDeviceDiscovered(deviceInfo);
        }
    }

    public void unregisterDiscoveryListener(UsbSerialDiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    public synchronized void startBackgroundScanning() {
        this.notifyListeners = true;
        this.mdnsClient.addServiceListener(SERVICE_TYPE, (ServiceListener)this);
        this.logger.debug("Started ser2net USB-Serial mDNS background discovery");
    }

    public synchronized void stopBackgroundScanning() {
        this.notifyListeners = false;
        this.mdnsClient.removeServiceListener(SERVICE_TYPE, (ServiceListener)this);
        this.logger.debug("Stopped ser2net USB-Serial mDNS background discovery");
    }

    public synchronized void doSingleScan() {
        this.logger.debug("Starting ser2net USB-Serial mDNS single discovery scan");
        Set scanResult = Stream.of(this.mdnsClient.list(SERVICE_TYPE, SINGLE_SCAN_DURATION)).map(this::createUsbSerialDeviceInformation).flatMap(Optional::stream).collect(Collectors.toSet());
        Set<UsbSerialDeviceInformation> added = this.setDifference(scanResult, this.lastScanResult);
        Set<UsbSerialDeviceInformation> removed = this.setDifference(this.lastScanResult, scanResult);
        Set<UsbSerialDeviceInformation> unchanged = this.setDifference(scanResult, added);
        this.lastScanResult = scanResult;
        removed.forEach(this::announceRemovedDevice);
        added.forEach(this::announceAddedDevice);
        unchanged.forEach(this::announceAddedDevice);
        this.logger.debug("Completed ser2net USB-Serial mDNS single discovery scan");
    }

    private <T> Set<T> setDifference(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.removeAll(set2);
        return result;
    }

    private void announceAddedDevice(UsbSerialDeviceInformation deviceInfo) {
        for (UsbSerialDiscoveryListener listener : this.discoveryListeners) {
            listener.usbSerialDeviceDiscovered(deviceInfo);
        }
    }

    private void announceRemovedDevice(UsbSerialDeviceInformation deviceInfo) {
        for (UsbSerialDiscoveryListener listener : this.discoveryListeners) {
            listener.usbSerialDeviceRemoved(deviceInfo);
        }
    }

    public void serviceAdded(@NonNullByDefault(value={}) ServiceEvent event) {
        if (this.notifyListeners) {
            Optional<UsbSerialDeviceInformation> deviceInfo = this.createUsbSerialDeviceInformation(event.getInfo());
            deviceInfo.ifPresent(this::announceAddedDevice);
        }
    }

    public void serviceRemoved(@NonNullByDefault(value={}) ServiceEvent event) {
        if (this.notifyListeners) {
            Optional<UsbSerialDeviceInformation> deviceInfo = this.createUsbSerialDeviceInformation(event.getInfo());
            deviceInfo.ifPresent(this::announceRemovedDevice);
        }
    }

    public void serviceResolved(@NonNullByDefault(value={}) ServiceEvent event) {
        this.serviceAdded(event);
    }

    private Optional<UsbSerialDeviceInformation> createUsbSerialDeviceInformation(ServiceInfo serviceInfo) {
        String provider = serviceInfo.getPropertyString(PROPERTY_PROVIDER);
        String deviceType = serviceInfo.getPropertyString(PROPERTY_DEVICE_TYPE);
        String gensioStack = serviceInfo.getPropertyString(PROPERTY_GENSIO_STACK);
        if (SER2NET.equals(provider) && deviceType != null && !SERIALUSB.equals(deviceType) || gensioStack != null && !TELNET_RFC2217_TCP.equals(gensioStack)) {
            this.logger.debug("Skipping creation of UsbSerialDeviceInformation based on {}", (Object)serviceInfo);
            return Optional.empty();
        }
        try {
            int vendorId = Integer.parseInt(serviceInfo.getPropertyString(PROPERTY_VENDOR_ID), 16);
            int productId = Integer.parseInt(serviceInfo.getPropertyString(PROPERTY_PRODUCT_ID), 16);
            String serialNumber = serviceInfo.getPropertyString(PROPERTY_SERIAL_NUMBER);
            String manufacturer = serviceInfo.getPropertyString(PROPERTY_MANUFACTURER);
            String product = serviceInfo.getPropertyString(PROPERTY_PRODUCT);
            int interfaceNumber = Integer.parseInt(serviceInfo.getPropertyString(PROPERTY_INTERFACE_NUMBER), 16);
            String interfaceDescription = serviceInfo.getPropertyString(PROPERTY_INTERFACE);
            String serialPortName = String.format(SERIAL_PORT_NAME_FORMAT, serviceInfo.getHostAddresses()[0], serviceInfo.getPort());
            UsbSerialDeviceInformation deviceInfo = new UsbSerialDeviceInformation(vendorId, productId, serialNumber, manufacturer, product, interfaceNumber, interfaceDescription, serialPortName).setRemote(true);
            this.logger.debug("Created {} based on {}", (Object)deviceInfo, (Object)serviceInfo);
            return Optional.of(deviceInfo);
        }
        catch (NumberFormatException e) {
            this.logger.debug("Failed to create UsbSerialDeviceInformation based on {}", (Object)serviceInfo, (Object)e);
            return Optional.empty();
        }
    }
}

