/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.handler.ActionHandler;
import org.openhab.core.automation.module.script.ScriptEngineManager;
import org.openhab.core.automation.module.script.internal.handler.AbstractScriptModuleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptActionHandler
extends AbstractScriptModuleHandler<Action>
implements ActionHandler {
    public static final String TYPE_ID = "script.ScriptAction";
    private final Logger logger = LoggerFactory.getLogger(ScriptActionHandler.class);
    private final Consumer<ScriptActionHandler> onRemoval;

    public ScriptActionHandler(Action module, String ruleUID, ScriptEngineManager scriptEngineManager, Consumer<ScriptActionHandler> onRemoval) {
        super(module, ruleUID, scriptEngineManager);
        this.onRemoval = onRemoval;
    }

    @Override
    public void dispose() {
        this.onRemoval.accept(this);
        super.dispose();
    }

    public void compile() throws ScriptException {
        super.compileScript();
    }

    public @Nullable Map<String, Object> execute(Map<String, Object> context) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.script.isEmpty()) {
            return resultMap;
        }
        this.getScriptEngine().ifPresent(scriptEngine -> {
            try {
                Lock lock;
                if (scriptEngine instanceof Lock && !(lock = (Lock)((Object)scriptEngine)).tryLock(1L, TimeUnit.MINUTES)) {
                    this.logger.error("Failed to acquire lock within one minute for script module '{}' of rule with UID '{}'", (Object)((Action)this.module).getId(), (Object)this.ruleUID);
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            try {
                this.setExecutionContext((ScriptEngine)scriptEngine, context);
                Object result = this.eval((ScriptEngine)scriptEngine);
                resultMap.put("result", result);
                this.resetExecutionContext((ScriptEngine)scriptEngine, context);
            }
            finally {
                if (scriptEngine instanceof Lock) {
                    Lock lock = (Lock)((Object)scriptEngine);
                    lock.unlock();
                }
            }
        });
        return resultMap;
    }
}

