/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SmartSerializer;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RedundantParenthesesQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class PyRedundantParenthesesInspection
extends PyInspection {
    private final SmartSerializer mySerializer = new SmartSerializer();
    public boolean myIgnorePercOperator = false;
    public boolean myIgnoreTupleInReturn = false;
    public boolean myIgnoreEmptyBaseClasses = false;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(2);
        }
        this.mySerializer.writeExternal((Object)this, node);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(3);
        }
        this.mySerializer.readExternal((Object)this, node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTupleWithUnpacking(@NotNull PyExpression expression) {
        if (expression == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(4);
        }
        if (!(expression instanceof PyTupleExpression)) return false;
        if (!ContainerUtil.or((Object[])((PyTupleExpression)expression).getElements(), PyStarExpression.class::isInstance)) return false;
        return true;
    }

    private static boolean oneElementTuple(@NotNull PyExpression expression) {
        if (expression == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(5);
        }
        return expression instanceof PyTupleExpression && ((PyTupleExpression)expression).getElements().length == 1;
    }

    private static boolean isYieldFrom(@NotNull PsiElement element) {
        if (element == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(6);
        }
        return element instanceof PyYieldExpression && ((PyYieldExpression)element).isDelegating();
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myIgnorePercOperator", (String)PyPsiBundle.message("INSP.redundant.parens.ignore.argument.of.operator", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myIgnoreTupleInReturn", (String)PyPsiBundle.message("INSP.redundant.parens.ignore.tuples", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myIgnoreEmptyBaseClasses", (String)PyPsiBundle.message("INSP.redundant.parens.ignore.empty.lists.of.base.classes", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(7);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyRedundantParenthesesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyRedundantParenthesesInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTupleWithUnpacking";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "oneElementTuple";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isYieldFrom";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, TypeEvalContext context) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, context);
        }

        @Override
        public void visitPyParenthesizedExpression(@NotNull PyParenthesizedExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (node.textContains('\n')) {
                return;
            }
            PsiElement parent = node.getParent();
            if (parent instanceof PyParenthesizedExpression) {
                return;
            }
            PyExpression expression = node.getContainedExpression();
            if (expression == null || expression instanceof PyYieldExpression) {
                return;
            }
            if (expression instanceof PyTupleExpression && PyRedundantParenthesesInspection.this.myIgnoreTupleInReturn) {
                return;
            }
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)node);
            if (expression instanceof PyReferenceExpression || expression instanceof PyLiteralExpression) {
                if (PyRedundantParenthesesInspection.this.myIgnorePercOperator && parent instanceof PyBinaryExpression && ((PyBinaryExpression)parent).getOperator() == PyTokenTypes.PERC) {
                    return;
                }
                if (expression instanceof PyNumericLiteralExpression && ((PyNumericLiteralExpression)expression).isIntegerLiteral() && parent instanceof PyReferenceExpression) {
                    return;
                }
                if (parent instanceof PyPrintStatement) {
                    return;
                }
                this.registerProblem((PsiElement)node, PyPsiBundle.message("QFIX.redundant.parentheses", new Object[0]), new LocalQuickFix[]{new RedundantParenthesesQuickFix()});
            } else if (parent instanceof PyIfPart || parent instanceof PyWhilePart) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("QFIX.redundant.parentheses", new Object[0]), new LocalQuickFix[]{new RedundantParenthesesQuickFix()});
            } else if (parent instanceof PyReturnStatement || parent instanceof PyYieldExpression) {
                if (!(PyRedundantParenthesesInspection.isTupleWithUnpacking(expression) && languageLevel.isOlderThan(LanguageLevel.PYTHON38) || PyRedundantParenthesesInspection.oneElementTuple(expression) || PyRedundantParenthesesInspection.isYieldFrom(parent))) {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("QFIX.redundant.parentheses", new Object[0]), new LocalQuickFix[]{new RedundantParenthesesQuickFix()});
                }
            } else if (expression instanceof PyBinaryExpression) {
                PyBinaryExpression binaryExpression = (PyBinaryExpression)expression;
                if (parent instanceof PyPrefixExpression) {
                    return;
                }
                if (binaryExpression.getOperator() == PyTokenTypes.AND_KEYWORD || binaryExpression.getOperator() == PyTokenTypes.OR_KEYWORD) {
                    PyExpression leftExpression = binaryExpression.getLeftExpression();
                    PyExpression rightExpression = binaryExpression.getRightExpression();
                    if (leftExpression instanceof PyParenthesizedExpression && rightExpression instanceof PyParenthesizedExpression && !(((PyParenthesizedExpression)leftExpression).getContainedExpression() instanceof PyBinaryExpression) && !(((PyParenthesizedExpression)rightExpression).getContainedExpression() instanceof PyBinaryExpression)) {
                        this.registerProblem((PsiElement)node, PyPsiBundle.message("QFIX.redundant.parentheses", new Object[0]), new LocalQuickFix[]{new RedundantParenthesesQuickFix()});
                    }
                }
            } else if (expression instanceof PyParenthesizedExpression) {
                this.registerProblem((PsiElement)expression, PyPsiBundle.message("QFIX.redundant.parentheses", new Object[0]), new LocalQuickFix[]{new RedundantParenthesesQuickFix()});
            }
        }

        @Override
        public void visitPyArgumentList(@NotNull PyArgumentList node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (!(node.getParent() instanceof PyClass)) {
                return;
            }
            if (!PyRedundantParenthesesInspection.this.myIgnoreEmptyBaseClasses && node.getArguments().length == 0) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("QFIX.redundant.parentheses", new Object[0]), new LocalQuickFix[]{new RedundantParenthesesQuickFix()});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyRedundantParenthesesInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyParenthesizedExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyArgumentList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

