/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.util.WorkbookUtil;
import org.jxls.common.Context;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.model.DeviceUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Position;
import org.traccar.reports.common.ReportUtils;
import org.traccar.reports.model.DeviceReportSection;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class RouteReportProvider {
    private final Config config;
    private final ReportUtils reportUtils;
    private final Storage storage;
    private final Map<String, Integer> namesCount = new HashMap<String, Integer>();

    @Inject
    public RouteReportProvider(Config config, ReportUtils reportUtils, Storage storage) {
        this.config = config;
        this.reportUtils = reportUtils;
        this.storage = storage;
    }

    public Collection<Position> getObjects(long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to) throws StorageException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<Position> result = new ArrayList<Position>();
        for (Device device : DeviceUtil.getAccessibleDevices(this.storage, userId, deviceIds, groupIds)) {
            result.addAll(PositionUtil.getPositions(this.storage, device.getId(), from, to));
        }
        return result;
    }

    private String getUniqueSheetName(String key) {
        this.namesCount.compute(key, (k, value) -> value == null ? 1 : value + 1);
        return this.namesCount.get(key) > 1 ? key + "-" + String.valueOf(this.namesCount.get(key)) : key;
    }

    public void getExcel(OutputStream outputStream, long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to) throws StorageException, IOException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<DeviceReportSection> devicesRoutes = new ArrayList<DeviceReportSection>();
        ArrayList<String> sheetNames = new ArrayList<String>();
        for (Device device : DeviceUtil.getAccessibleDevices(this.storage, userId, deviceIds, groupIds)) {
            Group group;
            List<Position> positions = PositionUtil.getPositions(this.storage, device.getId(), from, to);
            DeviceReportSection deviceRoutes = new DeviceReportSection();
            deviceRoutes.setDeviceName(device.getName());
            sheetNames.add(WorkbookUtil.createSafeSheetName((String)this.getUniqueSheetName(deviceRoutes.getDeviceName())));
            if (device.getGroupId() > 0L && (group = this.storage.getObject(Group.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", device.getGroupId())))) != null) {
                deviceRoutes.setGroupName(group.getName());
            }
            deviceRoutes.setObjects(positions);
            devicesRoutes.add(deviceRoutes);
        }
        File file = Paths.get(this.config.getString(Keys.TEMPLATES_ROOT), "export", "route.xlsx").toFile();
        try (FileInputStream inputStream = new FileInputStream(file);){
            Context context = this.reportUtils.initializeContext(userId);
            context.putVar("devices", devicesRoutes);
            context.putVar("sheetNames", sheetNames);
            context.putVar("from", (Object)from);
            context.putVar("to", (Object)to);
            this.reportUtils.processTemplateWithSheets(inputStream, outputStream, context);
        }
    }
}

