" Name:         Wild Charm
" Description:  Vibrant and playful, at least one popular AI thinks it is.
" Author:       Maxim Kim <habamax@gmail.com>
" URL:          https://github.com/vim/colorschemes
" License:      Same as Vim
" Last Change:  2025 Oct 22

" Generated by Colortemplate v3.0.0-beta10

hi clear
let g:colors_name = 'wildcharm'

let s:t_Co = has('gui_running') ? 16777216 : str2nr(&t_Co)
let s:tgc = has('termguicolors') && &termguicolors

hi! link CurSearch IncSearch
hi! link CursorLineFold FoldColumn
hi! link CursorLineSign FoldColumn
hi! link Float Number
hi! link Function Identifier
hi! link LineNrAbove LineNr
hi! link LineNrBelow LineNr
hi! link MessageWindow PMenu
hi! link Number Constant
hi! link PopupNotification Normal
hi! link PreInsert NonText
hi! link StatusLineTerm Statusline
hi! link StatusLineTermNC StatuslineNC
hi! link TabPanel Normal
hi! link TabPanelFill Normal
hi! link Terminal Normal

if &background == 'dark'
  let g:terminal_ansi_colors = ['#000000', '#d7005f', '#00af5f', '#d78700', '#0087d7', '#d787d7', '#00afaf', '#d0d0d0', '#767676', '#ff5f87', '#00d75f', '#ffaf00', '#00afff', '#ff87ff', '#00d7d7', '#ffffff']

  hi Normal guifg=#d0d0d0 guibg=#000000 guisp=NONE gui=NONE ctermfg=252 ctermbg=16 cterm=NONE term=NONE
  hi Added guifg=#00af5f guibg=NONE guisp=NONE gui=NONE ctermfg=35 ctermbg=NONE cterm=NONE term=NONE
  hi Changed guifg=#0087d7 guibg=NONE guisp=NONE gui=NONE ctermfg=32 ctermbg=NONE cterm=NONE term=NONE
  hi ColorColumn guifg=NONE guibg=#303030 guisp=NONE gui=NONE ctermfg=NONE ctermbg=236 cterm=NONE term=reverse
  hi Comment guifg=#767676 guibg=NONE guisp=NONE gui=NONE ctermfg=243 ctermbg=NONE cterm=NONE term=bold
  hi Conceal guifg=#585858 guibg=NONE guisp=NONE gui=NONE ctermfg=240 ctermbg=NONE cterm=NONE term=NONE
  hi Constant guifg=#ff5f87 guibg=NONE guisp=NONE gui=NONE ctermfg=204 ctermbg=NONE cterm=NONE term=NONE
  hi CursorColumn guifg=NONE guibg=#262626 guisp=NONE gui=NONE ctermfg=NONE ctermbg=235 cterm=NONE term=NONE
  hi CursorLine guifg=NONE guibg=#262626 guisp=NONE gui=NONE ctermfg=NONE ctermbg=235 cterm=NONE term=underline
  hi CursorLineNr guifg=#ffffff guibg=NONE guisp=NONE gui=bold ctermfg=231 ctermbg=NONE cterm=bold term=bold
  hi DiffAdd guifg=NONE guibg=#273923 guisp=NONE gui=NONE ctermfg=252 ctermbg=22 cterm=NONE term=reverse
  hi DiffChange guifg=NONE guibg=#2f2f2f guisp=NONE gui=NONE ctermfg=252 ctermbg=236 cterm=NONE term=NONE
  hi DiffDelete guifg=#767676 guibg=#2f1f1a guisp=NONE gui=NONE ctermfg=243 ctermbg=52 cterm=NONE term=reverse
  hi DiffText guifg=NONE guibg=#0f4f4f guisp=NONE gui=NONE ctermfg=252 ctermbg=23 cterm=NONE term=reverse
  hi Directory guifg=#00afff guibg=NONE guisp=NONE gui=bold ctermfg=39 ctermbg=NONE cterm=bold term=NONE
  hi EndOfBuffer guifg=#585858 guibg=NONE guisp=NONE gui=NONE ctermfg=240 ctermbg=NONE cterm=NONE term=NONE
  hi Error guifg=#d7005f guibg=#ffffff guisp=NONE gui=reverse ctermfg=161 ctermbg=231 cterm=reverse term=bold,reverse
  hi ErrorMsg guifg=#d7005f guibg=#ffffff guisp=NONE gui=reverse ctermfg=161 ctermbg=231 cterm=reverse term=bold,reverse
  hi FoldColumn guifg=#585858 guibg=NONE guisp=NONE gui=NONE ctermfg=240 ctermbg=NONE cterm=NONE term=NONE
  hi Folded guifg=#767676 guibg=#303030 guisp=NONE gui=NONE ctermfg=243 ctermbg=236 cterm=NONE term=NONE
  hi Identifier guifg=#ff87ff guibg=NONE guisp=NONE gui=NONE ctermfg=213 ctermbg=NONE cterm=NONE term=NONE
  hi Ignore guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=NONE
  hi IncSearch guifg=NONE guibg=#5f431f guisp=NONE gui=NONE ctermfg=214 ctermbg=16 cterm=reverse term=bold,reverse,underline
  hi LineNr guifg=#585858 guibg=NONE guisp=NONE gui=NONE ctermfg=240 ctermbg=NONE cterm=NONE term=NONE
  hi MatchParen guifg=#ff00af guibg=NONE guisp=NONE gui=bold ctermfg=199 ctermbg=NONE cterm=bold term=bold,underline
  hi ModeMsg guifg=NONE guibg=NONE guisp=NONE gui=bold ctermfg=NONE ctermbg=NONE cterm=bold term=bold
  hi MoreMsg guifg=#00d75f guibg=NONE guisp=NONE gui=NONE ctermfg=41 ctermbg=NONE cterm=NONE term=NONE
  hi NonText guifg=#585858 guibg=NONE guisp=NONE gui=NONE ctermfg=240 ctermbg=NONE cterm=NONE term=NONE
  hi Pmenu guifg=NONE guibg=#303030 guisp=NONE gui=NONE ctermfg=NONE ctermbg=236 cterm=NONE term=reverse
  hi PmenuBorder guifg=#767676 guibg=#303030 guisp=NONE gui=NONE ctermfg=243 ctermbg=236 cterm=NONE term=NONE
  hi PmenuExtra guifg=#767676 guibg=#303030 guisp=NONE gui=NONE ctermfg=243 ctermbg=236 cterm=NONE term=NONE
  hi PmenuExtraSel guifg=#767676 guibg=#585858 guisp=NONE gui=NONE ctermfg=243 ctermbg=240 cterm=NONE term=NONE
  hi PmenuKind guifg=#ff5f87 guibg=#303030 guisp=NONE gui=NONE ctermfg=204 ctermbg=236 cterm=NONE term=NONE
  hi PmenuKindSel guifg=#ff5f87 guibg=#585858 guisp=NONE gui=NONE ctermfg=204 ctermbg=240 cterm=NONE term=NONE
  hi PmenuMatch guifg=#d787d7 guibg=#303030 guisp=NONE gui=NONE ctermfg=176 ctermbg=236 cterm=NONE term=NONE
  hi PmenuMatchSel guifg=#d787d7 guibg=#585858 guisp=NONE gui=NONE ctermfg=176 ctermbg=240 cterm=NONE term=NONE
  hi PmenuSbar guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
  hi PmenuSel guifg=NONE guibg=#585858 guisp=NONE gui=NONE ctermfg=NONE ctermbg=240 cterm=NONE term=bold
  hi PmenuShadow guifg=#767676 guibg=#121212 guisp=NONE gui=NONE ctermfg=243 ctermbg=233 cterm=NONE term=NONE
  hi PmenuThumb guifg=NONE guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=NONE ctermbg=252 cterm=NONE term=NONE
  hi PreProc guifg=#00d7d7 guibg=NONE guisp=NONE gui=NONE ctermfg=44 ctermbg=NONE cterm=NONE term=NONE
  hi Question guifg=#ff87ff guibg=NONE guisp=NONE gui=NONE ctermfg=213 ctermbg=NONE cterm=NONE term=standout
  hi QuickFixLine guifg=NONE guibg=#4f2f4f guisp=NONE gui=NONE ctermfg=252 ctermbg=53 cterm=NONE term=NONE
  hi Removed guifg=#d7005f guibg=NONE guisp=NONE gui=NONE ctermfg=161 ctermbg=NONE cterm=NONE term=NONE
  hi Search guifg=NONE guibg=#3a4a3a guisp=NONE gui=NONE ctermfg=41 ctermbg=16 cterm=reverse term=reverse
  hi SignColumn guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
  hi Special guifg=#875fff guibg=NONE guisp=NONE gui=NONE ctermfg=99 ctermbg=NONE cterm=NONE term=NONE
  hi SpecialKey guifg=#585858 guibg=NONE guisp=NONE gui=NONE ctermfg=240 ctermbg=NONE cterm=NONE term=bold
  hi SpellBad guifg=NONE guibg=NONE guisp=#ff5f87 gui=undercurl ctermfg=161 ctermbg=NONE cterm=underline term=underline
  hi SpellCap guifg=NONE guibg=NONE guisp=#00afaf gui=undercurl ctermfg=37 ctermbg=NONE cterm=underline term=underline
  hi SpellLocal guifg=NONE guibg=NONE guisp=#00af5f gui=undercurl ctermfg=41 ctermbg=NONE cterm=underline term=underline
  hi SpellRare guifg=NONE guibg=NONE guisp=#ff87ff gui=undercurl ctermfg=213 ctermbg=NONE cterm=underline term=underline
  hi Statement guifg=#00afff guibg=NONE guisp=NONE gui=NONE ctermfg=39 ctermbg=NONE cterm=NONE term=NONE
  hi StatusLine guifg=#9e9e9e guibg=#000000 guisp=NONE gui=bold,reverse ctermfg=247 ctermbg=16 cterm=bold,reverse term=bold,reverse
  hi StatusLineNC guifg=#767676 guibg=#000000 guisp=NONE gui=reverse ctermfg=243 ctermbg=16 cterm=reverse term=bold,underline
  hi String guifg=#00d75f guibg=NONE guisp=NONE gui=NONE ctermfg=41 ctermbg=NONE cterm=NONE term=NONE
  hi TabLine guifg=#000000 guibg=#767676 guisp=NONE gui=NONE ctermfg=16 ctermbg=243 cterm=NONE term=bold,underline
  hi TabLineFill guifg=#000000 guibg=#767676 guisp=NONE gui=NONE ctermfg=16 ctermbg=243 cterm=NONE term=NONE
  hi TabLineSel guifg=#000000 guibg=#9e9e9e guisp=NONE gui=bold ctermfg=16 ctermbg=247 cterm=bold term=bold,reverse
  hi Title guifg=NONE guibg=NONE guisp=NONE gui=bold ctermfg=NONE ctermbg=NONE cterm=bold term=NONE
  hi TitleBar guifg=#ffffff guibg=#3c3c3c guisp=NONE gui=NONE ctermfg=231 ctermbg=237 cterm=NONE term=NONE
  hi TitleBarNC guifg=#767676 guibg=#2c2c2c guisp=NONE gui=NONE ctermfg=243 ctermbg=236 cterm=NONE term=NONE
  hi Todo guifg=#ffffff guibg=NONE guisp=NONE gui=bold ctermfg=231 ctermbg=NONE cterm=bold term=bold,reverse
  hi ToolbarButton guifg=#000000 guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=16 ctermbg=252 cterm=NONE term=bold,reverse
  hi ToolbarLine guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
  hi Type guifg=#ffaf00 guibg=NONE guisp=NONE gui=NONE ctermfg=214 ctermbg=NONE cterm=NONE term=NONE
  hi Underlined guifg=NONE guibg=NONE guisp=NONE gui=underline ctermfg=NONE ctermbg=NONE cterm=underline term=underline
  hi VertSplit guifg=#767676 guibg=#767676 guisp=NONE gui=NONE ctermfg=243 ctermbg=243 cterm=NONE term=NONE
  hi Visual guifg=NONE guibg=#204060 guisp=NONE gui=NONE ctermfg=81 ctermbg=16 cterm=reverse term=reverse
  hi VisualNOS guifg=#000000 guibg=#00afff guisp=NONE gui=NONE ctermfg=16 ctermbg=39 cterm=NONE term=NONE
  hi WarningMsg guifg=#ffaf00 guibg=NONE guisp=NONE gui=NONE ctermfg=214 ctermbg=NONE cterm=NONE term=standout
  hi WildMenu guifg=#000000 guibg=#ffaf00 guisp=NONE gui=NONE ctermfg=16 ctermbg=214 cterm=NONE term=bold
  hi debugBreakpoint guifg=#00afaf guibg=NONE guisp=NONE gui=reverse ctermfg=37 ctermbg=NONE cterm=reverse term=reverse
  hi debugPC guifg=#0087d7 guibg=NONE guisp=NONE gui=reverse ctermfg=32 ctermbg=NONE cterm=reverse term=reverse

  if has('gui_running') || s:tgc
    hi Cursor guifg=#000000 guibg=#ffffff guisp=NONE gui=NONE cterm=NONE
    hi lCursor guifg=#000000 guibg=#ff5fff guisp=NONE gui=NONE cterm=NONE
  endif

  if s:tgc || s:t_Co >= 256
    if s:tgc
      hi IncSearch cterm=NONE
      hi QuickFixLine cterm=NONE
      hi Search cterm=NONE
      hi Visual cterm=NONE
    endif
    finish
  endif

  if s:t_Co >= 16
    hi Normal ctermfg=grey ctermbg=black cterm=NONE
    hi Added ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi Changed ctermfg=darkblue ctermbg=NONE cterm=NONE
    hi ColorColumn ctermfg=black ctermbg=darkyellow cterm=NONE
    hi Comment ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi Conceal ctermfg=grey ctermbg=NONE cterm=NONE
    hi Constant ctermfg=red ctermbg=NONE cterm=NONE
    hi CursorColumn ctermfg=black ctermbg=yellow cterm=NONE
    hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
    hi CursorLineNr ctermfg=white ctermbg=NONE cterm=bold
    hi DiffAdd ctermfg=black ctermbg=darkgreen cterm=NONE
    hi DiffChange ctermfg=black ctermbg=darkgray cterm=NONE
    hi DiffDelete ctermfg=black ctermbg=darkred cterm=NONE
    hi DiffText ctermfg=black ctermbg=darkcyan cterm=NONE
    hi Directory ctermfg=blue ctermbg=NONE cterm=bold
    hi EndOfBuffer ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi Error ctermfg=darkred ctermbg=white cterm=reverse
    hi ErrorMsg ctermfg=darkred ctermbg=white cterm=reverse
    hi FoldColumn ctermfg=grey ctermbg=NONE cterm=NONE
    hi Folded ctermfg=black ctermbg=NONE cterm=bold
    hi Identifier ctermfg=magenta ctermbg=NONE cterm=NONE
    hi Ignore ctermfg=NONE ctermbg=NONE cterm=NONE
    hi IncSearch ctermfg=yellow ctermbg=black cterm=reverse
    hi LineNr ctermfg=grey ctermbg=NONE cterm=NONE
    hi MatchParen ctermfg=NONE ctermbg=NONE cterm=bold,underline
    hi ModeMsg ctermfg=NONE ctermbg=NONE cterm=bold
    hi MoreMsg ctermfg=green ctermbg=NONE cterm=NONE
    hi NonText ctermfg=grey ctermbg=NONE cterm=NONE
    hi Pmenu ctermfg=black ctermbg=grey cterm=NONE
    hi PmenuBorder ctermfg=NONE ctermbg=grey cterm=NONE
    hi PmenuExtra ctermfg=darkgrey ctermbg=grey cterm=NONE
    hi PmenuExtraSel ctermfg=black ctermbg=darkyellow cterm=NONE
    hi PmenuKind ctermfg=darkred ctermbg=grey cterm=NONE
    hi PmenuKindSel ctermfg=darkred ctermbg=darkyellow cterm=NONE
    hi PmenuMatch ctermfg=black ctermbg=grey cterm=bold
    hi PmenuMatchSel ctermfg=black ctermbg=darkyellow cterm=bold
    hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuSel ctermfg=black ctermbg=darkyellow cterm=NONE
    hi PmenuShadow ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuThumb ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PreProc ctermfg=cyan ctermbg=NONE cterm=NONE
    hi Question ctermfg=magenta ctermbg=NONE cterm=NONE
    hi QuickFixLine ctermfg=black ctermbg=magenta cterm=NONE
    hi Removed ctermfg=darkred ctermbg=NONE cterm=NONE
    hi Search ctermfg=green ctermbg=black cterm=reverse
    hi SignColumn ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Special ctermfg=darkred ctermbg=NONE cterm=NONE
    hi SpecialKey ctermfg=grey ctermbg=NONE cterm=NONE
    hi SpellBad ctermfg=darkred ctermbg=NONE cterm=underline
    hi SpellCap ctermfg=darkcyan ctermbg=NONE cterm=underline
    hi SpellLocal ctermfg=green ctermbg=NONE cterm=underline
    hi SpellRare ctermfg=magenta ctermbg=NONE cterm=underline
    hi Statement ctermfg=blue ctermbg=NONE cterm=NONE
    hi StatusLine ctermfg=grey ctermbg=black cterm=bold,reverse
    hi StatusLineNC ctermfg=darkgrey ctermbg=black cterm=reverse
    hi String ctermfg=green ctermbg=NONE cterm=NONE
    hi TabLine ctermfg=black ctermbg=darkgrey cterm=NONE
    hi TabLineFill ctermfg=black ctermbg=darkgrey cterm=NONE
    hi TabLineSel ctermfg=black ctermbg=grey cterm=bold
    hi Title ctermfg=NONE ctermbg=NONE cterm=bold
    hi TitleBar ctermfg=white ctermbg=black cterm=NONE
    hi TitleBarNC ctermfg=darkgrey ctermbg=black cterm=NONE
    hi Todo ctermfg=NONE ctermbg=NONE cterm=bold
    hi ToolbarButton ctermfg=black ctermbg=grey cterm=NONE
    hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Type ctermfg=yellow ctermbg=NONE cterm=NONE
    hi Underlined ctermfg=NONE ctermbg=NONE cterm=underline
    hi VertSplit ctermfg=darkgrey ctermbg=darkgrey cterm=NONE
    hi Visual ctermfg=cyan ctermbg=black cterm=reverse
    hi VisualNOS ctermfg=black ctermbg=blue cterm=NONE
    hi WarningMsg ctermfg=yellow ctermbg=NONE cterm=NONE
    hi WildMenu ctermfg=black ctermbg=yellow cterm=NONE
    hi debugBreakpoint ctermfg=darkcyan ctermbg=NONE cterm=reverse
    hi debugPC ctermfg=darkblue ctermbg=NONE cterm=reverse
    finish
  endif

  if s:t_Co >= 8
    hi Normal ctermfg=grey ctermbg=black cterm=NONE
    hi Added ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi Changed ctermfg=darkblue ctermbg=NONE cterm=NONE
    hi ColorColumn ctermfg=black ctermbg=darkyellow cterm=NONE
    hi Comment ctermfg=NONE ctermbg=NONE cterm=bold
    hi Conceal ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Constant ctermfg=darkred ctermbg=NONE cterm=NONE
    hi CursorColumn ctermfg=black ctermbg=darkyellow cterm=NONE
    hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
    hi CursorLineNr ctermfg=black ctermbg=NONE cterm=bold
    hi DiffAdd ctermfg=black ctermbg=darkgreen cterm=NONE
    hi DiffChange ctermfg=black ctermbg=darkblue cterm=NONE
    hi DiffDelete ctermfg=black ctermbg=darkred cterm=NONE
    hi DiffText ctermfg=black ctermbg=darkmagenta cterm=NONE
    hi Directory ctermfg=darkblue ctermbg=NONE cterm=bold
    hi EndOfBuffer ctermfg=grey ctermbg=NONE cterm=NONE
    hi Error ctermfg=grey ctermbg=darkred cterm=NONE
    hi ErrorMsg ctermfg=grey ctermbg=darkred cterm=NONE
    hi FoldColumn ctermfg=black ctermbg=NONE cterm=NONE
    hi Folded ctermfg=grey ctermbg=NONE cterm=bold
    hi Identifier ctermfg=darkmagenta ctermbg=NONE cterm=NONE
    hi Ignore ctermfg=NONE ctermbg=NONE cterm=NONE
    hi IncSearch ctermfg=darkyellow ctermbg=black cterm=reverse
    hi LineNr ctermfg=darkyellow ctermbg=NONE cterm=NONE
    hi MatchParen ctermfg=NONE ctermbg=NONE cterm=bold,underline
    hi ModeMsg ctermfg=NONE ctermbg=NONE cterm=bold
    hi MoreMsg ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi NonText ctermfg=black ctermbg=NONE cterm=NONE
    hi Pmenu ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PmenuBorder ctermfg=darkgrey ctermbg=darkgrey cterm=NONE
    hi PmenuExtra ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PmenuExtraSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuKind ctermfg=NONE ctermbg=NONE cterm=bold,reverse
    hi PmenuKindSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuMatch ctermfg=NONE ctermbg=darkred cterm=reverse
    hi PmenuMatchSel ctermfg=darkred ctermbg=NONE cterm=bold
    hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuShadow ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuThumb ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PreProc ctermfg=darkcyan ctermbg=NONE cterm=NONE
    hi Question ctermfg=darkmagenta ctermbg=NONE cterm=NONE
    hi QuickFixLine ctermfg=black ctermbg=darkmagenta cterm=NONE
    hi Removed ctermfg=darkred ctermbg=NONE cterm=NONE
    hi Search ctermfg=darkgreen ctermbg=black cterm=reverse
    hi SignColumn ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Special ctermfg=darkmagenta ctermbg=NONE cterm=NONE
    hi SpecialKey ctermfg=black ctermbg=NONE cterm=NONE
    hi SpellBad ctermfg=darkred ctermbg=NONE cterm=reverse
    hi SpellCap ctermfg=darkcyan ctermbg=NONE cterm=reverse
    hi SpellLocal ctermfg=darkgreen ctermbg=black cterm=reverse
    hi SpellRare ctermfg=darkmagenta ctermbg=NONE cterm=reverse
    hi Statement ctermfg=darkblue ctermbg=NONE cterm=NONE
    hi StatusLine ctermfg=grey ctermbg=black cterm=bold,reverse
    hi StatusLineNC ctermfg=black ctermbg=grey cterm=NONE
    hi String ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi TabLine ctermfg=black ctermbg=grey cterm=NONE
    hi TabLineFill ctermfg=grey ctermbg=grey cterm=NONE
    hi TabLineSel ctermfg=grey ctermbg=black cterm=bold,reverse
    hi Title ctermfg=NONE ctermbg=NONE cterm=bold
    hi TitleBar ctermfg=white ctermbg=black cterm=NONE
    hi TitleBarNC ctermfg=darkgrey ctermbg=black cterm=NONE
    hi Todo ctermfg=NONE ctermbg=NONE cterm=bold
    hi ToolbarButton ctermfg=grey ctermbg=black cterm=bold,reverse
    hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Type ctermfg=darkyellow ctermbg=NONE cterm=NONE
    hi Underlined ctermfg=NONE ctermbg=NONE cterm=underline
    hi VertSplit ctermfg=grey ctermbg=grey cterm=NONE
    hi Visual ctermfg=darkblue ctermbg=black cterm=reverse
    hi VisualNOS ctermfg=black ctermbg=darkblue cterm=NONE
    hi WarningMsg ctermfg=darkyellow ctermbg=NONE cterm=NONE
    hi WildMenu ctermfg=black ctermbg=darkyellow cterm=NONE
    hi debugBreakpoint ctermfg=darkcyan ctermbg=NONE cterm=reverse
    hi debugPC ctermfg=darkblue ctermbg=NONE cterm=reverse
    finish
  endif

  if s:t_Co >= 0
    hi CurSearch term=reverse
    hi Cursor term=reverse
    hi CursorIM term=NONE
    hi CursorLineFold term=underline
    hi CursorLineSign term=underline
    hi Float term=NONE
    hi Function term=NONE
    hi Number term=NONE
    hi StatusLineTerm term=bold,reverse
    hi StatusLineTermNC term=bold,underline
    hi Terminal term=NONE
    finish
  endif

  finish
endif

if &background == 'light'
  let g:terminal_ansi_colors = ['#000000', '#af0000', '#008700', '#af5f00', '#005faf', '#870087', '#008787', '#8a8a8a', '#808080', '#d70000', '#5faf5f', '#d78700', '#0087d7', '#af00af', '#00afaf', '#ffffff']

  hi Normal guifg=#000000 guibg=#ffffff guisp=NONE gui=NONE ctermfg=16 ctermbg=231 cterm=NONE term=NONE
  hi Added guifg=#5faf5f guibg=NONE guisp=NONE gui=NONE ctermfg=71 ctermbg=NONE cterm=NONE term=NONE
  hi Changed guifg=#0087d7 guibg=NONE guisp=NONE gui=NONE ctermfg=32 ctermbg=NONE cterm=NONE term=NONE
  hi ColorColumn guifg=NONE guibg=#e4e4e4 guisp=NONE gui=NONE ctermfg=NONE ctermbg=254 cterm=NONE term=reverse
  hi Comment guifg=#8a8a8a guibg=NONE guisp=NONE gui=NONE ctermfg=245 ctermbg=NONE cterm=NONE term=bold
  hi Conceal guifg=#a8a8a8 guibg=NONE guisp=NONE gui=NONE ctermfg=248 ctermbg=NONE cterm=NONE term=NONE
  hi Constant guifg=#af0000 guibg=NONE guisp=NONE gui=NONE ctermfg=124 ctermbg=NONE cterm=NONE term=NONE
  hi CursorColumn guifg=NONE guibg=#eeeeee guisp=NONE gui=NONE ctermfg=NONE ctermbg=255 cterm=NONE term=NONE
  hi CursorLine guifg=NONE guibg=#eeeeee guisp=NONE gui=NONE ctermfg=NONE ctermbg=255 cterm=NONE term=underline
  hi CursorLineNr guifg=#000000 guibg=NONE guisp=NONE gui=bold ctermfg=16 ctermbg=NONE cterm=bold term=bold
  hi DiffAdd guifg=NONE guibg=#dafada guisp=NONE gui=NONE ctermfg=16 ctermbg=151 cterm=NONE term=reverse
  hi DiffChange guifg=NONE guibg=#e3e3e3 guisp=NONE gui=NONE ctermfg=16 ctermbg=253 cterm=NONE term=NONE
  hi DiffDelete guifg=#808080 guibg=#ffd7d7 guisp=NONE gui=NONE ctermfg=240 ctermbg=224 cterm=NONE term=reverse
  hi DiffText guifg=NONE guibg=#bfe7e7 guisp=NONE gui=NONE ctermfg=16 ctermbg=152 cterm=NONE term=reverse
  hi Directory guifg=#005faf guibg=NONE guisp=NONE gui=bold ctermfg=25 ctermbg=NONE cterm=bold term=NONE
  hi EndOfBuffer guifg=#a8a8a8 guibg=NONE guisp=NONE gui=NONE ctermfg=248 ctermbg=NONE cterm=NONE term=NONE
  hi Error guifg=#af0000 guibg=#ffffff guisp=NONE gui=reverse ctermfg=124 ctermbg=231 cterm=reverse term=bold,reverse
  hi ErrorMsg guifg=#d70000 guibg=#ffffff guisp=NONE gui=reverse ctermfg=160 ctermbg=231 cterm=reverse term=bold,reverse
  hi FoldColumn guifg=#a8a8a8 guibg=NONE guisp=NONE gui=NONE ctermfg=248 ctermbg=NONE cterm=NONE term=NONE
  hi Folded guifg=#808080 guibg=#e4e4e4 guisp=NONE gui=NONE ctermfg=240 ctermbg=254 cterm=NONE term=NONE
  hi Identifier guifg=#870087 guibg=NONE guisp=NONE gui=NONE ctermfg=90 ctermbg=NONE cterm=NONE term=NONE
  hi Ignore guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=NONE
  hi IncSearch guifg=NONE guibg=#fff0cf guisp=NONE gui=NONE ctermfg=172 ctermbg=231 cterm=reverse term=bold,reverse,underline
  hi LineNr guifg=#a8a8a8 guibg=NONE guisp=NONE gui=NONE ctermfg=248 ctermbg=NONE cterm=NONE term=NONE
  hi MatchParen guifg=#ff00af guibg=NONE guisp=NONE gui=bold ctermfg=199 ctermbg=NONE cterm=bold term=bold,underline
  hi ModeMsg guifg=NONE guibg=NONE guisp=NONE gui=bold ctermfg=NONE ctermbg=NONE cterm=bold term=bold
  hi MoreMsg guifg=#008700 guibg=NONE guisp=NONE gui=NONE ctermfg=28 ctermbg=NONE cterm=NONE term=NONE
  hi NonText guifg=#a8a8a8 guibg=NONE guisp=NONE gui=NONE ctermfg=248 ctermbg=NONE cterm=NONE term=NONE
  hi Pmenu guifg=NONE guibg=#e4e4e4 guisp=NONE gui=NONE ctermfg=NONE ctermbg=254 cterm=NONE term=reverse
  hi PmenuBorder guifg=#808080 guibg=#e4e4e4 guisp=NONE gui=NONE ctermfg=240 ctermbg=254 cterm=NONE term=NONE
  hi PmenuExtra guifg=#808080 guibg=#e4e4e4 guisp=NONE gui=NONE ctermfg=240 ctermbg=254 cterm=NONE term=NONE
  hi PmenuExtraSel guifg=#808080 guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=240 ctermbg=252 cterm=NONE term=NONE
  hi PmenuKind guifg=#d70000 guibg=#e4e4e4 guisp=NONE gui=NONE ctermfg=160 ctermbg=254 cterm=NONE term=NONE
  hi PmenuKindSel guifg=#d70000 guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=160 ctermbg=252 cterm=NONE term=NONE
  hi PmenuMatch guifg=#870087 guibg=#e4e4e4 guisp=NONE gui=NONE ctermfg=90 ctermbg=254 cterm=NONE term=NONE
  hi PmenuMatchSel guifg=#870087 guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=90 ctermbg=252 cterm=NONE term=NONE
  hi PmenuSbar guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
  hi PmenuSel guifg=NONE guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=NONE ctermbg=252 cterm=NONE term=bold
  hi PmenuShadow guifg=#808080 guibg=#303030 guisp=NONE gui=NONE ctermfg=240 ctermbg=236 cterm=NONE term=NONE
  hi PmenuThumb guifg=NONE guibg=#808080 guisp=NONE gui=NONE ctermfg=NONE ctermbg=240 cterm=NONE term=NONE
  hi PreProc guifg=#008787 guibg=NONE guisp=NONE gui=NONE ctermfg=30 ctermbg=NONE cterm=NONE term=NONE
  hi Question guifg=#870087 guibg=NONE guisp=NONE gui=NONE ctermfg=90 ctermbg=NONE cterm=NONE term=standout
  hi QuickFixLine guifg=NONE guibg=#e7cfe7 guisp=NONE gui=NONE ctermfg=16 ctermbg=182 cterm=NONE term=NONE
  hi Removed guifg=#d70000 guibg=NONE guisp=NONE gui=NONE ctermfg=160 ctermbg=NONE cterm=NONE term=NONE
  hi Search guifg=NONE guibg=#e7f3e7 guisp=NONE gui=NONE ctermfg=28 ctermbg=231 cterm=reverse term=reverse
  hi SignColumn guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
  hi Special guifg=#5f00d7 guibg=NONE guisp=NONE gui=NONE ctermfg=56 ctermbg=NONE cterm=NONE term=NONE
  hi SpecialKey guifg=#a8a8a8 guibg=NONE guisp=NONE gui=NONE ctermfg=248 ctermbg=NONE cterm=NONE term=bold
  hi SpellBad guifg=NONE guibg=NONE guisp=#af0000 gui=undercurl ctermfg=160 ctermbg=NONE cterm=underline term=underline
  hi SpellCap guifg=NONE guibg=NONE guisp=#008787 gui=undercurl ctermfg=30 ctermbg=NONE cterm=underline term=underline
  hi SpellLocal guifg=NONE guibg=NONE guisp=#008700 gui=undercurl ctermfg=28 ctermbg=NONE cterm=underline term=underline
  hi SpellRare guifg=NONE guibg=NONE guisp=#af00af gui=undercurl ctermfg=127 ctermbg=NONE cterm=underline term=underline
  hi Statement guifg=#005faf guibg=NONE guisp=NONE gui=NONE ctermfg=25 ctermbg=NONE cterm=NONE term=NONE
  hi StatusLine guifg=#ffffff guibg=#5f5f5f guisp=NONE gui=bold ctermfg=231 ctermbg=59 cterm=bold term=bold,reverse
  hi StatusLineNC guifg=#000000 guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=16 ctermbg=252 cterm=NONE term=bold,underline
  hi String guifg=#008700 guibg=NONE guisp=NONE gui=NONE ctermfg=28 ctermbg=NONE cterm=NONE term=NONE
  hi TabLine guifg=#000000 guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=16 ctermbg=252 cterm=NONE term=bold,underline
  hi TabLineFill guifg=#d0d0d0 guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=252 ctermbg=252 cterm=NONE term=NONE
  hi TabLineSel guifg=#5f5f5f guibg=#ffffff guisp=NONE gui=bold,reverse ctermfg=59 ctermbg=231 cterm=bold,reverse term=bold,reverse
  hi Title guifg=NONE guibg=NONE guisp=NONE gui=bold ctermfg=NONE ctermbg=NONE cterm=bold term=NONE
  hi TitleBar guifg=#000000 guibg=#ececec guisp=NONE gui=NONE ctermfg=16 ctermbg=255 cterm=NONE term=NONE
  hi TitleBarNC guifg=#808080 guibg=#f5f5f5 guisp=NONE gui=NONE ctermfg=240 ctermbg=255 cterm=NONE term=NONE
  hi Todo guifg=NONE guibg=NONE guisp=NONE gui=bold ctermfg=NONE ctermbg=NONE cterm=bold term=bold,reverse
  hi ToolbarButton guifg=#ffffff guibg=#5f5f5f guisp=NONE gui=NONE ctermfg=231 ctermbg=59 cterm=NONE term=bold,reverse
  hi ToolbarLine guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
  hi Type guifg=#af5f00 guibg=NONE guisp=NONE gui=NONE ctermfg=130 ctermbg=NONE cterm=NONE term=NONE
  hi Underlined guifg=NONE guibg=NONE guisp=NONE gui=underline ctermfg=NONE ctermbg=NONE cterm=underline term=underline
  hi VertSplit guifg=#d0d0d0 guibg=#d0d0d0 guisp=NONE gui=NONE ctermfg=252 ctermbg=252 cterm=NONE term=NONE
  hi Visual guifg=NONE guibg=#bfdfff guisp=NONE gui=NONE ctermfg=32 ctermbg=231 cterm=reverse term=reverse
  hi VisualNOS guifg=#ffffff guibg=#005faf guisp=NONE gui=NONE ctermfg=231 ctermbg=25 cterm=NONE term=NONE
  hi WarningMsg guifg=#af5f00 guibg=NONE guisp=NONE gui=NONE ctermfg=130 ctermbg=NONE cterm=NONE term=standout
  hi WildMenu guifg=#ffffff guibg=#d78700 guisp=NONE gui=NONE ctermfg=231 ctermbg=172 cterm=NONE term=bold
  hi debugBreakpoint guifg=#008787 guibg=NONE guisp=NONE gui=reverse ctermfg=30 ctermbg=NONE cterm=reverse term=reverse
  hi debugPC guifg=#005faf guibg=NONE guisp=NONE gui=reverse ctermfg=25 ctermbg=NONE cterm=reverse term=reverse

  if has('gui_running') || s:tgc
    hi Cursor guifg=#ffffff guibg=#000000 guisp=NONE gui=NONE cterm=NONE
    hi lCursor guifg=#000000 guibg=#ff00ff guisp=NONE gui=NONE cterm=NONE
  endif

  if s:tgc || s:t_Co >= 256
    if s:tgc
      hi IncSearch cterm=NONE
      hi QuickFixLine cterm=NONE
      hi Search cterm=NONE
      hi Visual cterm=NONE
    endif
    finish
  endif

  if s:t_Co >= 16
    hi Normal ctermfg=black ctermbg=white cterm=NONE
    hi Added ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi Changed ctermfg=darkblue ctermbg=NONE cterm=NONE
    hi ColorColumn ctermfg=black ctermbg=darkyellow cterm=NONE
    hi Comment ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi Conceal ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi Constant ctermfg=darkred ctermbg=NONE cterm=NONE
    hi CursorColumn ctermfg=black ctermbg=yellow cterm=NONE
    hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
    hi CursorLineNr ctermfg=black ctermbg=NONE cterm=bold
    hi DiffAdd ctermfg=black ctermbg=darkgreen cterm=NONE
    hi DiffChange ctermfg=black ctermbg=lightgray cterm=NONE
    hi DiffDelete ctermfg=black ctermbg=darkred cterm=NONE
    hi DiffText ctermfg=black ctermbg=cyan cterm=NONE
    hi Directory ctermfg=darkblue ctermbg=NONE cterm=bold
    hi EndOfBuffer ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi Error ctermfg=darkred ctermbg=white cterm=reverse
    hi ErrorMsg ctermfg=red ctermbg=white cterm=reverse
    hi FoldColumn ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi Folded ctermfg=black ctermbg=NONE cterm=bold
    hi Identifier ctermfg=darkmagenta ctermbg=NONE cterm=NONE
    hi Ignore ctermfg=NONE ctermbg=NONE cterm=NONE
    hi IncSearch ctermfg=yellow ctermbg=white cterm=reverse
    hi LineNr ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi MatchParen ctermfg=NONE ctermbg=NONE cterm=bold,underline
    hi ModeMsg ctermfg=NONE ctermbg=NONE cterm=bold
    hi MoreMsg ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi NonText ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi Pmenu ctermfg=black ctermbg=grey cterm=NONE
    hi PmenuBorder ctermfg=black ctermbg=grey cterm=NONE
    hi PmenuExtra ctermfg=darkgrey ctermbg=grey cterm=NONE
    hi PmenuExtraSel ctermfg=black ctermbg=darkyellow cterm=NONE
    hi PmenuKind ctermfg=darkred ctermbg=grey cterm=NONE
    hi PmenuKindSel ctermfg=darkred ctermbg=darkyellow cterm=NONE
    hi PmenuMatch ctermfg=black ctermbg=grey cterm=bold
    hi PmenuMatchSel ctermfg=black ctermbg=darkyellow cterm=bold
    hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuSel ctermfg=black ctermbg=darkyellow cterm=NONE
    hi PmenuShadow ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuThumb ctermfg=NONE ctermbg=darkgreen cterm=NONE
    hi PreProc ctermfg=darkcyan ctermbg=NONE cterm=NONE
    hi Question ctermfg=darkmagenta ctermbg=NONE cterm=NONE
    hi QuickFixLine ctermfg=black ctermbg=magenta cterm=NONE
    hi Removed ctermfg=darkred ctermbg=NONE cterm=NONE
    hi Search ctermfg=darkgreen ctermbg=white cterm=reverse
    hi SignColumn ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Special ctermfg=blue ctermbg=NONE cterm=NONE
    hi SpecialKey ctermfg=darkgrey ctermbg=NONE cterm=NONE
    hi SpellBad ctermfg=red ctermbg=NONE cterm=underline
    hi SpellCap ctermfg=darkcyan ctermbg=NONE cterm=underline
    hi SpellLocal ctermfg=darkgreen ctermbg=NONE cterm=underline
    hi SpellRare ctermfg=magenta ctermbg=NONE cterm=underline
    hi Statement ctermfg=darkblue ctermbg=NONE cterm=NONE
    hi StatusLine ctermfg=white ctermbg=darkgrey cterm=bold
    hi StatusLineNC ctermfg=black ctermbg=lightgrey cterm=NONE
    hi String ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi TabLine ctermfg=black ctermbg=lightgrey cterm=NONE
    hi TabLineFill ctermfg=lightgrey ctermbg=lightgrey cterm=NONE
    hi TabLineSel ctermfg=darkgrey ctermbg=white cterm=bold,reverse
    hi Title ctermfg=NONE ctermbg=NONE cterm=bold
    hi TitleBar ctermfg=black ctermbg=white cterm=NONE
    hi TitleBarNC ctermfg=darkgrey ctermbg=white cterm=NONE
    hi Todo ctermfg=NONE ctermbg=NONE cterm=bold
    hi ToolbarButton ctermfg=white ctermbg=darkgrey cterm=NONE
    hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Type ctermfg=darkyellow ctermbg=NONE cterm=NONE
    hi Underlined ctermfg=NONE ctermbg=NONE cterm=underline
    hi VertSplit ctermfg=lightgrey ctermbg=lightgrey cterm=NONE
    hi Visual ctermfg=blue ctermbg=white cterm=reverse
    hi VisualNOS ctermfg=white ctermbg=darkblue cterm=NONE
    hi WarningMsg ctermfg=darkyellow ctermbg=NONE cterm=NONE
    hi WildMenu ctermfg=white ctermbg=yellow cterm=NONE
    hi debugBreakpoint ctermfg=darkcyan ctermbg=NONE cterm=reverse
    hi debugPC ctermfg=darkblue ctermbg=NONE cterm=reverse
    finish
  endif

  if s:t_Co >= 8
    hi Normal ctermfg=black ctermbg=grey cterm=NONE
    hi Added ctermfg=green ctermbg=NONE cterm=NONE
    hi Changed ctermfg=blue ctermbg=NONE cterm=NONE
    hi ColorColumn ctermfg=black ctermbg=darkyellow cterm=NONE
    hi Comment ctermfg=NONE ctermbg=NONE cterm=bold
    hi Conceal ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Constant ctermfg=darkred ctermbg=NONE cterm=NONE
    hi CursorColumn ctermfg=black ctermbg=darkyellow cterm=NONE
    hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
    hi CursorLineNr ctermfg=black ctermbg=NONE cterm=bold
    hi DiffAdd ctermfg=black ctermbg=darkgreen cterm=NONE
    hi DiffChange ctermfg=black ctermbg=darkblue cterm=NONE
    hi DiffDelete ctermfg=black ctermbg=darkred cterm=NONE
    hi DiffText ctermfg=black ctermbg=darkmagenta cterm=NONE
    hi Directory ctermfg=darkblue ctermbg=NONE cterm=bold
    hi EndOfBuffer ctermfg=black ctermbg=NONE cterm=NONE
    hi Error ctermfg=white ctermbg=darkred cterm=NONE
    hi ErrorMsg ctermfg=white ctermbg=darkred cterm=NONE
    hi FoldColumn ctermfg=black ctermbg=NONE cterm=NONE
    hi Folded ctermfg=black ctermbg=NONE cterm=bold
    hi Identifier ctermfg=darkmagenta ctermbg=NONE cterm=NONE
    hi Ignore ctermfg=NONE ctermbg=NONE cterm=NONE
    hi IncSearch ctermfg=darkyellow ctermbg=black cterm=reverse
    hi LineNr ctermfg=darkyellow ctermbg=NONE cterm=NONE
    hi MatchParen ctermfg=NONE ctermbg=NONE cterm=bold,underline
    hi ModeMsg ctermfg=NONE ctermbg=NONE cterm=bold
    hi MoreMsg ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi NonText ctermfg=black ctermbg=NONE cterm=NONE
    hi Pmenu ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PmenuBorder ctermfg=darkgrey ctermbg=grey cterm=NONE
    hi PmenuExtra ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PmenuExtraSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuKind ctermfg=NONE ctermbg=NONE cterm=bold,reverse
    hi PmenuKindSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuMatch ctermfg=NONE ctermbg=darkred cterm=reverse
    hi PmenuMatchSel ctermfg=darkred ctermbg=NONE cterm=bold
    hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuSel ctermfg=NONE ctermbg=NONE cterm=bold
    hi PmenuShadow ctermfg=NONE ctermbg=NONE cterm=NONE
    hi PmenuThumb ctermfg=NONE ctermbg=NONE cterm=reverse
    hi PreProc ctermfg=darkcyan ctermbg=NONE cterm=NONE
    hi Question ctermfg=darkmagenta ctermbg=NONE cterm=NONE
    hi QuickFixLine ctermfg=black ctermbg=darkmagenta cterm=NONE
    hi Removed ctermfg=red ctermbg=NONE cterm=NONE
    hi Search ctermfg=darkgreen ctermbg=black cterm=reverse
    hi SignColumn ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Special ctermfg=darkmagenta ctermbg=NONE cterm=NONE
    hi SpecialKey ctermfg=black ctermbg=NONE cterm=NONE
    hi SpellBad ctermfg=darkred ctermbg=black cterm=reverse
    hi SpellCap ctermfg=darkcyan ctermbg=black cterm=reverse
    hi SpellLocal ctermfg=darkgreen ctermbg=black cterm=reverse
    hi SpellRare ctermfg=darkmagenta ctermbg=black cterm=reverse
    hi Statement ctermfg=darkblue ctermbg=NONE cterm=NONE
    hi StatusLine ctermfg=grey ctermbg=black cterm=bold
    hi StatusLineNC ctermfg=grey ctermbg=black cterm=NONE
    hi String ctermfg=darkgreen ctermbg=NONE cterm=NONE
    hi TabLine ctermfg=grey ctermbg=black cterm=NONE
    hi TabLineFill ctermfg=black ctermbg=black cterm=NONE
    hi TabLineSel ctermfg=black ctermbg=grey cterm=bold,reverse
    hi Title ctermfg=NONE ctermbg=NONE cterm=bold
    hi TitleBar ctermfg=black ctermbg=white cterm=NONE
    hi TitleBarNC ctermfg=darkgrey ctermbg=white cterm=NONE
    hi Todo ctermfg=NONE ctermbg=NONE cterm=bold
    hi ToolbarButton ctermfg=grey ctermbg=black cterm=bold
    hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
    hi Type ctermfg=darkyellow ctermbg=NONE cterm=NONE
    hi Underlined ctermfg=NONE ctermbg=NONE cterm=underline
    hi VertSplit ctermfg=black ctermbg=black cterm=NONE
    hi Visual ctermfg=darkblue ctermbg=grey cterm=reverse
    hi VisualNOS ctermfg=black ctermbg=darkblue cterm=NONE
    hi WarningMsg ctermfg=darkyellow ctermbg=NONE cterm=NONE
    hi WildMenu ctermfg=black ctermbg=darkyellow cterm=NONE
    hi debugBreakpoint ctermfg=darkcyan ctermbg=NONE cterm=reverse
    hi debugPC ctermfg=darkblue ctermbg=NONE cterm=reverse
    finish
  endif

  if s:t_Co >= 0
    hi CurSearch term=reverse
    hi Cursor term=reverse
    hi CursorIM term=NONE
    hi CursorLineFold term=underline
    hi CursorLineSign term=underline
    hi Float term=NONE
    hi Function term=NONE
    hi Number term=NONE
    hi StatusLineTerm term=bold,reverse
    hi StatusLineTermNC term=bold,underline
    hi Terminal term=NONE
    finish
  endif

endif

" vim: et ts=8 sw=2 sts=2
