/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.preferences.PropertiesStorage;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class NbPreferences
extends AbstractPreferences
implements ChangeListener {
    private static Preferences USER_ROOT;
    private static Preferences SYSTEM_ROOT;
    private ThreadLocal<Boolean> localThread = new ThreadLocal();
    private ArrayList<String> keyEntries = new ArrayList();
    HashMap<String, ArrayList<String>> cachedKeyValues = new HashMap();
    EditableProperties properties;
    FileStorage fileStorage;
    private static final RequestProcessor RP;
    final RequestProcessor.Task flushTask = RP.create(new Runnable(){

        @Override
        public void run() {
            NbPreferences.this.fileStorage.runAtomic(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = NbPreferences.this.lock;
                    synchronized (object) {
                        try {
                            NbPreferences.this.flushSpi();
                        }
                        catch (BackingStoreException backingStoreException) {
                            Exceptions.printStackTrace((Throwable)backingStoreException);
                        }
                    }
                }
            });
        }
    }, true);

    public static Preferences userRootImpl() {
        if (USER_ROOT == null) {
            USER_ROOT = new UserPreferences();
        }
        assert (USER_ROOT != null);
        return USER_ROOT;
    }

    public static Preferences systemRootImpl() {
        if (SYSTEM_ROOT == null) {
            SYSTEM_ROOT = new SystemPreferences();
        }
        assert (SYSTEM_ROOT != null);
        return SYSTEM_ROOT;
    }

    private NbPreferences(boolean bl) {
        super(null, "");
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.fileStorage.attachChangeListener(this);
    }

    private NbPreferences(NbPreferences nbPreferences, String string) {
        super(nbPreferences, string);
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.newNode = !this.fileStorage.existsNode();
        this.fileStorage.attachChangeListener(this);
    }

    @Override
    protected final String getSpi(String string) {
        return this.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.properties().getProperty(string);
        }
    }

    @Override
    protected final String[] childrenNamesSpi() throws BackingStoreException {
        return this.fileStorage.childrenNames();
    }

    @Override
    protected final String[] keysSpi() throws BackingStoreException {
        return this.getKeysSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeysSpi() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            Set set = this.properties().keySet();
            return set.toArray(new String[0]);
        }
    }

    @Override
    protected final void putSpi(String string, String string2) {
        this.putProperty(string, string2);
        if (Boolean.TRUE.equals(this.localThread.get())) {
            return;
        }
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putProperty(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.properties().put(string, string2);
        }
    }

    @Override
    public void put(String string, String string2) {
        this.put(string, string2, false);
    }

    public void put(String string, String string2, boolean bl) {
        String string3 = this.getSpi(string);
        if (string2.equals(string3)) {
            return;
        }
        try {
            if (super.isRemoved()) {
                return;
            }
            ArrayList<String> arrayList = this.cachedKeyValues.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (bl) {
                if (arrayList.contains(string2)) {
                    return;
                }
            } else {
                arrayList.add(string2);
                if (arrayList.size() > 1000) {
                    arrayList.subList(0, 900).clear();
                }
                this.cachedKeyValues.put(string, arrayList);
            }
            super.put(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().contains("too long")) {
                this.putSpi(string, string2);
            }
            throw illegalArgumentException;
        }
    }

    @Override
    protected final void removeSpi(String string) {
        this.removeProperty(string);
        this.keyEntries.remove(string);
        this.cachedKeyValues.remove(string);
        if (Boolean.TRUE.equals(this.localThread.get())) {
            return;
        }
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperty(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.properties().remove((Object)string);
        }
    }

    @Override
    protected final void removeNodeSpi() throws BackingStoreException {
        try {
            this.fileStorage.removeNode();
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    private void asyncInvocationOfFlushSpi() {
        if (!this.fileStorage.isReadOnly()) {
            this.flushTask.schedule(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.fileStorage.save(this.properties());
            }
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.properties != null) {
            try {
                this.putAllProperties(this.fileStorage.load(), true);
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
    }

    private EditableProperties properties() {
        if (this.properties == null) {
            this.properties = new EditableProperties(true);
            try {
                this.putAllProperties(this.fileStorage.load(), false);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAllProperties(EditableProperties editableProperties, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (bl) {
                this.properties().clear();
            }
            this.properties().putAll((Map)editableProperties);
        }
    }

    @Override
    public final void removeNode() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        if (super.isRemoved()) {
            return;
        }
        this.clearProperties();
        super.removeNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProperties() {
        Object object = this.lock;
        synchronized (object) {
            this.properties().clear();
            this.keyEntries.clear();
            this.cachedKeyValues.clear();
        }
    }

    @Override
    public final void flush() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        super.flush();
        this.cachedKeyValues.clear();
    }

    @Override
    public final void sync() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        if (super.isRemoved()) {
            return;
        }
        this.flushTask.waitFinished();
        super.sync();
        this.cachedKeyValues.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = this.lock;
        synchronized (object) {
            block13: {
                ArrayList arrayList;
                Iterator iterator2;
                Boolean bl = this.localThread.get();
                EditableProperties editableProperties = null;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                try {
                    this.localThread.set(Boolean.TRUE);
                    editableProperties = this.fileStorage.load();
                    for (Iterator iterator2 : editableProperties.entrySet()) {
                        if (!this.keyEntries.isEmpty() && !this.keyEntries.contains(iterator2.getKey().toString())) continue;
                        this.put(iterator2.getKey().toString(), iterator2.getValue().toString(), true);
                        arrayList2.add(iterator2.getKey().toString());
                    }
                    arrayList = new ArrayList();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    break block13;
                }
                finally {
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    for (String string : this.keyEntries) {
                        if (arrayList2.contains(string) || super.isRemoved()) continue;
                        arrayList3.add(string);
                    }
                    for (String string : arrayList3) {
                        this.remove(string);
                    }
                    this.keyEntries.clear();
                    this.keyEntries.addAll(arrayList2);
                    this.localThread.set(bl);
                }
                for (String string : this.keyEntries) {
                    if (arrayList2.contains(string) || super.isRemoved()) continue;
                    arrayList.add(string);
                }
                iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    String string;
                    string = (String)iterator2.next();
                    this.remove(string);
                }
                this.keyEntries.clear();
                this.keyEntries.addAll(arrayList2);
                this.localThread.set(bl);
            }
        }
    }

    protected abstract FileStorage getFileStorage(String var1);

    static {
        RP = new RequestProcessor();
    }

    static interface FileStorage {
        public boolean isReadOnly();

        public String[] childrenNames();

        public boolean existsNode();

        public void removeNode() throws IOException;

        public void markModified();

        public EditableProperties load() throws IOException;

        public void save(EditableProperties var1) throws IOException;

        public void runAtomic(Runnable var1);

        public void attachChangeListener(ChangeListener var1);
    }

    private static final class SystemPreferences
    extends NbPreferences {
        private SystemPreferences() {
            super(false);
        }

        private SystemPreferences(NbPreferences nbPreferences, String string) {
            super(nbPreferences, string);
        }

        @Override
        protected AbstractPreferences childSpi(String string) {
            return new SystemPreferences(this, string);
        }

        @Override
        protected FileStorage getFileStorage(String string) {
            return PropertiesStorage.instanceReadOnly(FileUtil.getSystemConfigRoot(), this.absolutePath());
        }
    }

    public static class UserPreferences
    extends NbPreferences {
        public UserPreferences() {
            super(true);
        }

        private UserPreferences(NbPreferences nbPreferences, String string) {
            super(nbPreferences, string);
        }

        @Override
        protected AbstractPreferences childSpi(String string) {
            return new UserPreferences(this, string);
        }

        @Override
        protected FileStorage getFileStorage(String string) {
            return PropertiesStorage.instance(FileUtil.getConfigRoot(), this.absolutePath());
        }
    }
}

