/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;

public class NumericComparer
implements AtomicComparer,
Serializable {
    private static NumericComparer THE_INSTANCE = new NumericComparer();

    public static NumericComparer getInstance() {
        return THE_INSTANCE;
    }

    private NumericComparer() {
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) {
        double d2;
        double d1;
        if (a instanceof NumericValue) {
            d1 = ((NumericValue)a).getDoubleValue();
        } else if (a == null) {
            d1 = Double.NaN;
        } else {
            try {
                d1 = Value.stringToNumber(a.getStringValueCS());
            }
            catch (NumberFormatException err) {
                d1 = Double.NaN;
            }
        }
        if (b instanceof NumericValue) {
            d2 = ((NumericValue)b).getDoubleValue();
        } else if (b == null) {
            d2 = Double.NaN;
        } else {
            try {
                d2 = Value.stringToNumber(b.getStringValueCS());
            }
            catch (NumberFormatException err) {
                d2 = Double.NaN;
            }
        }
        if (Double.isNaN(d1)) {
            if (Double.isNaN(d2)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(d2)) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) {
        return this.compareAtomicValues(a, b) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue a) {
        if (a instanceof NumericValue) {
            return new ComparisonKey(635, this.toDoubleValue((NumericValue)a));
        }
        if (a == null) {
            return new ComparisonKey(635, "NaN");
        }
        try {
            double d = Value.stringToNumber(a.getStringValueCS());
            return new ComparisonKey(635, new DoubleValue(d));
        }
        catch (NumberFormatException err) {
            return new ComparisonKey(635, "NaN");
        }
    }

    private DoubleValue toDoubleValue(NumericValue nv) {
        if (nv instanceof DoubleValue) {
            return (DoubleValue)nv;
        }
        return new DoubleValue(nv.getDoubleValue());
    }
}

