/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.listeners.FilenameChangedListener;
import org.pentaho.di.core.listeners.NameChangedListener;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.reflection.StringSearchResult;
import org.pentaho.di.core.reflection.StringSearcher;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.undo.TransAction;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryUtil;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.HasSlaveServersInterface;
import org.pentaho.di.trans.Messages;
import org.pentaho.di.trans.SlaveStepCopyPartitionDistribution;
import org.pentaho.di.trans.TransDependency;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransMeta
extends ChangedFlag
implements XMLInterface,
Comparator<TransMeta>,
Comparable<TransMeta>,
Cloneable,
UndoInterface,
HasDatabasesInterface,
VariableSpace,
EngineMetaInterface,
ResourceExportInterface,
HasSlaveServersInterface,
NamedParams {
    public static final String XML_TAG = "transformation";
    private static LogWriter log = LogWriter.getInstance();
    private List<DatabaseMeta> databases;
    private List<StepMeta> steps;
    private List<TransHopMeta> hops;
    private List<NotePadMeta> notes;
    private List<TransDependency> dependencies;
    private List<SlaveServer> slaveServers;
    private List<ClusterSchema> clusterSchemas;
    private List<PartitionSchema> partitionSchemas;
    private RepositoryDirectory directory;
    private RepositoryDirectory directoryTree;
    private String name;
    private String description;
    private String extended_description;
    private String trans_version;
    private int trans_status;
    private String filename;
    private StepMeta readStep;
    private StepMeta writeStep;
    private StepMeta inputStep;
    private StepMeta outputStep;
    private StepMeta updateStep;
    private StepMeta rejectedStep;
    private String logTable;
    private String stepPerformanceLogTable;
    private DatabaseMeta logConnection;
    private int sizeRowset;
    private DatabaseMeta maxDateConnection;
    private String maxDateTable;
    private String maxDateField;
    private double maxDateOffset;
    private double maxDateDifference;
    private String[] arguments;
    private Hashtable<String, Counter> counters;
    private boolean changed_steps;
    private boolean changed_databases;
    private boolean changed_hops;
    private boolean changed_notes;
    private List<TransAction> undo;
    private int max_undo;
    private int undo_position;
    private DBCache dbCache;
    private long id;
    private boolean useBatchId;
    private boolean logfieldUsed;
    private String createdUser;
    private String modifiedUser;
    private Date createdDate;
    private Date modifiedDate;
    private int sleepTimeEmpty;
    private int sleepTimeFull;
    private Result previousResult;
    private List<RowMetaAndData> resultRows;
    private List<ResultFile> resultFiles;
    private boolean usingUniqueConnections;
    private boolean feedbackShown;
    private int feedbackSize;
    private boolean usingThreadPriorityManagment;
    private String sharedObjectsFile;
    private SharedObjects sharedObjects;
    private VariableSpace variables = new Variables();
    private SlaveStepCopyPartitionDistribution slaveStepCopyPartitionDistribution;
    private boolean slaveTransformation;
    private Repository repository;
    private boolean capturingStepPerformanceSnapShots;
    private long stepPerformanceCapturingDelay;
    private Map<String, RowMetaInterface> stepsFieldsCache;
    private Map<String, Boolean> loopCache;
    private List<NameChangedListener> nameChangedListeners;
    private List<FilenameChangedListener> filenameChangedListeners;
    private NamedParams namedParams = new NamedParamsDefault();
    private String logSizeLimit;
    public static final int TYPE_UNDO_CHANGE = 1;
    public static final int TYPE_UNDO_NEW = 2;
    public static final int TYPE_UNDO_DELETE = 3;
    public static final int TYPE_UNDO_POSITION = 4;
    public static final String[] desc_type_undo = new String[]{"", Messages.getString("TransMeta.UndoTypeDesc.UndoChange"), Messages.getString("TransMeta.UndoTypeDesc.UndoNew"), Messages.getString("TransMeta.UndoTypeDesc.UndoDelete"), Messages.getString("TransMeta.UndoTypeDesc.UndoPosition")};
    private static final String XML_TAG_INFO = "info";
    private static final String XML_TAG_ORDER = "order";
    public static final String XML_TAG_NOTEPADS = "notepads";
    public static final String XML_TAG_PARAMETERS = "parameters";
    private static final String XML_TAG_DEPENDENCIES = "dependencies";
    public static final String XML_TAG_PARTITIONSCHEMAS = "partitionschemas";
    public static final String XML_TAG_SLAVESERVERS = "slaveservers";
    public static final String XML_TAG_CLUSTERSCHEMAS = "clusterschemas";
    private static final String XML_TAG_STEP_ERROR_HANDLING = "step_error_handling";
    private long prevCount;

    public TransMeta() {
        this.clear();
        this.initializeVariablesFrom(null);
    }

    public TransMeta(VariableSpace parent) {
        this.clear();
        this.initializeVariablesFrom(parent);
    }

    public TransMeta(String filename, String name, String[] arguments) {
        this.clear();
        this.setFilename(filename);
        this.name = name;
        this.arguments = arguments;
        this.initializeVariablesFrom(null);
    }

    @Override
    public int compare(TransMeta t1, TransMeta t2) {
        if (Const.isEmpty((String)t1.getName()) && !Const.isEmpty((String)t2.getName())) {
            return -1;
        }
        if (!Const.isEmpty((String)t1.getName()) && Const.isEmpty((String)t2.getName())) {
            return 1;
        }
        if (Const.isEmpty((String)t1.getName()) && Const.isEmpty((String)t2.getName())) {
            if (Const.isEmpty((String)t1.getFilename()) && !Const.isEmpty((String)t2.getFilename())) {
                return -1;
            }
            if (!Const.isEmpty((String)t1.getFilename()) && Const.isEmpty((String)t2.getFilename())) {
                return 1;
            }
            if (Const.isEmpty((String)t1.getFilename()) && Const.isEmpty((String)t2.getFilename())) {
                return 0;
            }
            return t1.getFilename().compareTo(t2.getFilename());
        }
        return t1.getName().compareTo(t2.getName());
    }

    @Override
    public int compareTo(TransMeta o) {
        return this.compare(this, o);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TransMeta)) {
            return false;
        }
        return this.compare(this, (TransMeta)obj) == 0;
    }

    public Object clone() {
        return this.realClone(true);
    }

    public Object realClone(boolean doClear) {
        try {
            TransMeta transMeta = (TransMeta)super.clone();
            if (doClear) {
                transMeta.clear();
            } else {
                transMeta.databases = new ArrayList<DatabaseMeta>();
                transMeta.steps = new ArrayList<StepMeta>();
                transMeta.hops = new ArrayList<TransHopMeta>();
                transMeta.notes = new ArrayList<NotePadMeta>();
                transMeta.dependencies = new ArrayList<TransDependency>();
                transMeta.partitionSchemas = new ArrayList<PartitionSchema>();
                transMeta.slaveServers = new ArrayList<SlaveServer>();
                transMeta.clusterSchemas = new ArrayList<ClusterSchema>();
                transMeta.namedParams = new NamedParamsDefault();
            }
            for (DatabaseMeta databaseMeta : this.databases) {
                transMeta.addDatabase((DatabaseMeta)databaseMeta.clone());
            }
            for (StepMeta stepMeta : this.steps) {
                transMeta.addStep((StepMeta)stepMeta.clone());
            }
            for (TransHopMeta transHopMeta : this.hops) {
                transMeta.addTransHop((TransHopMeta)transHopMeta.clone());
            }
            for (NotePadMeta notePadMeta : this.notes) {
                transMeta.addNote((NotePadMeta)notePadMeta.clone());
            }
            for (TransDependency transDependency : this.dependencies) {
                transMeta.addDependency((TransDependency)transDependency.clone());
            }
            for (SlaveServer slaveServer : this.slaveServers) {
                transMeta.getSlaveServers().add((SlaveServer)slaveServer.clone());
            }
            for (ClusterSchema clusterSchema : this.clusterSchemas) {
                transMeta.getClusterSchemas().add(clusterSchema.clone());
            }
            for (PartitionSchema partitionSchema : this.partitionSchemas) {
                transMeta.getPartitionSchemas().add((PartitionSchema)partitionSchema.clone());
            }
            for (String key : this.listParameters()) {
                transMeta.addParameterDefinition(key, this.getParameterDefault(key), this.getParameterDescription(key));
            }
            return transMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getID() {
        return this.id;
    }

    @Override
    public void setID(long id) {
        this.id = id;
    }

    public void clear() {
        this.setID(-1L);
        this.databases = new ArrayList<DatabaseMeta>();
        this.steps = new ArrayList<StepMeta>();
        this.hops = new ArrayList<TransHopMeta>();
        this.notes = new ArrayList<NotePadMeta>();
        this.dependencies = new ArrayList<TransDependency>();
        this.partitionSchemas = new ArrayList<PartitionSchema>();
        this.slaveServers = new ArrayList<SlaveServer>();
        this.clusterSchemas = new ArrayList<ClusterSchema>();
        this.slaveStepCopyPartitionDistribution = new SlaveStepCopyPartitionDistribution();
        this.setName(null);
        this.description = null;
        this.trans_status = -1;
        this.trans_version = null;
        this.extended_description = null;
        this.setFilename(null);
        this.readStep = null;
        this.writeStep = null;
        this.inputStep = null;
        this.outputStep = null;
        this.updateStep = null;
        this.logTable = null;
        this.stepPerformanceLogTable = null;
        this.logConnection = null;
        this.sizeRowset = 10000;
        this.sleepTimeEmpty = 50;
        this.sleepTimeFull = 50;
        this.maxDateConnection = null;
        this.maxDateTable = null;
        this.maxDateField = null;
        this.maxDateOffset = 0.0;
        this.maxDateDifference = 0.0;
        this.undo = new ArrayList<TransAction>();
        this.max_undo = 100;
        this.undo_position = -1;
        this.counters = new Hashtable();
        this.resultRows = null;
        this.clearUndo();
        this.clearChanged();
        this.useBatchId = true;
        this.logfieldUsed = false;
        this.createdUser = "-";
        this.createdDate = new Date();
        this.modifiedUser = "-";
        this.modifiedDate = new Date();
        this.dbCache = DBCache.getInstance();
        this.directory = this.directoryTree = new RepositoryDirectory();
        this.resultRows = new ArrayList<RowMetaAndData>();
        this.resultFiles = new ArrayList<ResultFile>();
        this.feedbackShown = true;
        this.feedbackSize = 50000;
        this.usingThreadPriorityManagment = true;
        this.capturingStepPerformanceSnapShots = false;
        this.stepPerformanceCapturingDelay = 1000L;
        this.stepsFieldsCache = new HashMap<String, RowMetaInterface>();
        this.loopCache = new HashMap<String, Boolean>();
    }

    public void clearUndo() {
        this.undo = new ArrayList<TransAction>();
        this.undo_position = -1;
    }

    @Override
    public List<DatabaseMeta> getDatabases() {
        return this.databases;
    }

    @Override
    public void setDatabases(List<DatabaseMeta> databases) {
        Collections.sort(databases, DatabaseMeta.comparator);
        this.databases = databases;
    }

    @Override
    public void addDatabase(DatabaseMeta databaseMeta) {
        this.databases.add(databaseMeta);
        Collections.sort(this.databases, DatabaseMeta.comparator);
    }

    @Override
    public void addOrReplaceDatabase(DatabaseMeta databaseMeta) {
        int index = this.databases.indexOf(databaseMeta);
        if (index < 0) {
            this.addDatabase(databaseMeta);
        } else {
            DatabaseMeta previous = this.getDatabase(index);
            previous.replaceMeta(databaseMeta);
        }
        this.changed_databases = true;
    }

    public void addStep(StepMeta stepMeta) {
        this.steps.add(stepMeta);
        this.changed_steps = true;
    }

    public void addOrReplaceStep(StepMeta stepMeta) {
        int index = this.steps.indexOf(stepMeta);
        if (index < 0) {
            this.steps.add(stepMeta);
        } else {
            StepMeta previous = this.getStep(index);
            previous.replaceMeta(stepMeta);
        }
        this.changed_steps = true;
    }

    public void addTransHop(TransHopMeta hi) {
        this.hops.add(hi);
        this.changed_hops = true;
    }

    public void addNote(NotePadMeta ni) {
        this.notes.add(ni);
        this.changed_notes = true;
    }

    public void addDependency(TransDependency td) {
        this.dependencies.add(td);
    }

    @Override
    public void addDatabase(int p, DatabaseMeta ci) {
        this.databases.add(p, ci);
    }

    public void addStep(int p, StepMeta stepMeta) {
        this.steps.add(p, stepMeta);
        this.changed_steps = true;
    }

    public void addTransHop(int p, TransHopMeta hi) {
        this.hops.add(p, hi);
        this.changed_hops = true;
    }

    public void addNote(int p, NotePadMeta ni) {
        this.notes.add(p, ni);
        this.changed_notes = true;
    }

    public void addDependency(int p, TransDependency td) {
        this.dependencies.add(p, td);
    }

    @Override
    public DatabaseMeta getDatabase(int i) {
        return this.databases.get(i);
    }

    public List<StepMeta> getSteps() {
        return this.steps;
    }

    public StepMeta getStep(int i) {
        return this.steps.get(i);
    }

    public TransHopMeta getTransHop(int i) {
        return this.hops.get(i);
    }

    public NotePadMeta getNote(int i) {
        return this.notes.get(i);
    }

    public TransDependency getDependency(int i) {
        return this.dependencies.get(i);
    }

    @Override
    public void removeDatabase(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
        this.changed_databases = true;
    }

    public void removeStep(int i) {
        if (i < 0 || i >= this.steps.size()) {
            return;
        }
        this.steps.remove(i);
        this.changed_steps = true;
    }

    public void removeTransHop(int i) {
        if (i < 0 || i >= this.hops.size()) {
            return;
        }
        this.hops.remove(i);
        this.changed_hops = true;
    }

    public void removeNote(int i) {
        if (i < 0 || i >= this.notes.size()) {
            return;
        }
        this.notes.remove(i);
        this.changed_notes = true;
    }

    public void raiseNote(int p) {
        if (p >= 0 && p < this.notes.size() - 1) {
            NotePadMeta note = this.notes.remove(p);
            this.notes.add(note);
            this.changed_notes = true;
        }
    }

    public void lowerNote(int p) {
        if (p > 0 && p < this.notes.size()) {
            NotePadMeta note = this.notes.remove(p);
            this.notes.add(0, note);
            this.changed_notes = true;
        }
    }

    public void removeDependency(int i) {
        if (i < 0 || i >= this.dependencies.size()) {
            return;
        }
        this.dependencies.remove(i);
    }

    public void removeAllDependencies() {
        this.dependencies.clear();
    }

    @Override
    public int nrDatabases() {
        return this.databases.size();
    }

    public int nrSteps() {
        return this.steps.size();
    }

    public int nrTransHops() {
        return this.hops.size();
    }

    public int nrNotes() {
        return this.notes.size();
    }

    public int nrDependencies() {
        return this.dependencies.size();
    }

    public void setStep(int i, StepMeta stepMeta) {
        this.steps.set(i, stepMeta);
    }

    public void setTransHop(int i, TransHopMeta hi) {
        this.hops.set(i, hi);
    }

    public int nrUsedSteps() {
        int nr = 0;
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (!this.isStepUsedInTransHops(stepMeta)) continue;
            ++nr;
        }
        return nr;
    }

    public StepMeta getUsedStep(int lu) {
        int nr = 0;
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (!this.isStepUsedInTransHops(stepMeta)) continue;
            if (lu == nr) {
                return stepMeta;
            }
            ++nr;
        }
        return null;
    }

    @Override
    public DatabaseMeta findDatabase(String name) {
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.getName().equalsIgnoreCase(name)) continue;
            return ci;
        }
        return null;
    }

    public StepMeta findStep(String name) {
        return this.findStep(name, null);
    }

    public StepMeta findStep(String name, StepMeta exclude) {
        if (name == null) {
            return null;
        }
        int excl = -1;
        if (exclude != null) {
            excl = this.indexOfStep(exclude);
        }
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (i == excl || !stepMeta.getName().equalsIgnoreCase(name)) continue;
            return stepMeta;
        }
        return null;
    }

    public TransHopMeta findTransHop(String name) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.toString().equalsIgnoreCase(name)) continue;
            return hi;
        }
        return null;
    }

    public TransHopMeta findTransHopFrom(StepMeta fromstep) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getFromStep() == null || !hi.getFromStep().equals(fromstep)) continue;
            return hi;
        }
        return null;
    }

    public TransHopMeta findTransHop(TransHopMeta hi) {
        return this.findTransHop(hi.getFromStep(), hi.getToStep());
    }

    public TransHopMeta findTransHop(StepMeta from, StepMeta to) {
        return this.findTransHop(from, to, false);
    }

    public TransHopMeta findTransHop(StepMeta from, StepMeta to, boolean disabledToo) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() && !disabledToo || hi.getFromStep() == null || hi.getToStep() == null || !hi.getFromStep().equals(from) || !hi.getToStep().equals(to)) continue;
            return hi;
        }
        return null;
    }

    public TransHopMeta findTransHopTo(StepMeta tostep) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getToStep() == null || !hi.getToStep().equals(tostep)) continue;
            return hi;
        }
        return null;
    }

    public boolean isStepInformative(StepMeta this_step, StepMeta prev_step) {
        String[] infoSteps = this_step.getStepMetaInterface().getInfoSteps();
        if (infoSteps == null) {
            return false;
        }
        for (int i = 0; i < infoSteps.length; ++i) {
            if (!prev_step.getName().equalsIgnoreCase(infoSteps[i])) continue;
            return true;
        }
        return false;
    }

    public int findNrPrevSteps(String stepname) {
        return this.findNrPrevSteps(this.findStep(stepname), false);
    }

    public int findNrPrevSteps(String stepname, boolean info) {
        return this.findNrPrevSteps(this.findStep(stepname), info);
    }

    public int findNrPrevSteps(StepMeta stepMeta) {
        return this.findNrPrevSteps(stepMeta, false);
    }

    public StepMeta findPrevStep(String stepname, int nr) {
        return this.findPrevStep(this.findStep(stepname), nr);
    }

    public StepMeta findPrevStep(String stepname, int nr, boolean info) {
        return this.findPrevStep(this.findStep(stepname), nr, info);
    }

    public StepMeta findPrevStep(StepMeta stepMeta, int nr) {
        return this.findPrevStep(stepMeta, nr, false);
    }

    public int findNrPrevSteps(StepMeta stepMeta, boolean info) {
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !info && this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            ++count;
        }
        return count;
    }

    public StepMeta findPrevStep(StepMeta stepMeta, int nr, boolean info) {
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !info && this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            if (count == nr) {
                return hi.getFromStep();
            }
            ++count;
        }
        return null;
    }

    public List<StepMeta> findPreviousSteps(StepMeta stepMeta) {
        return this.findPreviousSteps(stepMeta, true);
    }

    public List<StepMeta> findPreviousSteps(StepMeta stepMeta, boolean info) {
        ArrayList<StepMeta> previousSteps = new ArrayList<StepMeta>();
        for (TransHopMeta hi : this.hops) {
            if (hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !info && this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            previousSteps.add(hi.getFromStep());
        }
        return previousSteps;
    }

    public StepMeta[] getInfoStep(StepMeta stepMeta) {
        String[] infoStepName = stepMeta.getStepMetaInterface().getInfoSteps();
        if (infoStepName == null) {
            return null;
        }
        StepMeta[] infoStep = new StepMeta[infoStepName.length];
        for (int i = 0; i < infoStep.length; ++i) {
            infoStep[i] = this.findStep(infoStepName[i]);
        }
        return infoStep;
    }

    public int findNrInfoSteps(StepMeta stepMeta) {
        if (stepMeta == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi == null || hi.getToStep() == null) {
                log.logError(this.toString(), Messages.getString("TransMeta.Log.DestinationOfHopCannotBeNull"), new Object[0]);
            }
            if (hi == null || hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            ++count;
        }
        return count;
    }

    public RowMetaInterface getPrevInfoFields(String stepname) throws KettleStepException {
        return this.getPrevInfoFields(this.findStep(stepname));
    }

    public RowMetaInterface getPrevInfoFields(StepMeta stepMeta) throws KettleStepException {
        RowMeta row = new RowMeta();
        for (int i = 0; i < this.nrTransHops(); ++i) {
            StepMeta infoStep;
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !this.isStepInformative(stepMeta, infoStep = hi.getFromStep())) continue;
            row = this.getPrevStepFields(infoStep);
            this.getThisStepFields(infoStep, stepMeta, (RowMetaInterface)row);
            return row;
        }
        return row;
    }

    public int findNrNextSteps(StepMeta stepMeta) {
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            ++count;
        }
        return count;
    }

    public StepMeta findNextStep(StepMeta stepMeta, int nr) {
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            if (count == nr) {
                return hi.getToStep();
            }
            ++count;
        }
        return null;
    }

    public StepMeta[] getPrevSteps(StepMeta stepMeta) {
        ArrayList<StepMeta> prevSteps = new ArrayList<StepMeta>();
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hopMeta = this.getTransHop(i);
            if (!hopMeta.isEnabled() || !hopMeta.getToStep().equals(stepMeta)) continue;
            prevSteps.add(hopMeta.getFromStep());
        }
        return prevSteps.toArray(new StepMeta[prevSteps.size()]);
    }

    public String[] getPrevStepNames(String stepname) {
        return this.getPrevStepNames(this.findStep(stepname));
    }

    public String[] getPrevStepNames(StepMeta stepMeta) {
        StepMeta[] prevStepMetas = this.getPrevSteps(stepMeta);
        String[] retval = new String[prevStepMetas.length];
        for (int x = 0; x < prevStepMetas.length; ++x) {
            retval[x] = prevStepMetas[x].getName();
        }
        return retval;
    }

    public StepMeta[] getNextSteps(StepMeta stepMeta) {
        ArrayList<StepMeta> nextSteps = new ArrayList<StepMeta>();
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            nextSteps.add(hi.getToStep());
        }
        return nextSteps.toArray(new StepMeta[nextSteps.size()]);
    }

    public List<StepMeta> findNextSteps(StepMeta stepMeta) {
        ArrayList<StepMeta> nextSteps = new ArrayList<StepMeta>();
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            nextSteps.add(hi.getToStep());
        }
        return nextSteps;
    }

    public String[] getNextStepNames(StepMeta stepMeta) {
        StepMeta[] nextStepMeta = this.getNextSteps(stepMeta);
        String[] retval = new String[nextStepMeta.length];
        for (int x = 0; x < nextStepMeta.length; ++x) {
            retval[x] = nextStepMeta[x].getName();
        }
        return retval;
    }

    public StepMeta getStep(int x, int y, int iconsize) {
        int s = this.steps.size();
        for (int i = s - 1; i >= 0; --i) {
            Point p;
            StepMeta stepMeta = this.steps.get(i);
            if (!this.partOfTransHop(stepMeta) && !stepMeta.isDrawn() || (p = stepMeta.getLocation()) == null || x < p.x || x > p.x + iconsize || y < p.y || y > p.y + iconsize + 20) continue;
            return stepMeta;
        }
        return null;
    }

    public NotePadMeta getNote(int x, int y) {
        int s = this.notes.size();
        for (int i = s - 1; i >= 0; --i) {
            NotePadMeta ni = this.notes.get(i);
            Point loc = ni.getLocation();
            Point p = new Point(loc.x, loc.y);
            if (x < p.x || x > p.x + ni.width + 10 || y < p.y || y > p.y + ni.height + 10) continue;
            return ni;
        }
        return null;
    }

    public boolean partOfTransHop(StepMeta stepMeta) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getFromStep() == null || hi.getToStep() == null) {
                return false;
            }
            if (!hi.getFromStep().equals(stepMeta) && !hi.getToStep().equals(stepMeta)) continue;
            return true;
        }
        return false;
    }

    public RowMetaInterface getStepFields(String stepname) throws KettleStepException {
        StepMeta stepMeta = this.findStep(stepname);
        if (stepMeta != null) {
            return this.getStepFields(stepMeta);
        }
        return null;
    }

    public RowMetaInterface getStepFields(StepMeta stepMeta) throws KettleStepException {
        return this.getStepFields(stepMeta, null);
    }

    public RowMetaInterface getStepFields(StepMeta[] stepMeta) throws KettleStepException {
        RowMeta fields = new RowMeta();
        for (int i = 0; i < stepMeta.length; ++i) {
            RowMetaInterface flds = this.getStepFields(stepMeta[i]);
            if (flds == null) continue;
            fields.mergeRowMeta(flds);
        }
        return fields;
    }

    public RowMetaInterface getStepFields(StepMeta stepMeta, ProgressMonitorListener monitor) throws KettleStepException {
        this.clearStepFieldsCachce();
        return this.getStepFields(stepMeta, null, monitor);
    }

    public RowMetaInterface getStepFields(StepMeta stepMeta, StepMeta targetStep, ProgressMonitorListener monitor) throws KettleStepException {
        RowMeta row = new RowMeta();
        if (stepMeta == null) {
            return row;
        }
        String fromToCacheEntry = stepMeta.getName() + (targetStep != null ? "-" + targetStep.getName() : "");
        RowMetaInterface rowMeta = this.stepsFieldsCache.get(fromToCacheEntry);
        if (rowMeta != null) {
            return rowMeta;
        }
        if (targetStep != null && stepMeta.isSendingErrorRowsToStep(targetStep)) {
            row = this.getPrevStepFields(stepMeta);
            StepErrorMeta stepErrorMeta = stepMeta.getStepErrorMeta();
            row.addRowMeta(stepErrorMeta.getErrorFields());
            this.stepsFieldsCache.put(fromToCacheEntry, (RowMetaInterface)row);
            return row;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("TransMeta.Log.FromStepALookingAtPreviousStep", stepMeta.getName(), String.valueOf(this.findNrPrevSteps(stepMeta))), new Object[0]);
        }
        for (int i = 0; i < this.findNrPrevSteps(stepMeta); ++i) {
            RowMetaInterface add;
            StepMeta prevStepMeta = this.findPrevStep(stepMeta, i);
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.CheckingStepTask.Title", prevStepMeta.getName()));
            }
            if ((add = this.getStepFields(prevStepMeta, stepMeta, monitor)) == null) {
                add = new RowMeta();
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.FoundFieldsToAdd") + add.toString(), new Object[0]);
            }
            if (i == 0) {
                row.addRowMeta(add);
                continue;
            }
            for (int x = 0; x < add.size(); ++x) {
                ValueMetaInterface v = add.getValueMeta(x);
                ValueMetaInterface s = row.searchValueMeta(v.getName());
                if (s != null) continue;
                row.addValueMeta(v);
            }
        }
        rowMeta = this.getThisStepFields(stepMeta, targetStep, (RowMetaInterface)row, monitor);
        this.stepsFieldsCache.put(fromToCacheEntry, rowMeta);
        return rowMeta;
    }

    public RowMetaInterface getPrevStepFields(String stepname) throws KettleStepException {
        this.clearStepFieldsCachce();
        return this.getPrevStepFields(this.findStep(stepname));
    }

    public RowMetaInterface getPrevStepFields(StepMeta stepMeta) throws KettleStepException {
        this.clearStepFieldsCachce();
        return this.getPrevStepFields(stepMeta, null);
    }

    public RowMetaInterface getPrevStepFields(StepMeta stepMeta, ProgressMonitorListener monitor) throws KettleStepException {
        this.clearStepFieldsCachce();
        RowMeta row = new RowMeta();
        if (stepMeta == null) {
            return null;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("TransMeta.Log.FromStepALookingAtPreviousStep", stepMeta.getName(), String.valueOf(this.findNrPrevSteps(stepMeta))), new Object[0]);
        }
        for (int i = 0; i < this.findNrPrevSteps(stepMeta); ++i) {
            StepMeta prevStepMeta = this.findPrevStep(stepMeta, i);
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.CheckingStepTask.Title", prevStepMeta.getName()));
            }
            RowMetaInterface add = this.getStepFields(prevStepMeta, stepMeta, monitor);
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.FoundFieldsToAdd2") + add.toString(), new Object[0]);
            }
            if (i == 0) {
                row.addRowMeta(add);
                continue;
            }
            for (int x = 0; x < add.size(); ++x) {
                ValueMetaInterface v = add.getValueMeta(x);
                ValueMetaInterface s = row.searchValueMeta(v.getName());
                if (s != null) continue;
                row.addValueMeta(v);
            }
        }
        return row;
    }

    public RowMetaInterface getThisStepFields(String stepname, RowMetaInterface row) throws KettleStepException {
        return this.getThisStepFields(this.findStep(stepname), null, row);
    }

    public RowMetaInterface getThisStepFields(StepMeta stepMeta, StepMeta nextStep, RowMetaInterface row) throws KettleStepException {
        return this.getThisStepFields(stepMeta, nextStep, row, null);
    }

    public RowMetaInterface getThisStepFields(StepMeta stepMeta, StepMeta nextStep, RowMetaInterface row, ProgressMonitorListener monitor) throws KettleStepException {
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("TransMeta.Log.GettingFieldsFromStep", stepMeta.getName(), stepMeta.getStepID()), new Object[0]);
        }
        String name = stepMeta.getName();
        if (monitor != null) {
            monitor.subTask(Messages.getString("TransMeta.Monitor.GettingFieldsFromStepTask.Title", name));
        }
        StepMetaInterface stepint = stepMeta.getStepMetaInterface();
        RowMetaInterface[] inform = null;
        Object[] lu = this.getInfoStep(stepMeta);
        if (Const.isEmpty((Object[])lu)) {
            inform = new RowMetaInterface[]{stepint.getTableFields()};
        } else {
            inform = new RowMetaInterface[lu.length];
            for (int i = 0; i < lu.length; ++i) {
                inform[i] = this.getStepFields((StepMeta)lu[i]);
            }
        }
        for (StepMeta step : this.steps) {
            if (!(step.getStepMetaInterface() instanceof MappingMeta)) continue;
            ((MappingMeta)step.getStepMetaInterface()).setRepository(this.repository);
        }
        stepint.getFields(row, name, inform, nextStep, this);
        return row;
    }

    @Override
    public boolean showReplaceWarning(Repository rep) {
        if (this.getID() < 0L) {
            try {
                if (rep.getTransformationID(this.getName(), this.directory.getID()) > 0L) {
                    return true;
                }
            }
            catch (KettleException dbe) {
                log.logError(this.toString(), Messages.getString("TransMeta.Log.DatabaseError") + dbe.getMessage(), new Object[0]);
                return true;
            }
        }
        return false;
    }

    public void saveRep(Repository rep) throws KettleException {
        this.saveRep(rep, null);
    }

    @Override
    public void saveRep(Repository rep, ProgressMonitorListener monitor) throws KettleException {
        try {
            boolean isUsedByTransformation;
            StepMeta stepMeta;
            int i;
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.LockingRepository"));
            }
            rep.lockRepository();
            rep.insertLogEntry("save transformation '" + this.getName() + "'");
            rep.clearNextIDCounters();
            if (this.directory.getID() < 0L) {
                throw new KettleException(Messages.getString("TransMeta.Exception.PlsSelectAValidDirectoryBeforeSavingTheTransformation"));
            }
            int nrWorks = 2 + this.nrDatabases() + this.nrNotes() + this.nrSteps() + this.nrTransHops();
            if (monitor != null) {
                monitor.beginTask(Messages.getString("TransMeta.Monitor.SavingTransformationTask.Title") + this.getPathAndName(), nrWorks);
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.SavingOfTransformationStarted"), new Object[0]);
            }
            if (monitor != null && monitor.isCanceled()) {
                throw new KettleDatabaseException();
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.HandlingOldVersionTransformationTask.Title"));
            }
            this.setID(rep.getTransformationID(this.getName(), this.directory.getID()));
            if (this.getID() <= 0L) {
                this.setID(rep.getNextTransformationID());
            } else {
                if (monitor != null) {
                    monitor.subTask(Messages.getString("TransMeta.Monitor.DeletingOldVersionTransformationTask.Title"));
                }
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("TransMeta.Log.DeletingOldVersionTransformation"), new Object[0]);
                }
                rep.delAllFromTrans(this.getID());
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("TransMeta.Log.OldVersionOfTransformationRemoved"), new Object[0]);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.SavingNotes"), new Object[0]);
            }
            for (i = 0; i < this.nrNotes(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(Messages.getString("TransMeta.Log.UserCancelledTransSave"));
                }
                if (monitor != null) {
                    monitor.subTask(Messages.getString("TransMeta.Monitor.SavingNoteTask.Title") + (i + 1) + "/" + this.nrNotes());
                }
                NotePadMeta ni = this.getNote(i);
                ni.saveRep(rep, this.getID());
                if (ni.getID() > 0L) {
                    rep.insertTransNote(this.getID(), ni.getID());
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.SavingDatabaseConnections"), new Object[0]);
            }
            for (i = 0; i < this.nrDatabases(); ++i) {
                DatabaseMeta databaseMeta;
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(Messages.getString("TransMeta.Log.UserCancelledTransSave"));
                }
                if (monitor != null) {
                    monitor.subTask(Messages.getString("TransMeta.Monitor.SavingDatabaseTask.Title") + (i + 1) + "/" + this.nrDatabases());
                }
                if ((databaseMeta = this.getDatabase(i)).hasChanged() || databaseMeta.getID() <= 0L) {
                    RepositoryUtil.saveDatabaseMeta(databaseMeta, rep);
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.CheckingStepTypes"), new Object[0]);
            }
            rep.updateStepTypes();
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.SavingSteps"), new Object[0]);
            }
            for (i = 0; i < this.nrSteps(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(Messages.getString("TransMeta.Log.UserCancelledTransSave"));
                }
                if (monitor != null) {
                    monitor.subTask(Messages.getString("TransMeta.Monitor.SavingStepTask.Title") + (i + 1) + "/" + this.nrSteps());
                }
                stepMeta = this.getStep(i);
                stepMeta.saveRep(rep, this.getID());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            rep.closeStepAttributeInsertPreparedStatement();
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.SavingHops"), new Object[0]);
            }
            for (i = 0; i < this.nrTransHops(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(Messages.getString("TransMeta.Log.UserCancelledTransSave"));
                }
                if (monitor != null) {
                    monitor.subTask(Messages.getString("TransMeta.Monitor.SavingHopTask.Title") + (i + 1) + "/" + this.nrTransHops());
                }
                TransHopMeta hi = this.getTransHop(i);
                hi.saveRep(rep, this.getID());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.FinishingTask.Title"));
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.SavingTransformationInfo"), new Object[0]);
            }
            rep.insertTransformation(this);
            this.saveRepParameters(rep);
            rep.closeTransAttributeInsertPreparedStatement();
            for (i = 0; i < this.partitionSchemas.size(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(Messages.getString("TransMeta.Log.UserCancelledTransSave"));
                }
                PartitionSchema partitionSchema = this.partitionSchemas.get(i);
                isUsedByTransformation = this.isUsingPartitionSchema(partitionSchema);
                partitionSchema.saveRep(rep, this.getID(), isUsedByTransformation);
            }
            for (i = 0; i < this.slaveServers.size(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(Messages.getString("TransMeta.Log.UserCancelledTransSave"));
                }
                SlaveServer slaveServer = this.slaveServers.get(i);
                isUsedByTransformation = this.isUsingSlaveServer(slaveServer);
                slaveServer.saveRep(rep, this.getID(), isUsedByTransformation);
            }
            for (i = 0; i < this.clusterSchemas.size(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(Messages.getString("TransMeta.Log.UserCancelledTransSave"));
                }
                ClusterSchema clusterSchema = this.clusterSchemas.get(i);
                isUsedByTransformation = this.isUsingClusterSchema(clusterSchema);
                clusterSchema.saveRep(rep, this.getID(), isUsedByTransformation);
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.SavingDependencies"), new Object[0]);
            }
            for (i = 0; i < this.nrDependencies(); ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new KettleDatabaseException(Messages.getString("TransMeta.Log.UserCancelledTransSave"));
                }
                TransDependency td = this.getDependency(i);
                td.saveRep(rep, this.getID());
            }
            for (i = 0; i < this.nrSteps(); ++i) {
                stepMeta = this.getStep(i);
                StepErrorMeta stepErrorMeta = stepMeta.getStepErrorMeta();
                if (stepErrorMeta == null) continue;
                stepErrorMeta.saveRep(rep, this.getId(), stepMeta.getID());
            }
            rep.closeStepAttributeInsertPreparedStatement();
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.SavingFinished"), new Object[0]);
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.UnlockingRepository"));
            }
            rep.unlockRepository();
            rep.commit();
            this.clearChanged();
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (KettleDatabaseException dbe) {
            rep.rollback();
            log.logError(this.toString(), Messages.getString("TransMeta.Log.ErrorSavingTransformationToRepository") + Const.CR + dbe.getMessage(), new Object[0]);
            throw new KettleException(Messages.getString("TransMeta.Log.ErrorSavingTransformationToRepository"), (Throwable)dbe);
        }
        finally {
            rep.unlockRepository();
        }
    }

    private void saveRepParameters(Repository rep) throws KettleException {
        String[] paramKeys = this.listParameters();
        for (int idx = 0; idx < paramKeys.length; ++idx) {
            String desc = this.getParameterDescription(paramKeys[idx]);
            String defaultValue = this.getParameterDefault(paramKeys[idx]);
            rep.insertTransParameter(this.getId(), idx, paramKeys[idx], defaultValue, desc);
        }
    }

    private void loadRepParameters(Repository rep) throws KettleException {
        this.eraseParameters();
        int count = rep.countTransParameter(this.getId());
        for (int idx = 0; idx < count; ++idx) {
            String key = rep.getTransParameterKey(this.getId(), idx);
            String def = rep.getTransParameterDefault(this.getId(), idx);
            String desc = rep.getTransParameterDescription(this.getId(), idx);
            this.addParameterDefinition(key, def, desc);
        }
    }

    public boolean isUsingPartitionSchema(PartitionSchema partitionSchema) {
        for (int i = 0; i < this.nrSteps(); ++i) {
            PartitionSchema check;
            StepPartitioningMeta stepPartitioningMeta = this.getStep(i).getStepPartitioningMeta();
            if (stepPartitioningMeta == null || (check = stepPartitioningMeta.getPartitionSchema()) == null || !check.equals(partitionSchema)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingClusterSchema(ClusterSchema clusterSchema) {
        for (int i = 0; i < this.nrSteps(); ++i) {
            ClusterSchema check = this.getStep(i).getClusterSchema();
            if (check == null || !check.equals(clusterSchema)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingSlaveServer(SlaveServer slaveServer) throws KettleException {
        for (int i = 0; i < this.nrSteps(); ++i) {
            ClusterSchema clusterSchema = this.getStep(i).getClusterSchema();
            if (clusterSchema == null) continue;
            for (SlaveServer check : clusterSchema.getSlaveServers()) {
                if (!check.equals(slaveServer)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void readDatabases(Repository rep, boolean overWriteShared) throws KettleException {
        try {
            long[] dbids = rep.getDatabaseIDs();
            for (int i = 0; i < dbids.length; ++i) {
                DatabaseMeta databaseMeta = RepositoryUtil.loadDatabaseMeta(rep, dbids[i]);
                databaseMeta.shareVariablesWith((VariableSpace)this);
                DatabaseMeta check = this.findDatabase(databaseMeta.getName());
                if (check != null && !overWriteShared || databaseMeta.getName() == null) continue;
                this.addOrReplaceDatabase(databaseMeta);
                if (overWriteShared) continue;
                databaseMeta.setChanged(false);
            }
            this.changed_databases = false;
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("TransMeta.Log.UnableToReadDatabaseIDSFromRepository"), (Throwable)dbe);
        }
        catch (KettleException ke) {
            throw new KettleException(Messages.getString("TransMeta.Log.UnableToReadDatabasesFromRepository"), (Throwable)ke);
        }
    }

    public void readPartitionSchemas(Repository rep, boolean overWriteShared) throws KettleException {
        try {
            long[] dbids = rep.getPartitionSchemaIDs();
            for (int i = 0; i < dbids.length; ++i) {
                PartitionSchema partitionSchema = new PartitionSchema(rep, dbids[i]);
                PartitionSchema check = this.findPartitionSchema(partitionSchema.getName());
                if (check != null && !overWriteShared || Const.isEmpty((String)partitionSchema.getName())) continue;
                this.addOrReplacePartitionSchema(partitionSchema);
                if (overWriteShared) continue;
                partitionSchema.setChanged(false);
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("TransMeta.Log.UnableToReadPartitionSchemaFromRepository"), (Throwable)dbe);
        }
    }

    public void readSlaves(Repository rep, boolean overWriteShared) throws KettleException {
        try {
            long[] dbids = rep.getSlaveIDs();
            for (int i = 0; i < dbids.length; ++i) {
                SlaveServer slaveServer = new SlaveServer(rep, dbids[i]);
                slaveServer.shareVariablesWith(this);
                SlaveServer check = this.findSlaveServer(slaveServer.getName());
                if (check != null && !overWriteShared || Const.isEmpty((String)slaveServer.getName())) continue;
                this.addOrReplaceSlaveServer(slaveServer);
                if (overWriteShared) continue;
                slaveServer.setChanged(false);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("TransMeta.Log.UnableToReadSlaveServersFromRepository"), (Throwable)dbe);
        }
    }

    public void readClusters(Repository rep, boolean overWriteShared) throws KettleException {
        try {
            long[] dbids = rep.getClusterIDs();
            for (int i = 0; i < dbids.length; ++i) {
                ClusterSchema clusterSchema = new ClusterSchema(rep, dbids[i], this.slaveServers);
                clusterSchema.shareVariablesWith(this);
                ClusterSchema check = this.findClusterSchema(clusterSchema.getName());
                if (check != null && !overWriteShared || Const.isEmpty((String)clusterSchema.getName())) continue;
                this.addOrReplaceClusterSchema(clusterSchema);
                if (overWriteShared) continue;
                clusterSchema.setChanged(false);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("TransMeta.Log.UnableToReadClustersFromRepository"), (Throwable)dbe);
        }
    }

    public void loadRepTrans(Repository rep) throws KettleException {
        try {
            RowMetaAndData r = rep.getTransformation(this.getID());
            if (r != null) {
                long id_directory;
                this.setName(r.getString("NAME", null));
                this.description = r.getString("DESCRIPTION", null);
                this.extended_description = r.getString("EXTENDED_DESCRIPTION", null);
                this.trans_version = r.getString("TRANS_VERSION", null);
                this.trans_status = (int)r.getInteger("TRANS_STATUS", -1L);
                this.readStep = StepMeta.findStep(this.steps, r.getInteger("ID_STEP_READ", -1L));
                this.writeStep = StepMeta.findStep(this.steps, r.getInteger("ID_STEP_WRITE", -1L));
                this.inputStep = StepMeta.findStep(this.steps, r.getInteger("ID_STEP_INPUT", -1L));
                this.outputStep = StepMeta.findStep(this.steps, r.getInteger("ID_STEP_OUTPUT", -1L));
                this.updateStep = StepMeta.findStep(this.steps, r.getInteger("ID_STEP_UPDATE", -1L));
                long id_rejected = rep.getTransAttributeInteger(this.getID(), 0, "ID_STEP_REJECTED");
                if (id_rejected > 0L) {
                    this.rejectedStep = StepMeta.findStep(this.steps, id_rejected);
                }
                this.logConnection = DatabaseMeta.findDatabase(this.databases, (long)r.getInteger("ID_DATABASE_LOG", -1L));
                this.logTable = r.getString("TABLE_NAME_LOG", null);
                this.useBatchId = r.getBoolean("USE_BATCHID", false);
                this.logfieldUsed = r.getBoolean("USE_LOGFIELD", false);
                this.maxDateConnection = DatabaseMeta.findDatabase(this.databases, (long)r.getInteger("ID_DATABASE_MAXDATE", -1L));
                this.maxDateTable = r.getString("TABLE_NAME_MAXDATE", null);
                this.maxDateField = r.getString("FIELD_NAME_MAXDATE", null);
                this.maxDateOffset = r.getNumber("OFFSET_MAXDATE", 0.0);
                this.maxDateDifference = r.getNumber("DIFF_MAXDATE", 0.0);
                this.createdUser = r.getString("CREATED_USER", null);
                this.createdDate = r.getDate("CREATED_DATE", null);
                this.modifiedUser = r.getString("MODIFIED_USER", null);
                this.modifiedDate = r.getDate("MODIFIED_DATE", null);
                this.sizeRowset = 10000;
                Long val_size_rowset = r.getInteger("SIZE_ROWSET");
                if (val_size_rowset != null) {
                    this.sizeRowset = val_size_rowset.intValue();
                }
                if ((id_directory = r.getInteger("ID_DIRECTORY", -1L)) >= 0L) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), "ID_DIRECTORY=" + id_directory, new Object[0]);
                    }
                    this.directory = this.directoryTree.findDirectory(id_directory);
                }
                this.usingUniqueConnections = rep.getTransAttributeBoolean(this.getID(), 0, "UNIQUE_CONNECTIONS");
                this.feedbackShown = !"N".equalsIgnoreCase(rep.getTransAttributeString(this.getID(), 0, "FEEDBACK_SHOWN"));
                this.feedbackSize = (int)rep.getTransAttributeInteger(this.getID(), 0, "FEEDBACK_SIZE");
                this.usingThreadPriorityManagment = !"N".equalsIgnoreCase(rep.getTransAttributeString(this.getID(), 0, "USING_THREAD_PRIORITIES"));
                this.capturingStepPerformanceSnapShots = rep.getTransAttributeBoolean(this.getID(), 0, "CAPTURE_STEP_PERFORMANCE");
                this.stepPerformanceCapturingDelay = rep.getTransAttributeInteger(this.getID(), 0, "STEP_PERFORMANCE_CAPTURING_DELAY");
                this.stepPerformanceLogTable = rep.getTransAttributeString(this.getID(), 0, "STEP_PERFORMANCE_LOG_TABLE");
                this.logSizeLimit = rep.getTransAttributeString(this.getID(), 0, "LOG_SIZE_LIMIT");
                this.loadRepParameters(rep);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("TransMeta.Exception.UnableToLoadTransformationInfoFromRepository"), (Throwable)dbe);
        }
        finally {
            this.initializeVariablesFrom(null);
            this.setInternalKettleVariables();
        }
    }

    public boolean isRepReference() {
        return TransMeta.isRepReference(this.getFilename(), this.getName());
    }

    public boolean isFileReference() {
        return !TransMeta.isRepReference(this.getFilename(), this.getName());
    }

    public static boolean isRepReference(String exactFilename, String exactTransname) {
        return Const.isEmpty((String)exactFilename) && !Const.isEmpty((String)exactTransname);
    }

    public static boolean isFileReference(String exactFilename, String exactTransname) {
        return !TransMeta.isRepReference(exactFilename, exactTransname);
    }

    public TransMeta(Repository rep, String transname, RepositoryDirectory repdir) throws KettleException {
        this(rep, transname, repdir, null, true);
    }

    public TransMeta(Repository rep, String transname, RepositoryDirectory repdir, boolean setInternalVariables) throws KettleException {
        this(rep, transname, repdir, null, setInternalVariables);
    }

    public TransMeta(Repository rep, String transname, RepositoryDirectory repdir, ProgressMonitorListener monitor) throws KettleException {
        this(rep, transname, repdir, monitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransMeta(Repository rep, String transname, RepositoryDirectory repdir, ProgressMonitorListener monitor, boolean setInternalVariables) throws KettleException {
        this();
        this.repository = rep;
        Repository repository = rep;
        synchronized (repository) {
            try {
                String pathAndName = repdir.isRoot() ? repdir + transname : repdir + "/" + transname;
                this.setName(transname);
                this.directory = repdir;
                this.directoryTree = this.directory.findRoot();
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("TransMeta.Log.LookingForTransformation", transname, this.directory.getPath()), new Object[0]);
                }
                if (monitor != null) {
                    monitor.subTask(Messages.getString("TransMeta.Monitor.ReadingTransformationInfoTask.Title"));
                }
                this.setID(rep.getTransformationID(transname, this.directory.getID()));
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (this.getID() > 0L) {
                    int i;
                    int i2;
                    long[] noteids = rep.getTransNoteIDs(this.getID());
                    long[] stepids = rep.getStepIDs(this.getID());
                    long[] hopids = rep.getTransHopIDs(this.getID());
                    int nrWork = 3 + noteids.length + stepids.length + hopids.length;
                    if (monitor != null) {
                        monitor.beginTask(Messages.getString("TransMeta.Monitor.LoadingTransformationTask.Title") + pathAndName, nrWork);
                    }
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("TransMeta.Log.LoadingTransformation", this.getName()), new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.subTask(Messages.getString("TransMeta.Monitor.ReadingTheAvailableSharedObjectsTask.Title"));
                    }
                    try {
                        this.sharedObjects = this.readSharedObjects(rep);
                    }
                    catch (Exception e) {
                        LogWriter.getInstance().logError(this.toString(), Messages.getString("TransMeta.ErrorReadingSharedObjects.Message", e.toString()), new Object[0]);
                        LogWriter.getInstance().logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    if (monitor != null) {
                        monitor.subTask(Messages.getString("TransMeta.Monitor.ReadingNoteTask.Title"));
                    }
                    for (i2 = 0; i2 < noteids.length; ++i2) {
                        NotePadMeta ni = new NotePadMeta(log, rep, noteids[i2]);
                        if (this.indexOfNote(ni) < 0) {
                            this.addNote(ni);
                        }
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    if (monitor != null) {
                        monitor.subTask(Messages.getString("TransMeta.Monitor.ReadingStepsTask.Title"));
                    }
                    rep.fillStepAttributesBuffer(this.getID());
                    for (i2 = 0; i2 < stepids.length; ++i2) {
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("TransMeta.Log.LoadingStepWithID") + stepids[i2], new Object[0]);
                        }
                        if (monitor != null) {
                            monitor.subTask(Messages.getString("TransMeta.Monitor.ReadingStepTask.Title") + (i2 + 1) + "/" + stepids.length);
                        }
                        StepMeta stepMeta = new StepMeta(rep, stepids[i2], this.databases, this.counters, this.partitionSchemas);
                        this.addOrReplaceStep(stepMeta);
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    rep.setStepAttributesBuffer(null);
                    for (i2 = 0; i2 < this.nrSteps(); ++i2) {
                        StepMetaInterface sii = this.getStep(i2).getStepMetaInterface();
                        sii.searchInfoAndTargetSteps(this.steps);
                    }
                    if (monitor != null) {
                        monitor.subTask(Messages.getString("TransMeta.Monitor.LoadingTransformationDetailsTask.Title"));
                    }
                    this.loadRepTrans(rep);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    if (monitor != null) {
                        monitor.subTask(Messages.getString("TransMeta.Monitor.ReadingHopTask.Title"));
                    }
                    for (i2 = 0; i2 < hopids.length; ++i2) {
                        TransHopMeta hi = new TransHopMeta(rep, hopids[i2], this.steps);
                        this.addTransHop(hi);
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    for (i2 = 0; i2 < this.nrSteps(); ++i2) {
                        StepPartitioningMeta stepPartitioningMeta = this.getStep(i2).getStepPartitioningMeta();
                        if (stepPartitioningMeta == null) continue;
                        stepPartitioningMeta.setPartitionSchemaAfterLoading(this.partitionSchemas);
                    }
                    for (i2 = 0; i2 < this.nrSteps(); ++i2) {
                        this.getStep(i2).setClusterSchemaAfterLoading(this.clusterSchemas);
                    }
                    if (monitor != null) {
                        monitor.subTask(Messages.getString("TransMeta.Monitor.ReadingTheDependenciesTask.Title"));
                    }
                    long[] depids = rep.getTransDependencyIDs(this.getID());
                    for (i = 0; i < depids.length; ++i) {
                        TransDependency td = new TransDependency(rep, depids[i], this.databases);
                        this.addDependency(td);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    for (i = 0; i < this.nrSteps(); ++i) {
                        StepMeta stepMeta = this.getStep(i);
                        String sourceStep = rep.getStepAttributeString(stepMeta.getID(), "step_error_handling_source_step");
                        if (sourceStep == null) continue;
                        StepErrorMeta stepErrorMeta = new StepErrorMeta(this, rep, stepMeta, this.steps);
                        stepErrorMeta.getSourceStep().setStepErrorMeta(stepErrorMeta);
                    }
                    if (monitor != null) {
                        monitor.subTask(Messages.getString("TransMeta.Monitor.SortingStepsTask.Title"));
                    }
                    this.sortSteps();
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                } else {
                    throw new KettleException(Messages.getString("TransMeta.Exception.TransformationDoesNotExist") + this.name);
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("TransMeta.Log.LoadedTransformation2", transname, String.valueOf(this.directory == null)), new Object[0]);
                    log.logDetailed(this.toString(), Messages.getString("TransMeta.Log.LoadedTransformation", transname, this.directory.getPath()), new Object[0]);
                }
            }
            catch (KettleDatabaseException e) {
                log.logError(this.toString(), Messages.getString("TransMeta.Log.DatabaseErrorOccuredReadingTransformation") + Const.CR + (Object)((Object)e), new Object[0]);
                throw new KettleException(Messages.getString("TransMeta.Exception.DatabaseErrorOccuredReadingTransformation"), (Throwable)e);
            }
            catch (Exception e) {
                log.logError(this.toString(), Messages.getString("TransMeta.Log.DatabaseErrorOccuredReadingTransformation") + Const.CR + e, new Object[0]);
                throw new KettleException(Messages.getString("TransMeta.Exception.DatabaseErrorOccuredReadingTransformation2"), (Throwable)e);
            }
            finally {
                this.initializeVariablesFrom(null);
                if (setInternalVariables) {
                    this.setInternalKettleVariables();
                }
            }
        }
    }

    public int indexOfTransHop(TransHopMeta hi) {
        return this.hops.indexOf(hi);
    }

    public int indexOfStep(StepMeta stepMeta) {
        return this.steps.indexOf(stepMeta);
    }

    @Override
    public int indexOfDatabase(DatabaseMeta ci) {
        return this.databases.indexOf(ci);
    }

    public int indexOfNote(NotePadMeta ni) {
        return this.notes.indexOf(ni);
    }

    @Override
    public String getFileType() {
        return "Trans";
    }

    @Override
    public String[] getFilterNames() {
        return Const.getTransformationFilterNames();
    }

    @Override
    public String[] getFilterExtensions() {
        return Const.STRING_TRANS_FILTER_EXT;
    }

    @Override
    public String getDefaultExtension() {
        return "ktr";
    }

    @Override
    public String getXML() throws KettleException {
        StepMeta stepMeta;
        int i;
        Props props = null;
        if (Props.isInitialized()) {
            props = Props.getInstance();
        }
        StringBuilder retval = new StringBuilder(800);
        retval.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("  ").append(XMLHandler.openTag((String)XML_TAG_INFO)).append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        retval.append("    ").append(XMLHandler.addTagValue((String)"description", (String)this.description));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extended_description", (String)this.extended_description));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_version", (String)this.trans_version));
        if (this.trans_status >= 0) {
            retval.append("    ").append(XMLHandler.addTagValue((String)"trans_status", (int)this.trans_status));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"directory", (String)(this.directory != null ? this.directory.getPath() : "/")));
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        String[] parameters = this.listParameters();
        for (int idx = 0; idx < parameters.length; ++idx) {
            retval.append("        ").append(XMLHandler.openTag((String)"parameter")).append(Const.CR);
            retval.append("            ").append(XMLHandler.addTagValue((String)"name", (String)parameters[idx]));
            retval.append("            ").append(XMLHandler.addTagValue((String)"default_value", (String)this.getParameterDefault(parameters[idx])));
            retval.append("            ").append(XMLHandler.addTagValue((String)"description", (String)this.getParameterDescription(parameters[idx])));
            retval.append("        ").append(XMLHandler.closeTag((String)"parameter")).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        retval.append("    <log>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"read", (String)(this.readStep == null ? "" : this.readStep.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"write", (String)(this.writeStep == null ? "" : this.writeStep.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input", (String)(this.inputStep == null ? "" : this.inputStep.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output", (String)(this.outputStep == null ? "" : this.outputStep.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"update", (String)(this.updateStep == null ? "" : this.updateStep.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"rejected", (String)(this.rejectedStep == null ? "" : this.rejectedStep.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", (String)(this.logConnection == null ? "" : this.logConnection.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"table", (String)this.logTable));
        retval.append("      ").append(XMLHandler.addTagValue((String)"step_performance_table", (String)this.stepPerformanceLogTable));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_batchid", (boolean)this.useBatchId));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_logfield", (boolean)this.logfieldUsed));
        retval.append("      ").append(XMLHandler.addTagValue((String)"size_limit_lines", (String)this.logSizeLimit));
        retval.append("    </log>").append(Const.CR);
        retval.append("    <maxdate>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", (String)(this.maxDateConnection == null ? "" : this.maxDateConnection.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"table", (String)this.maxDateTable));
        retval.append("      ").append(XMLHandler.addTagValue((String)"field", (String)this.maxDateField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"offset", (double)this.maxDateOffset));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maxdiff", (double)this.maxDateDifference));
        retval.append("    </maxdate>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"size_rowset", (int)this.sizeRowset));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sleep_time_empty", (int)this.sleepTimeEmpty));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sleep_time_full", (int)this.sleepTimeFull));
        retval.append("    ").append(XMLHandler.addTagValue((String)"unique_connections", (boolean)this.usingUniqueConnections));
        retval.append("    ").append(XMLHandler.addTagValue((String)"feedback_shown", (boolean)this.feedbackShown));
        retval.append("    ").append(XMLHandler.addTagValue((String)"feedback_size", (int)this.feedbackSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"using_thread_priorities", (boolean)this.usingThreadPriorityManagment));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shared_objects_file", (String)this.sharedObjectsFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"capture_step_performance", (boolean)this.capturingStepPerformanceSnapShots));
        retval.append("    ").append(XMLHandler.addTagValue((String)"step_performance_capturing_delay", (long)this.stepPerformanceCapturingDelay));
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_DEPENDENCIES)).append(Const.CR);
        for (i = 0; i < this.nrDependencies(); ++i) {
            TransDependency td = this.getDependency(i);
            retval.append(td.getXML());
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_DEPENDENCIES)).append(Const.CR);
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_PARTITIONSCHEMAS)).append(Const.CR);
        for (i = 0; i < this.partitionSchemas.size(); ++i) {
            PartitionSchema partitionSchema = this.partitionSchemas.get(i);
            retval.append(partitionSchema.getXML());
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_PARTITIONSCHEMAS)).append(Const.CR);
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_SLAVESERVERS)).append(Const.CR);
        for (i = 0; i < this.slaveServers.size(); ++i) {
            SlaveServer slaveServer = this.slaveServers.get(i);
            retval.append("         ").append(slaveServer.getXML()).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_SLAVESERVERS)).append(Const.CR);
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_CLUSTERSCHEMAS)).append(Const.CR);
        for (i = 0; i < this.clusterSchemas.size(); ++i) {
            ClusterSchema clusterSchema = this.clusterSchemas.get(i);
            retval.append(clusterSchema.getXML());
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_CLUSTERSCHEMAS)).append(Const.CR);
        retval.append("  ").append(XMLHandler.addTagValue((String)"modified_user", (String)this.modifiedUser));
        retval.append("  ").append(XMLHandler.addTagValue((String)"modified_date", (Date)this.modifiedDate));
        retval.append("  ").append(XMLHandler.closeTag((String)XML_TAG_INFO)).append(Const.CR);
        retval.append("  ").append(XMLHandler.openTag((String)XML_TAG_NOTEPADS)).append(Const.CR);
        if (this.notes != null) {
            for (i = 0; i < this.nrNotes(); ++i) {
                NotePadMeta ni = this.getNote(i);
                retval.append(ni.getXML());
            }
        }
        retval.append("  ").append(XMLHandler.closeTag((String)XML_TAG_NOTEPADS)).append(Const.CR);
        for (i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta dbMeta = this.getDatabase(i);
            if (props != null && props.areOnlyUsedConnectionsSavedToXML()) {
                if (!this.isDatabaseConnectionUsed(dbMeta)) continue;
                retval.append(dbMeta.getXML());
                continue;
            }
            retval.append(dbMeta.getXML());
        }
        retval.append("  ").append(XMLHandler.openTag((String)XML_TAG_ORDER)).append(Const.CR);
        for (i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta transHopMeta = this.getTransHop(i);
            retval.append(transHopMeta.getXML());
        }
        retval.append("  ").append(XMLHandler.closeTag((String)XML_TAG_ORDER)).append(Const.CR);
        for (i = 0; i < this.nrSteps(); ++i) {
            stepMeta = this.getStep(i);
            retval.append(stepMeta.getXML());
        }
        retval.append("  ").append(XMLHandler.openTag((String)XML_TAG_STEP_ERROR_HANDLING)).append(Const.CR);
        for (i = 0; i < this.nrSteps(); ++i) {
            stepMeta = this.getStep(i);
            if (stepMeta.getStepErrorMeta() == null) continue;
            retval.append(stepMeta.getStepErrorMeta().getXML());
        }
        retval.append("  ").append(XMLHandler.closeTag((String)XML_TAG_STEP_ERROR_HANDLING)).append(Const.CR);
        retval.append("   ").append(this.slaveStepCopyPartitionDistribution.getXML());
        retval.append("   ").append(XMLHandler.addTagValue((String)"slave_transformation", (boolean)this.slaveTransformation));
        retval.append("</").append("transformation>").append(Const.CR);
        return retval.toString();
    }

    public TransMeta(String fname) throws KettleXMLException {
        this(fname, true);
    }

    public TransMeta(String fname, VariableSpace parentVariableSpace) throws KettleXMLException {
        this(fname, null, true, parentVariableSpace);
    }

    public TransMeta(String fname, boolean setInternalVariables) throws KettleXMLException {
        this(fname, null, setInternalVariables);
    }

    public TransMeta(String fname, Repository rep) throws KettleXMLException {
        this(fname, rep, true);
    }

    public TransMeta(String fname, Repository rep, boolean setInternalVariables) throws KettleXMLException {
        this(fname, rep, setInternalVariables, null);
    }

    public TransMeta(String fname, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace) throws KettleXMLException {
        this(fname, rep, setInternalVariables, parentVariableSpace, null);
    }

    public TransMeta(String fname, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace, OverwritePrompter prompter) throws KettleXMLException {
        Document doc = null;
        try {
            doc = XMLHandler.loadXMLFile((FileObject)KettleVFS.getFileObject((String)fname));
        }
        catch (IOException e) {
            throw new KettleXMLException(Messages.getString("TransMeta.Exception.ErrorOpeningOrValidatingTheXMLFile", fname), (Throwable)e);
        }
        if (doc == null) {
            throw new KettleXMLException(Messages.getString("TransMeta.Exception.ErrorOpeningOrValidatingTheXMLFile", fname));
        }
        this.clearUndo();
        this.clear();
        Node transnode = XMLHandler.getSubNode((Node)doc, (String)XML_TAG);
        this.loadXML(transnode, rep, setInternalVariables, parentVariableSpace, prompter);
        this.setFilename(fname);
    }

    public TransMeta(Node transnode, Repository rep) throws KettleXMLException {
        this.loadXML(transnode, rep, false);
    }

    public void loadXML(Node transnode, Repository rep, boolean setInternalVariables) throws KettleXMLException {
        this.loadXML(transnode, rep, setInternalVariables, null);
    }

    public void loadXML(Node transnode, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace) throws KettleXMLException {
        this.loadXML(transnode, rep, setInternalVariables, parentVariableSpace, null);
    }

    public void loadXML(Node transnode, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace, OverwritePrompter prompter) throws KettleXMLException {
        Props props = null;
        if (Props.isInitialized()) {
            props = Props.getInstance();
        }
        if (parentVariableSpace != null) {
            this.initializeVariablesFrom(parentVariableSpace);
        }
        try {
            Node partitionDistNode;
            int i;
            int i2;
            String directoryPath;
            int i3;
            this.clearUndo();
            this.clear();
            try {
                this.sharedObjectsFile = XMLHandler.getTagValue((Node)transnode, (String)XML_TAG_INFO, (String)"shared_objects_file");
                this.sharedObjects = this.readSharedObjects(rep);
            }
            catch (Exception e) {
                LogWriter.getInstance().logError(this.toString(), Messages.getString("TransMeta.ErrorReadingSharedObjects.Message", e.toString()), new Object[0]);
                LogWriter.getInstance().logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            }
            int n = XMLHandler.countNodes((Node)transnode, (String)"connection");
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.WeHaveConnections", String.valueOf(n)), new Object[0]);
            }
            for (int i4 = 0; i4 < n; ++i4) {
                boolean overwrite;
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("TransMeta.Log.LookingAtConnection") + i4, new Object[0]);
                }
                Node nodecon = XMLHandler.getSubNodeByNr((Node)transnode, (String)"connection", (int)i4);
                DatabaseMeta dbcon = new DatabaseMeta(nodecon);
                dbcon.shareVariablesWith((VariableSpace)this);
                DatabaseMeta exist = this.findDatabase(dbcon.getName());
                if (exist == null) {
                    this.addDatabase(dbcon);
                    continue;
                }
                if (exist.isShared()) continue;
                boolean askOverwrite = Props.isInitialized() ? props.askAboutReplacingDatabaseConnections() : false;
                boolean bl = overwrite = Props.isInitialized() ? props.replaceExistingDatabaseConnections() : true;
                if (askOverwrite && prompter != null) {
                    overwrite = prompter.overwritePrompt(Messages.getString("TransMeta.Message.OverwriteConnectionYN", dbcon.getName()), Messages.getString("TransMeta.Message.OverwriteConnection.DontShowAnyMoreMessage"), "AskAboutReplacingDatabases");
                }
                if (!overwrite) continue;
                int idx = this.indexOfDatabase(exist);
                this.removeDatabase(idx);
                this.addDatabase(idx, dbcon);
            }
            Node notepadsnode = XMLHandler.getSubNode((Node)transnode, (String)XML_TAG_NOTEPADS);
            int nrnotes = XMLHandler.countNodes((Node)notepadsnode, (String)"notepad");
            for (int i5 = 0; i5 < nrnotes; ++i5) {
                Node notepadnode = XMLHandler.getSubNodeByNr((Node)notepadsnode, (String)"notepad", (int)i5);
                NotePadMeta ni = new NotePadMeta(notepadnode);
                this.notes.add(ni);
            }
            int s = XMLHandler.countNodes((Node)transnode, (String)"step");
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.ReadingSteps") + s + " steps...", new Object[0]);
            }
            for (int i6 = 0; i6 < s; ++i6) {
                StepMeta stepMeta;
                StepMeta check;
                Node stepnode = XMLHandler.getSubNodeByNr((Node)transnode, (String)"step", (int)i6);
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("TransMeta.Log.LookingAtStep") + i6, new Object[0]);
                }
                if ((check = this.findStep((stepMeta = new StepMeta(stepnode, this.databases, this.counters)).getName())) != null) {
                    if (!check.isShared()) {
                        this.addOrReplaceStep(stepMeta);
                        continue;
                    }
                    check.setDraw(stepMeta.isDrawn());
                    check.setLocation(stepMeta.getLocation());
                    continue;
                }
                this.addStep(stepMeta);
            }
            Node errorHandlingNode = XMLHandler.getSubNode((Node)transnode, (String)XML_TAG_STEP_ERROR_HANDLING);
            int nrErrorHandlers = XMLHandler.countNodes((Node)errorHandlingNode, (String)"error");
            for (i3 = 0; i3 < nrErrorHandlers; ++i3) {
                Node stepErrorMetaNode = XMLHandler.getSubNodeByNr((Node)errorHandlingNode, (String)"error", (int)i3);
                StepErrorMeta stepErrorMeta = new StepErrorMeta((VariableSpace)this, stepErrorMetaNode, this.steps);
                stepErrorMeta.getSourceStep().setStepErrorMeta(stepErrorMeta);
            }
            for (i3 = 0; i3 < this.nrSteps(); ++i3) {
                StepMeta stepMeta = this.getStep(i3);
                StepMetaInterface sii = stepMeta.getStepMetaInterface();
                if (sii == null) continue;
                sii.searchInfoAndTargetSteps(this.steps);
            }
            Node ordernode = XMLHandler.getSubNode((Node)transnode, (String)XML_TAG_ORDER);
            n = XMLHandler.countNodes((Node)ordernode, (String)"hop");
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.WeHaveHops") + n + " hops...", new Object[0]);
            }
            for (int i7 = 0; i7 < n; ++i7) {
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("TransMeta.Log.LookingAtHop") + i7, new Object[0]);
                }
                Node hopnode = XMLHandler.getSubNodeByNr((Node)ordernode, (String)"hop", (int)i7);
                TransHopMeta hopinf = new TransHopMeta(hopnode, this.steps);
                this.addTransHop(hopinf);
            }
            Node infonode = XMLHandler.getSubNode((Node)transnode, (String)XML_TAG_INFO);
            this.setName(XMLHandler.getTagValue((Node)infonode, (String)"name"));
            this.description = XMLHandler.getTagValue((Node)infonode, (String)"description");
            this.extended_description = XMLHandler.getTagValue((Node)infonode, (String)"extended_description");
            this.trans_version = XMLHandler.getTagValue((Node)infonode, (String)"trans_version");
            this.trans_status = Const.toInt((String)XMLHandler.getTagValue((Node)infonode, (String)"trans_status"), (int)-1);
            if (rep != null && (directoryPath = XMLHandler.getTagValue((Node)infonode, (String)"directory")) != null) {
                this.directory = rep.getDirectoryTree().findDirectory(directoryPath);
                if (this.directory == null) {
                    this.directory = new RepositoryDirectory();
                }
            }
            this.readStep = this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"read"));
            this.writeStep = this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"write"));
            this.inputStep = this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"input"));
            this.outputStep = this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"output"));
            this.updateStep = this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"update"));
            this.rejectedStep = this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"rejected"));
            String logcon = XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"connection");
            this.logConnection = this.findDatabase(logcon);
            this.logTable = XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"table");
            this.stepPerformanceLogTable = XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"step_performance_table");
            this.useBatchId = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"use_batchid"));
            this.logfieldUsed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"USE_LOGFIELD"));
            this.logSizeLimit = XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"size_limit_lines");
            String maxdatcon = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"connection");
            this.maxDateConnection = this.findDatabase(maxdatcon);
            this.maxDateTable = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"table");
            this.maxDateField = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"field");
            String offset = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"offset");
            this.maxDateOffset = Const.toDouble((String)offset, (double)0.0);
            String mdiff = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"maxdiff");
            this.maxDateDifference = Const.toDouble((String)mdiff, (double)0.0);
            Node depsNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_DEPENDENCIES);
            int nrDeps = XMLHandler.countNodes((Node)depsNode, (String)"dependency");
            for (int i8 = 0; i8 < nrDeps; ++i8) {
                Node depNode = XMLHandler.getSubNodeByNr((Node)depsNode, (String)"dependency", (int)i8);
                TransDependency transDependency = new TransDependency(depNode, this.databases);
                if (transDependency.getDatabase() == null || transDependency.getFieldname() == null) continue;
                this.addDependency(transDependency);
            }
            Node paramsNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_PARAMETERS);
            int nrParams = XMLHandler.countNodes((Node)paramsNode, (String)"parameter");
            for (int i9 = 0; i9 < nrParams; ++i9) {
                Node paramNode = XMLHandler.getSubNodeByNr((Node)paramsNode, (String)"parameter", (int)i9);
                String paramName = XMLHandler.getTagValue((Node)paramNode, (String)"name");
                String defaultValue = XMLHandler.getTagValue((Node)paramNode, (String)"default_value");
                String descr = XMLHandler.getTagValue((Node)paramNode, (String)"description");
                this.addParameterDefinition(paramName, defaultValue, descr);
            }
            Node partSchemasNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_PARTITIONSCHEMAS);
            int nrPartSchemas = XMLHandler.countNodes((Node)partSchemasNode, (String)"partitionschema");
            for (i2 = 0; i2 < nrPartSchemas; ++i2) {
                Node partSchemaNode = XMLHandler.getSubNodeByNr((Node)partSchemasNode, (String)"partitionschema", (int)i2);
                PartitionSchema partitionSchema = new PartitionSchema(partSchemaNode);
                PartitionSchema check = this.findPartitionSchema(partitionSchema.getName());
                if (check != null) {
                    if (check.isShared()) continue;
                    this.addOrReplacePartitionSchema(partitionSchema);
                    continue;
                }
                this.partitionSchemas.add(partitionSchema);
            }
            for (i2 = 0; i2 < this.nrSteps(); ++i2) {
                StepPartitioningMeta targetStepPartitioningMeta;
                StepPartitioningMeta stepPartitioningMeta = this.getStep(i2).getStepPartitioningMeta();
                if (stepPartitioningMeta != null) {
                    stepPartitioningMeta.setPartitionSchemaAfterLoading(this.partitionSchemas);
                }
                if ((targetStepPartitioningMeta = this.getStep(i2).getTargetStepPartitioningMeta()) == null) continue;
                targetStepPartitioningMeta.setPartitionSchemaAfterLoading(this.partitionSchemas);
            }
            Node slaveServersNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_SLAVESERVERS);
            int nrSlaveServers = XMLHandler.countNodes((Node)slaveServersNode, (String)"slaveserver");
            for (int i10 = 0; i10 < nrSlaveServers; ++i10) {
                Node slaveServerNode = XMLHandler.getSubNodeByNr((Node)slaveServersNode, (String)"slaveserver", (int)i10);
                SlaveServer slaveServer = new SlaveServer(slaveServerNode);
                slaveServer.shareVariablesWith(this);
                SlaveServer check = this.findSlaveServer(slaveServer.getName());
                if (check != null) {
                    if (check.isShared()) continue;
                    this.addOrReplaceSlaveServer(slaveServer);
                    continue;
                }
                this.slaveServers.add(slaveServer);
            }
            Node clusterSchemasNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_CLUSTERSCHEMAS);
            int nrClusterSchemas = XMLHandler.countNodes((Node)clusterSchemasNode, (String)"clusterschema");
            for (i = 0; i < nrClusterSchemas; ++i) {
                Node clusterSchemaNode = XMLHandler.getSubNodeByNr((Node)clusterSchemasNode, (String)"clusterschema", (int)i);
                ClusterSchema clusterSchema = new ClusterSchema(clusterSchemaNode, this.slaveServers);
                clusterSchema.shareVariablesWith(this);
                ClusterSchema check = this.findClusterSchema(clusterSchema.getName());
                if (check != null) {
                    if (check.isShared()) continue;
                    this.addOrReplaceClusterSchema(clusterSchema);
                    continue;
                }
                this.clusterSchemas.add(clusterSchema);
            }
            for (i = 0; i < this.nrSteps(); ++i) {
                this.getStep(i).setClusterSchemaAfterLoading(this.clusterSchemas);
            }
            String srowset = XMLHandler.getTagValue((Node)infonode, (String)"size_rowset");
            this.sizeRowset = Const.toInt((String)srowset, (int)10000);
            this.sleepTimeEmpty = Const.toInt((String)XMLHandler.getTagValue((Node)infonode, (String)"sleep_time_empty"), (int)50);
            this.sleepTimeFull = Const.toInt((String)XMLHandler.getTagValue((Node)infonode, (String)"sleep_time_full"), (int)50);
            this.usingUniqueConnections = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"unique_connections"));
            this.feedbackShown = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"feedback_shown"));
            this.feedbackSize = Const.toInt((String)XMLHandler.getTagValue((Node)infonode, (String)"feedback_size"), (int)50000);
            this.usingThreadPriorityManagment = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"using_thread_priorities"));
            this.capturingStepPerformanceSnapShots = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"capture_step_performance"));
            this.stepPerformanceCapturingDelay = Const.toLong((String)XMLHandler.getTagValue((Node)infonode, (String)"step_performance_capturing_delay"), (long)1000L);
            this.createdUser = XMLHandler.getTagValue((Node)infonode, (String)"created_user");
            String createDate = XMLHandler.getTagValue((Node)infonode, (String)"created_date");
            if (createDate != null) {
                this.createdDate = XMLHandler.stringToDate((String)createDate);
            }
            this.modifiedUser = XMLHandler.getTagValue((Node)infonode, (String)"modified_user");
            String modDate = XMLHandler.getTagValue((Node)infonode, (String)"modified_date");
            if (modDate != null) {
                this.modifiedDate = XMLHandler.stringToDate((String)modDate);
            }
            this.slaveStepCopyPartitionDistribution = (partitionDistNode = XMLHandler.getSubNode((Node)transnode, (String)"slave-step-copy-partition-distribution")) != null ? new SlaveStepCopyPartitionDistribution(partitionDistNode) : new SlaveStepCopyPartitionDistribution();
            this.slaveTransformation = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)transnode, (String)"slave_transformation"));
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.NumberOfStepsReaded") + this.nrSteps(), new Object[0]);
                log.logDebug(this.toString(), Messages.getString("TransMeta.Log.NumberOfHopsReaded") + this.nrTransHops(), new Object[0]);
            }
            this.sortSteps();
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("TransMeta.Exception.ErrorReadingTransformation"), (Throwable)xe);
        }
        catch (KettleException e) {
            throw new KettleXMLException((Throwable)e);
        }
        finally {
            this.initializeVariablesFrom(null);
            if (setInternalVariables) {
                this.setInternalKettleVariables();
            }
        }
    }

    public SharedObjects readSharedObjects(Repository rep) throws KettleException {
        String soFile;
        SharedObjects sharedObjects;
        if (rep != null) {
            this.sharedObjectsFile = rep.getTransAttributeString(this.getId(), 0, "SHARED_FILE");
        }
        if ((sharedObjects = new SharedObjects(soFile = this.environmentSubstitute(this.sharedObjectsFile))).getObjectsMap().isEmpty()) {
            log.logDetailed(this.toString(), Messages.getString("TransMeta.Log.EmptySharedObjectsFile", soFile), new Object[0]);
        }
        for (SharedObjectInterface object : sharedObjects.getObjectsMap().values()) {
            if (object instanceof DatabaseMeta) {
                DatabaseMeta databaseMeta = (DatabaseMeta)object;
                databaseMeta.shareVariablesWith((VariableSpace)this);
                this.addOrReplaceDatabase(databaseMeta);
                continue;
            }
            if (object instanceof SlaveServer) {
                SlaveServer slaveServer = (SlaveServer)object;
                slaveServer.shareVariablesWith(this);
                this.addOrReplaceSlaveServer(slaveServer);
                continue;
            }
            if (object instanceof StepMeta) {
                StepMeta stepMeta = (StepMeta)object;
                this.addOrReplaceStep(stepMeta);
                continue;
            }
            if (object instanceof PartitionSchema) {
                PartitionSchema partitionSchema = (PartitionSchema)object;
                this.addOrReplacePartitionSchema(partitionSchema);
                continue;
            }
            if (!(object instanceof ClusterSchema)) continue;
            ClusterSchema clusterSchema = (ClusterSchema)object;
            clusterSchema.shareVariablesWith(this);
            this.addOrReplaceClusterSchema(clusterSchema);
        }
        if (rep != null) {
            this.readDatabases(rep, true);
            this.readPartitionSchemas(rep, true);
            this.readSlaves(rep, true);
            this.readClusters(rep, true);
        }
        return sharedObjects;
    }

    public List<StepMeta> getTransHopSteps(boolean all) {
        int x;
        ArrayList<StepMeta> st = new ArrayList<StepMeta>();
        for (x = 0; x < this.nrTransHops(); ++x) {
            TransHopMeta hi = this.getTransHop(x);
            if (!hi.isEnabled() && !all) continue;
            int idx = st.indexOf(hi.getFromStep());
            if (idx < 0) {
                st.add(hi.getFromStep());
            }
            if ((idx = st.indexOf(hi.getToStep())) >= 0) continue;
            st.add(hi.getToStep());
        }
        for (x = 0; x < this.nrSteps(); ++x) {
            StepMeta stepMeta = this.getStep(x);
            if (stepMeta.isDrawn() && !this.isStepUsedInTransHops(stepMeta)) {
                st.add(stepMeta);
            }
            if (stepMeta.getRemoteInputSteps().isEmpty() && stepMeta.getRemoteOutputSteps().isEmpty() || st.contains(stepMeta)) continue;
            st.add(stepMeta);
        }
        return st;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.fireNameChangedListeners(this.name, newName);
        this.name = newName;
        this.setInternalKettleVariables();
    }

    @Override
    public void nameFromFilename() {
        if (!Const.isEmpty((String)this.filename)) {
            this.setName(Const.createName((String)this.filename));
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String fname) {
        this.fireFilenameChangedListeners(this.filename, fname);
        this.filename = fname;
        this.setInternalKettleVariables();
    }

    public boolean isStepUsedInTransHops(StepMeta stepMeta) {
        TransHopMeta fr = this.findTransHopFrom(stepMeta);
        TransHopMeta to = this.findTransHopTo(stepMeta);
        return fr != null || to != null;
    }

    @Override
    public void setChanged(boolean ch) {
        if (ch) {
            this.setChanged();
        } else {
            this.clearChanged();
        }
    }

    @Override
    public void clearChanged() {
        int i;
        this.changed_steps = false;
        this.changed_databases = false;
        this.changed_hops = false;
        this.changed_notes = false;
        for (i = 0; i < this.nrSteps(); ++i) {
            this.getStep(i).setChanged(false);
            if (this.getStep(i).getStepPartitioningMeta() == null) continue;
            this.getStep(i).getStepPartitioningMeta().hasChanged(false);
        }
        for (i = 0; i < this.nrDatabases(); ++i) {
            this.getDatabase(i).setChanged(false);
        }
        for (i = 0; i < this.nrTransHops(); ++i) {
            this.getTransHop(i).setChanged(false);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            this.getNote(i).setChanged(false);
        }
        for (i = 0; i < this.partitionSchemas.size(); ++i) {
            this.partitionSchemas.get(i).setChanged(false);
        }
        for (i = 0; i < this.clusterSchemas.size(); ++i) {
            this.clusterSchemas.get(i).setChanged(false);
        }
        super.clearChanged();
    }

    @Override
    public boolean haveConnectionsChanged() {
        if (this.changed_databases) {
            return true;
        }
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveStepsChanged() {
        if (this.changed_steps) {
            return true;
        }
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (stepMeta.hasChanged()) {
                return true;
            }
            if (stepMeta.getStepPartitioningMeta() == null || !stepMeta.getStepPartitioningMeta().hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveHopsChanged() {
        if (this.changed_hops) {
            return true;
        }
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveNotesChanged() {
        if (this.changed_notes) {
            return true;
        }
        for (int i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            if (!ni.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean havePartitionSchemasChanged() {
        for (int i = 0; i < this.partitionSchemas.size(); ++i) {
            PartitionSchema ps = this.partitionSchemas.get(i);
            if (!ps.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveClusterSchemasChanged() {
        for (int i = 0; i < this.clusterSchemas.size(); ++i) {
            ClusterSchema cs = this.clusterSchemas.get(i);
            if (!cs.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        if (this.haveConnectionsChanged()) {
            return true;
        }
        if (this.haveStepsChanged()) {
            return true;
        }
        if (this.haveHopsChanged()) {
            return true;
        }
        if (this.haveNotesChanged()) {
            return true;
        }
        if (this.havePartitionSchemasChanged()) {
            return true;
        }
        return this.haveClusterSchemasChanged();
    }

    public boolean hasLoop(StepMeta stepMeta) {
        this.clearLoopCachce();
        return this.hasLoop(stepMeta, null, true) || this.hasLoop(stepMeta, null, false);
    }

    private boolean hasLoop(StepMeta stepMeta, StepMeta lookup, boolean info) {
        String cacheKey = stepMeta.getName() + " - " + (lookup != null ? lookup.getName() : "") + " - " + (info ? "true" : "false");
        Boolean loop = this.loopCache.get(cacheKey);
        if (loop != null) {
            return loop;
        }
        boolean hasLoop = false;
        int nr = this.findNrPrevSteps(stepMeta, info);
        for (int i = 0; i < nr && !hasLoop; ++i) {
            StepMeta prevStepMeta = this.findPrevStep(stepMeta, i, info);
            if (prevStepMeta == null) continue;
            if (prevStepMeta.equals(stepMeta)) {
                hasLoop = true;
                break;
            }
            if (prevStepMeta.equals(lookup)) {
                hasLoop = true;
                break;
            }
            if (!this.hasLoop(prevStepMeta, lookup == null ? stepMeta : lookup, info)) continue;
            hasLoop = true;
            break;
        }
        this.loopCache.put(cacheKey, hasLoop);
        return hasLoop;
    }

    public void selectAll() {
        int i;
        for (i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            stepMeta.setSelected(true);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(true);
        }
        this.setChanged();
        this.notifyObservers("refreshGraph");
    }

    public void unselectAll() {
        int i;
        for (i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            stepMeta.setSelected(false);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(false);
        }
    }

    public int nrSelectedSteps() {
        int count = 0;
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (!stepMeta.isSelected() || !stepMeta.isDrawn()) continue;
            ++count;
        }
        return count;
    }

    public StepMeta getSelectedStep(int nr) {
        int count = 0;
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (!stepMeta.isSelected() || !stepMeta.isDrawn()) continue;
            if (nr == count) {
                return stepMeta;
            }
            ++count;
        }
        return null;
    }

    public int nrSelectedNotes() {
        int count = 0;
        for (int i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            if (!ni.isSelected()) continue;
            ++count;
        }
        return count;
    }

    public NotePadMeta getSelectedNote(int nr) {
        int count = 0;
        for (int i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            if (!ni.isSelected()) continue;
            if (nr == count) {
                return ni;
            }
            ++count;
        }
        return null;
    }

    public Point[] getSelectedStepLocations() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < this.nrSelectedSteps(); ++i) {
            StepMeta stepMeta = this.getSelectedStep(i);
            Point p = stepMeta.getLocation();
            points.add(new Point(p.x, p.y));
        }
        return points.toArray(new Point[points.size()]);
    }

    public Point[] getSelectedNoteLocations() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < this.nrSelectedNotes(); ++i) {
            NotePadMeta ni = this.getSelectedNote(i);
            Point p = ni.getLocation();
            points.add(new Point(p.x, p.y));
        }
        return points.toArray(new Point[points.size()]);
    }

    public StepMeta[] getSelectedSteps() {
        int sels = this.nrSelectedSteps();
        if (sels == 0) {
            return null;
        }
        StepMeta[] retval = new StepMeta[sels];
        for (int i = 0; i < sels; ++i) {
            StepMeta stepMeta;
            retval[i] = stepMeta = this.getSelectedStep(i);
        }
        return retval;
    }

    public List<GUIPositionInterface> getSelectedDrawnStepsList() {
        ArrayList<GUIPositionInterface> list = new ArrayList<GUIPositionInterface>();
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (!stepMeta.isDrawn() || !stepMeta.isSelected()) continue;
            list.add(stepMeta);
        }
        return list;
    }

    public NotePadMeta[] getSelectedNotes() {
        int sels = this.nrSelectedNotes();
        if (sels == 0) {
            return null;
        }
        NotePadMeta[] retval = new NotePadMeta[sels];
        for (int i = 0; i < sels; ++i) {
            NotePadMeta si;
            retval[i] = si = this.getSelectedNote(i);
        }
        return retval;
    }

    public String[] getSelectedStepNames() {
        int sels = this.nrSelectedSteps();
        if (sels == 0) {
            return null;
        }
        String[] retval = new String[sels];
        for (int i = 0; i < sels; ++i) {
            StepMeta stepMeta = this.getSelectedStep(i);
            retval[i] = stepMeta.getName();
        }
        return retval;
    }

    public int[] getStepIndexes(StepMeta[] steps) {
        int[] retval = new int[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            retval[i] = this.indexOfStep(steps[i]);
        }
        return retval;
    }

    public int[] getNoteIndexes(NotePadMeta[] notes) {
        int[] retval = new int[notes.length];
        for (int i = 0; i < notes.length; ++i) {
            retval[i] = this.indexOfNote(notes[i]);
        }
        return retval;
    }

    @Override
    public int getMaxUndo() {
        return this.max_undo;
    }

    @Override
    public void setMaxUndo(int mu) {
        this.max_undo = mu;
        while (this.undo.size() > mu && this.undo.size() > 0) {
            this.undo.remove(0);
        }
    }

    @Override
    public void addUndo(Object[] from, Object[] to, int[] pos, Point[] prev, Point[] curr, int type_of_change, boolean nextAlso) {
        while (this.undo.size() > this.undo_position + 1 && this.undo.size() > 0) {
            int last = this.undo.size() - 1;
            this.undo.remove(last);
        }
        TransAction ta = new TransAction();
        switch (type_of_change) {
            case 1: {
                ta.setChanged(from, to, pos);
                break;
            }
            case 3: {
                ta.setDelete(from, pos);
                break;
            }
            case 2: {
                ta.setNew(from, pos);
                break;
            }
            case 4: {
                ta.setPosition(from, pos, prev, curr);
            }
        }
        ta.setNextAlso(nextAlso);
        this.undo.add(ta);
        ++this.undo_position;
        if (this.undo.size() > this.max_undo) {
            this.undo.remove(0);
            --this.undo_position;
        }
    }

    @Override
    public TransAction previousUndo() {
        if (this.undo.isEmpty() || this.undo_position < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position);
        --this.undo_position;
        return retval;
    }

    @Override
    public TransAction viewThisUndo() {
        if (this.undo.isEmpty() || this.undo_position < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position);
        return retval;
    }

    @Override
    public TransAction viewPreviousUndo() {
        if (this.undo.isEmpty() || this.undo_position - 1 < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position - 1);
        return retval;
    }

    @Override
    public TransAction nextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undo_position >= size - 1) {
            return null;
        }
        ++this.undo_position;
        TransAction retval = this.undo.get(this.undo_position);
        return retval;
    }

    @Override
    public TransAction viewNextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undo_position >= size - 1) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position + 1);
        return retval;
    }

    public Point getMaximum() {
        Point loc;
        int i;
        int maxx = 0;
        int maxy = 0;
        for (i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            loc = stepMeta.getLocation();
            if (loc.x > maxx) {
                maxx = loc.x;
            }
            if (loc.y <= maxy) continue;
            maxy = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta notePadMeta = this.getNote(i);
            loc = notePadMeta.getLocation();
            if (loc.x + notePadMeta.width > maxx) {
                maxx = loc.x + notePadMeta.width;
            }
            if (loc.y + notePadMeta.height <= maxy) continue;
            maxy = loc.y + notePadMeta.height;
        }
        return new Point(maxx + 100, maxy + 100);
    }

    public String[] getStepNames() {
        String[] retval = new String[this.nrSteps()];
        for (int i = 0; i < this.nrSteps(); ++i) {
            retval[i] = this.getStep(i).getName();
        }
        return retval;
    }

    public StepMeta[] getStepsArray() {
        StepMeta[] retval = new StepMeta[this.nrSteps()];
        for (int i = 0; i < this.nrSteps(); ++i) {
            retval[i] = this.getStep(i);
        }
        return retval;
    }

    public boolean findPrevious(StepMeta startStep, StepMeta stepToFind) {
        boolean found;
        StepMeta stepMeta;
        int i;
        int nrPrevious = this.findNrPrevSteps(startStep, false);
        for (i = 0; i < nrPrevious; ++i) {
            stepMeta = this.findPrevStep(startStep, i, false);
            if (stepMeta.equals(stepToFind)) {
                return true;
            }
            found = this.findPrevious(stepMeta, stepToFind);
            if (!found) continue;
            return true;
        }
        nrPrevious = this.findNrPrevSteps(startStep, true);
        for (i = 0; i < nrPrevious; ++i) {
            stepMeta = this.findPrevStep(startStep, i, true);
            if (stepMeta.equals(stepToFind)) {
                return true;
            }
            found = this.findPrevious(stepMeta, stepToFind);
            if (!found) continue;
            return true;
        }
        return false;
    }

    public void sortSteps() {
        try {
            Collections.sort(this.steps);
        }
        catch (Exception e) {
            LogWriter.getInstance().logError(this.toString(), Messages.getString("TransMeta.Exception.ErrorOfSortingSteps") + e, new Object[0]);
            LogWriter.getInstance().logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
        }
    }

    public void sortHops() {
        Collections.sort(this.hops);
    }

    public Map<StepMeta, Map<StepMeta, Boolean>> sortStepsNatural() {
        long startTime = System.currentTimeMillis();
        this.prevCount = 0L;
        final HashMap<StepMeta, Map<StepMeta, Boolean>> stepMap = new HashMap<StepMeta, Map<StepMeta, Boolean>>();
        HashMap<StepMeta, List<StepMeta>> previousCache = new HashMap<StepMeta, List<StepMeta>>();
        HashMap<StepMeta, Map<StepMeta, Boolean>> beforeCache = new HashMap<StepMeta, Map<StepMeta, Boolean>>();
        for (StepMeta stepMeta : this.steps) {
            List<StepMeta> prevSteps = (List<StepMeta>)previousCache.get(stepMeta);
            if (prevSteps == null) {
                prevSteps = this.findPreviousSteps(stepMeta);
                ++this.prevCount;
                previousCache.put(stepMeta, prevSteps);
            }
            for (StepMeta prev : prevSteps) {
                Map<StepMeta, Boolean> beforePrevMap = this.updateFillStepMap(previousCache, beforeCache, stepMeta, prev);
                stepMap.put(stepMeta, beforePrevMap);
                beforeCache.put(prev, beforePrevMap);
            }
        }
        Collections.sort(this.steps, new Comparator<StepMeta>(){

            @Override
            public int compare(StepMeta o1, StepMeta o2) {
                Map beforeMap = (Map)stepMap.get(o1);
                if (beforeMap != null) {
                    if (beforeMap.get(o2) == null) {
                        return -1;
                    }
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        long endTime = System.currentTimeMillis();
        log.logBasic(this.toString(), "Natural sort of steps executed in " + (endTime - startTime) + "ms (" + this.prevCount + " time previous steps calculated)", new Object[0]);
        return stepMap;
    }

    private Map<StepMeta, Boolean> updateFillStepMap(Map<StepMeta, List<StepMeta>> previousCache, Map<StepMeta, Map<StepMeta, Boolean>> beforeCache, StepMeta originStepMeta, StepMeta previousStepMeta) {
        Map<StepMeta, Boolean> beforeMap = beforeCache.get(previousStepMeta);
        if (beforeMap != null) {
            return beforeMap;
        }
        beforeMap = new HashMap<StepMeta, Boolean>();
        beforeMap.put(previousStepMeta, Boolean.TRUE);
        List<StepMeta> prevSteps = previousCache.get(previousStepMeta);
        if (prevSteps == null) {
            prevSteps = this.findPreviousSteps(previousStepMeta);
            ++this.prevCount;
            previousCache.put(previousStepMeta, prevSteps);
        }
        for (StepMeta prev : prevSteps) {
            Map<StepMeta, Boolean> beforePrevMap = this.updateFillStepMap(previousCache, beforeCache, originStepMeta, prev);
            beforeCache.put(prev, beforePrevMap);
            beforeMap.putAll(beforePrevMap);
        }
        return beforeMap;
    }

    public void sortHopsNatural() {
        for (int j = 0; j < this.nrTransHops(); ++j) {
            for (int i = 0; i < this.nrTransHops() - 1; ++i) {
                StepMeta b;
                TransHopMeta one = this.getTransHop(i);
                TransHopMeta two = this.getTransHop(i + 1);
                StepMeta a = two.getFromStep();
                if (this.findPrevious(a, b = one.getToStep()) || a.equals(b)) continue;
                this.setTransHop(i + 1, one);
                this.setTransHop(i, two);
            }
        }
    }

    public void analyseImpact(List<DatabaseImpact> impact, ProgressMonitorListener monitor) throws KettleStepException {
        if (monitor != null) {
            monitor.beginTask(Messages.getString("TransMeta.Monitor.DeterminingImpactTask.Title"), this.nrSteps());
        }
        boolean stop = false;
        for (int i = 0; i < this.nrSteps() && !stop; ++i) {
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.LookingAtStepTask.Title") + (i + 1) + "/" + this.nrSteps());
            }
            StepMeta stepMeta = this.getStep(i);
            RowMetaInterface prev = this.getPrevStepFields(stepMeta);
            StepMetaInterface stepint = stepMeta.getStepMetaInterface();
            RowMetaInterface inform = null;
            StepMeta[] lu = this.getInfoStep(stepMeta);
            inform = lu != null ? this.getStepFields(lu) : stepint.getTableFields();
            stepint.analyseImpact(impact, this, stepMeta, prev, null, null, inform);
            if (monitor == null) continue;
            monitor.worked(1);
            stop = monitor.isCanceled();
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public String getAlternativeStepname(String stepname) {
        String newname = stepname;
        StepMeta stepMeta = this.findStep(newname);
        int nr = 1;
        while (stepMeta != null) {
            newname = stepname + " " + ++nr;
            stepMeta = this.findStep(newname);
        }
        return newname;
    }

    public List<SQLStatement> getSQLStatements() throws KettleStepException {
        return this.getSQLStatements(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLStatement> getSQLStatements(ProgressMonitorListener monitor) throws KettleStepException {
        if (monitor != null) {
            monitor.beginTask(Messages.getString("TransMeta.Monitor.GettingTheSQLForTransformationTask.Title"), this.nrSteps() + 1);
        }
        ArrayList<SQLStatement> stats = new ArrayList<SQLStatement>();
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.GettingTheSQLForStepTask.Title", "" + stepMeta));
            }
            RowMetaInterface prev = this.getPrevStepFields(stepMeta);
            SQLStatement sql = stepMeta.getStepMetaInterface().getSQLStatements(this, stepMeta, prev);
            if (sql.getSQL() != null || sql.hasError()) {
                stats.add(sql);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.subTask(Messages.getString("TransMeta.Monitor.GettingTheSQLForTransformationTask.Title2"));
        }
        if (!(this.logConnection == null || Const.isEmpty((String)this.logTable) && Const.isEmpty((String)this.stepPerformanceLogTable))) {
            Database db = new Database(this.logConnection);
            db.shareVariablesWith((VariableSpace)this);
            try {
                SQLStatement stat;
                RowMetaInterface fields;
                String sql;
                db.connect();
                if (!Const.isEmpty((String)this.logTable) && (sql = db.getDDL(this.logTable, fields = Database.getTransLogrecordFields((boolean)false, (boolean)this.useBatchId, (boolean)this.logfieldUsed))) != null && sql.length() > 0) {
                    stat = new SQLStatement("<this transformation>", this.logConnection, sql);
                    stats.add(stat);
                }
                if (!Const.isEmpty((String)this.stepPerformanceLogTable) && (sql = db.getDDL(this.logTable, fields = Database.getStepPerformanceLogrecordFields())) != null && sql.length() > 0) {
                    stat = new SQLStatement("<this transformation>", this.logConnection, sql);
                    stats.add(stat);
                }
            }
            catch (KettleDatabaseException dbe) {
                SQLStatement stat = new SQLStatement("<this transformation>", this.logConnection, null);
                stat.setError(Messages.getString("TransMeta.SQLStatement.ErrorDesc.ErrorObtainingTransformationLogTableInfo") + dbe.getMessage());
                stats.add(stat);
            }
            finally {
                db.disconnect();
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return stats;
    }

    public String getSQLStatementsString() throws KettleStepException {
        String sql = "";
        List<SQLStatement> stats = this.getSQLStatements();
        for (int i = 0; i < stats.size(); ++i) {
            SQLStatement stat = stats.get(i);
            if (stat.hasError() || !stat.hasSQL()) continue;
            sql = sql + stat.getSQL();
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSteps(List<CheckResultInterface> remarks, boolean only_selected, ProgressMonitorListener monitor) {
        try {
            StepMeta[] steps;
            String[] stepnames;
            remarks.clear();
            Hashtable<ValueMetaInterface, String> values = new Hashtable<ValueMetaInterface, String>();
            if (!only_selected || this.nrSelectedSteps() == 0) {
                stepnames = this.getStepNames();
                steps = this.getStepsArray();
            } else {
                stepnames = this.getSelectedStepNames();
                steps = this.getSelectedSteps();
            }
            boolean stop_checking = false;
            if (monitor != null) {
                monitor.beginTask(Messages.getString("TransMeta.Monitor.VerifyingThisTransformationTask.Title"), steps.length + 2);
            }
            for (int i = 0; i < steps.length && !stop_checking; ++i) {
                CheckResult cr;
                CheckResult cr2;
                if (monitor != null) {
                    monitor.subTask(Messages.getString("TransMeta.Monitor.VerifyingStepTask.Title", stepnames[i]));
                }
                StepMeta stepMeta = steps[i];
                int nrinfo = this.findNrInfoSteps(stepMeta);
                StepMeta[] infostep = null;
                if (nrinfo > 0) {
                    infostep = this.getInfoStep(stepMeta);
                }
                RowMetaInterface info = null;
                if (infostep != null) {
                    try {
                        info = this.getStepFields(infostep);
                    }
                    catch (KettleStepException kse) {
                        info = null;
                        cr2 = new CheckResult(4, Messages.getString("TransMeta.CheckResult.TypeResultError.ErrorOccurredGettingStepInfoFields.Description", "" + stepMeta, Const.CR + kse.getMessage()), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr2);
                    }
                }
                RowMetaInterface prev = null;
                try {
                    prev = this.getPrevStepFields(stepMeta);
                }
                catch (KettleStepException kse) {
                    cr = new CheckResult(4, Messages.getString("TransMeta.CheckResult.TypeResultError.ErrorOccurredGettingInputFields.Description", "" + stepMeta, Const.CR + kse.getMessage()), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    stop_checking = true;
                }
                if (this.isStepUsedInTransHops(stepMeta)) {
                    String[] input = this.getPrevStepNames(stepMeta);
                    String[] output = this.getNextStepNames(stepMeta);
                    stepMeta.check(remarks, this, prev, input, output, info);
                    if (prev != null) {
                        for (int x = 0; x < prev.size(); ++x) {
                            ValueMetaInterface v = prev.getValueMeta(x);
                            String name = v.getName();
                            if (name == null) {
                                values.put(v, Messages.getString("TransMeta.Value.CheckingFieldName.FieldNameIsEmpty.Description"));
                                continue;
                            }
                            if (name.indexOf(32) >= 0) {
                                values.put(v, Messages.getString("TransMeta.Value.CheckingFieldName.FieldNameContainsSpaces.Description"));
                                continue;
                            }
                            char[] list = new char[]{'.', ',', '-', '/', '+', '*', '\'', '\t', '\"', '|', '@', '(', ')', '{', '}', '!', '^'};
                            for (int c = 0; c < list.length; ++c) {
                                if (name.indexOf(list[c]) < 0) continue;
                                values.put(v, Messages.getString("TransMeta.Value.CheckingFieldName.FieldNameContainsUnfriendlyCodes.Description", String.valueOf(list[c])));
                            }
                        }
                        if (prev.size() > 1) {
                            String[] fieldNames = prev.getFieldNames();
                            String[] sortedNames = Const.sortStrings((String[])fieldNames);
                            String prevName = sortedNames[0];
                            for (int x = 1; x < sortedNames.length; ++x) {
                                if (prevName.equalsIgnoreCase(sortedNames[x])) {
                                    CheckResult cr3 = new CheckResult(4, Messages.getString("TransMeta.CheckResult.TypeResultWarning.HaveTheSameNameField.Description", prevName), (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr3);
                                    continue;
                                }
                                prevName = sortedNames[x];
                            }
                        }
                    } else {
                        CheckResult cr4 = new CheckResult(4, Messages.getString("TransMeta.CheckResult.TypeResultError.CannotFindPreviousFields.Description") + stepMeta.getName(), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr4);
                    }
                } else {
                    cr2 = new CheckResult(3, Messages.getString("TransMeta.CheckResult.TypeResultWarning.StepIsNotUsed.Description"), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr2);
                }
                try {
                    this.checkRowMixingStatically(stepMeta, null);
                }
                catch (KettleRowException e) {
                    cr = new CheckResult(4, e.getMessage(), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (monitor == null) continue;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                stop_checking = true;
            }
            if (monitor == null || !monitor.isCanceled()) {
                if (monitor != null) {
                    monitor.subTask(Messages.getString("TransMeta.Monitor.CheckingTheLoggingTableTask.Title"));
                }
                if (this.getLogConnection() != null) {
                    Database logdb = new Database(this.getLogConnection());
                    logdb.shareVariablesWith((VariableSpace)this);
                    try {
                        logdb.connect();
                        CheckResult cr = new CheckResult(1, Messages.getString("TransMeta.CheckResult.TypeResultOK.ConnectingWorks.Description"), null);
                        remarks.add((CheckResultInterface)cr);
                        if (this.getLogTable() != null) {
                            if (logdb.checkTableExists(this.getLogTable())) {
                                cr = new CheckResult(1, Messages.getString("TransMeta.CheckResult.TypeResultOK.LoggingTableExists.Description", this.getLogTable()), null);
                                remarks.add((CheckResultInterface)cr);
                                RowMetaInterface fields = Database.getTransLogrecordFields((boolean)false, (boolean)this.isBatchIdUsed(), (boolean)this.isLogfieldUsed());
                                String sql = logdb.getDDL(this.getLogTable(), fields);
                                if (sql == null || sql.length() == 0) {
                                    cr = new CheckResult(1, Messages.getString("TransMeta.CheckResult.TypeResultOK.CorrectLayout.Description"), null);
                                    remarks.add((CheckResultInterface)cr);
                                } else {
                                    cr = new CheckResult(4, Messages.getString("TransMeta.CheckResult.TypeResultError.LoggingTableNeedsAdjustments.Description") + Const.CR + sql, null);
                                    remarks.add((CheckResultInterface)cr);
                                }
                            } else {
                                cr = new CheckResult(4, Messages.getString("TransMeta.CheckResult.TypeResultError.LoggingTableDoesNotExist.Description"), null);
                                remarks.add((CheckResultInterface)cr);
                            }
                        } else {
                            cr = new CheckResult(4, Messages.getString("TransMeta.CheckResult.TypeResultError.LogTableNotSpecified.Description"), null);
                            remarks.add((CheckResultInterface)cr);
                        }
                    }
                    catch (KettleDatabaseException dbe) {
                    }
                    finally {
                        logdb.disconnect();
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("TransMeta.Monitor.CheckingForDatabaseUnfriendlyCharactersInFieldNamesTask.Title"));
            }
            if (values.size() > 0) {
                for (ValueMetaInterface v : values.keySet()) {
                    String message = (String)values.get(v);
                    CheckResult cr = new CheckResult(3, Messages.getString("TransMeta.CheckResult.TypeResultWarning.Description", v.getName(), message, v.getOrigin()), (CheckResultSourceInterface)this.findStep(v.getOrigin()));
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                CheckResult cr = new CheckResult(1, Messages.getString("TransMeta.CheckResult.TypeResultOK.Description"), null);
                remarks.add((CheckResultInterface)cr);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            LogWriter.getInstance().logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public List<RowMetaAndData> getResultRows() {
        return this.resultRows;
    }

    public void setResultRows(List<RowMetaAndData> resultRows) {
        this.resultRows = resultRows;
    }

    @Override
    public RepositoryDirectory getDirectory() {
        return this.directory;
    }

    public void setDirectory(RepositoryDirectory directory) {
        this.directory = directory;
        this.setInternalKettleVariables();
    }

    public RepositoryDirectory getDirectoryTree() {
        return this.directoryTree;
    }

    public void setDirectoryTree(RepositoryDirectory directoryTree) {
        this.directoryTree = directoryTree;
    }

    public String getPathAndName() {
        if (this.getDirectory().isRoot()) {
            return this.getDirectory().getPath() + this.getName();
        }
        return this.getDirectory().getPath() + "/" + this.getName();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public Hashtable<String, Counter> getCounters() {
        return this.counters;
    }

    public void setCounters(Hashtable<String, Counter> counters) {
        this.counters = counters;
    }

    public List<TransDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<TransDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public StepMeta getInputStep() {
        return this.inputStep;
    }

    public void setInputStep(StepMeta inputStep) {
        this.inputStep = inputStep;
    }

    public DatabaseMeta getLogConnection() {
        return this.logConnection;
    }

    public void setLogConnection(DatabaseMeta logConnection) {
        this.logConnection = logConnection;
    }

    public String getLogTable() {
        return this.logTable;
    }

    public void setLogTable(String logTable) {
        this.logTable = logTable;
    }

    public DatabaseMeta getMaxDateConnection() {
        return this.maxDateConnection;
    }

    public void setMaxDateConnection(DatabaseMeta maxDateConnection) {
        this.maxDateConnection = maxDateConnection;
    }

    public double getMaxDateDifference() {
        return this.maxDateDifference;
    }

    public void setMaxDateDifference(double maxDateDifference) {
        this.maxDateDifference = maxDateDifference;
    }

    public String getMaxDateField() {
        return this.maxDateField;
    }

    public void setMaxDateField(String maxDateField) {
        this.maxDateField = maxDateField;
    }

    public double getMaxDateOffset() {
        return this.maxDateOffset;
    }

    public void setMaxDateOffset(double maxDateOffset) {
        this.maxDateOffset = maxDateOffset;
    }

    public String getMaxDateTable() {
        return this.maxDateTable;
    }

    public void setMaxDateTable(String maxDateTable) {
        this.maxDateTable = maxDateTable;
    }

    public StepMeta getOutputStep() {
        return this.outputStep;
    }

    public void setOutputStep(StepMeta outputStep) {
        this.outputStep = outputStep;
    }

    public StepMeta getReadStep() {
        return this.readStep;
    }

    public void setReadStep(StepMeta readStep) {
        this.readStep = readStep;
    }

    public StepMeta getUpdateStep() {
        return this.updateStep;
    }

    public void setUpdateStep(StepMeta updateStep) {
        this.updateStep = updateStep;
    }

    public StepMeta getWriteStep() {
        return this.writeStep;
    }

    public void setWriteStep(StepMeta writeStep) {
        this.writeStep = writeStep;
    }

    public int getSizeRowset() {
        return this.sizeRowset;
    }

    public void setSizeRowset(int sizeRowset) {
        this.sizeRowset = sizeRowset;
    }

    public DBCache getDbCache() {
        return this.dbCache;
    }

    public void setDbCache(DBCache dbCache) {
        this.dbCache = dbCache;
    }

    public boolean isBatchIdUsed() {
        return this.useBatchId;
    }

    public void setBatchIdUsed(boolean useBatchId) {
        this.useBatchId = useBatchId;
    }

    public boolean isLogfieldUsed() {
        return this.logfieldUsed;
    }

    public void setLogfieldUsed(boolean logfieldUsed) {
        this.logfieldUsed = logfieldUsed;
    }

    @Override
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Override
    public void setCreatedUser(String createdUser) {
        this.createdUser = createdUser;
    }

    @Override
    public String getCreatedUser() {
        return this.createdUser;
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public void setModifiedUser(String modifiedUser) {
        this.modifiedUser = modifiedUser;
    }

    @Override
    public String getModifiedUser() {
        return this.modifiedUser;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String n) {
        this.description = n;
    }

    public void setExtendedDescription(String n) {
        this.extended_description = n;
    }

    public String getExtendedDescription() {
        return this.extended_description;
    }

    public String getTransversion() {
        return this.trans_version;
    }

    public void setTransversion(String n) {
        this.trans_version = n;
    }

    public void setTransstatus(int n) {
        this.trans_status = n;
    }

    public int getTransstatus() {
        return this.trans_status;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.filename != null) {
            return this.filename;
        }
        return TransMeta.class.getName();
    }

    public void cancelQueries() throws KettleDatabaseException {
        for (int i = 0; i < this.nrSteps(); ++i) {
            this.getStep(i).getStepMetaInterface().cancelQueries();
        }
    }

    public Map<String, String> getUsedArguments(String[] arguments) {
        HashMap<String, String> transArgs = new HashMap<String, String>();
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMetaInterface smi = this.getStep(i).getStepMetaInterface();
            Map<String, String> stepArgs = smi.getUsedArguments();
            if (stepArgs == null) continue;
            transArgs.putAll(stepArgs);
        }
        String[] saved = Props.isInitialized() ? Props.getInstance().getLastArguments() : null;
        for (String argument : transArgs.keySet()) {
            String value = "";
            int argNr = Const.toInt((String)argument, (int)-1);
            if (arguments != null && argNr > 0 && argNr <= arguments.length) {
                value = Const.NVL((String)arguments[argNr - 1], (String)"");
            }
            if (value.length() == 0 && argNr > 0 && argNr < saved.length && saved[argNr] != null) {
                value = saved[argNr - 1];
            }
            transArgs.put(argument, value);
        }
        return transArgs;
    }

    public int getSleepTimeEmpty() {
        return 50;
    }

    public int getSleepTimeFull() {
        return 50;
    }

    public void setSleepTimeEmpty(int sleepTimeEmpty) {
        this.sleepTimeEmpty = sleepTimeEmpty;
    }

    public void setSleepTimeFull(int sleepTimeFull) {
        this.sleepTimeFull = sleepTimeFull;
    }

    public boolean isDatabaseConnectionUsed(DatabaseMeta databaseMeta) {
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            DatabaseMeta[] dbs = stepMeta.getStepMetaInterface().getUsedDatabaseConnections();
            for (int d = 0; d < dbs.length; ++d) {
                if (!dbs[d].equals((Object)databaseMeta)) continue;
                return true;
            }
        }
        return this.logConnection != null && this.logConnection.equals((Object)databaseMeta);
    }

    public List<StringSearchResult> getStringList(boolean searchSteps, boolean searchDatabases, boolean searchNotes, boolean includePasswords) {
        Object meta;
        int i;
        ArrayList<StringSearchResult> stringList = new ArrayList<StringSearchResult>();
        if (searchSteps) {
            for (i = 0; i < this.nrSteps(); ++i) {
                StepMeta stepMeta = this.getStep(i);
                stringList.add(new StringSearchResult(stepMeta.getName(), stepMeta, this, "Step name"));
                if (stepMeta.getDescription() != null) {
                    stringList.add(new StringSearchResult(stepMeta.getDescription(), stepMeta, this, "Step description"));
                }
                StepMetaInterface metaInterface = stepMeta.getStepMetaInterface();
                StringSearcher.findMetaData(metaInterface, 1, stringList, stepMeta, this);
            }
        }
        if (searchDatabases) {
            for (i = 0; i < this.nrDatabases(); ++i) {
                meta = this.getDatabase(i);
                stringList.add(new StringSearchResult(meta.getName(), meta, this, "Database connection name"));
                if (meta.getHostname() != null) {
                    stringList.add(new StringSearchResult(meta.getHostname(), meta, this, "Database hostname"));
                }
                if (meta.getDatabaseName() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabaseName(), meta, this, "Database name"));
                }
                if (meta.getUsername() != null) {
                    stringList.add(new StringSearchResult(meta.getUsername(), meta, this, "Database Username"));
                }
                if (meta.getDatabaseTypeDesc() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabaseTypeDesc(), meta, this, "Database type description"));
                }
                if (meta.getDatabasePortNumberString() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabasePortNumberString(), meta, this, "Database port"));
                }
                if (meta.getServername() != null) {
                    stringList.add(new StringSearchResult(meta.getServername(), meta, this, "Database server"));
                }
                if (!includePasswords || meta.getPassword() == null) continue;
                stringList.add(new StringSearchResult(meta.getPassword(), meta, this, "Database password"));
            }
        }
        if (searchNotes) {
            for (i = 0; i < this.nrNotes(); ++i) {
                meta = this.getNote(i);
                if (((NotePadMeta)meta).getNote() == null) continue;
                stringList.add(new StringSearchResult(((NotePadMeta)meta).getNote(), meta, this, "Notepad text"));
            }
        }
        return stringList;
    }

    public List<StringSearchResult> getStringList(boolean searchSteps, boolean searchDatabases, boolean searchNotes) {
        return this.getStringList(searchSteps, searchDatabases, searchNotes, false);
    }

    public List<String> getUsedVariables() {
        List<StringSearchResult> stringList = this.getStringList(true, true, false, true);
        ArrayList<String> varList = new ArrayList<String>();
        for (int i = 0; i < stringList.size(); ++i) {
            StringSearchResult result = stringList.get(i);
            StringUtil.getUsedVariables((String)result.getString(), varList, (boolean)false);
        }
        return varList;
    }

    public Result getPreviousResult() {
        return this.previousResult;
    }

    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    public List<ResultFile> getResultFiles() {
        return this.resultFiles;
    }

    public void setResultFiles(List<ResultFile> resultFiles) {
        this.resultFiles = resultFiles;
    }

    public List<PartitionSchema> getPartitionSchemas() {
        return this.partitionSchemas;
    }

    public void setPartitionSchemas(List<PartitionSchema> partitionSchemas) {
        this.partitionSchemas = partitionSchemas;
    }

    public String[] getPartitionSchemasNames() {
        String[] names = new String[this.partitionSchemas.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.partitionSchemas.get(i).getName();
        }
        return names;
    }

    public boolean isFeedbackShown() {
        return this.feedbackShown;
    }

    public void setFeedbackShown(boolean feedbackShown) {
        this.feedbackShown = feedbackShown;
    }

    public int getFeedbackSize() {
        return this.feedbackSize;
    }

    public void setFeedbackSize(int feedbackSize) {
        this.feedbackSize = feedbackSize;
    }

    public boolean isUsingUniqueConnections() {
        return this.usingUniqueConnections;
    }

    public void setUsingUniqueConnections(boolean usingUniqueConnections) {
        this.usingUniqueConnections = usingUniqueConnections;
    }

    public List<ClusterSchema> getClusterSchemas() {
        return this.clusterSchemas;
    }

    public void setClusterSchemas(List<ClusterSchema> clusterSchemas) {
        this.clusterSchemas = clusterSchemas;
    }

    public String[] getClusterSchemaNames() {
        String[] names = new String[this.clusterSchemas.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.clusterSchemas.get(i).getName();
        }
        return names;
    }

    public PartitionSchema findPartitionSchema(String name) {
        for (int i = 0; i < this.partitionSchemas.size(); ++i) {
            PartitionSchema schema = this.partitionSchemas.get(i);
            if (!schema.getName().equalsIgnoreCase(name)) continue;
            return schema;
        }
        return null;
    }

    public ClusterSchema findClusterSchema(String name) {
        for (int i = 0; i < this.clusterSchemas.size(); ++i) {
            ClusterSchema schema = this.clusterSchemas.get(i);
            if (!schema.getName().equalsIgnoreCase(name)) continue;
            return schema;
        }
        return null;
    }

    public void addOrReplacePartitionSchema(PartitionSchema partitionSchema) {
        int index = this.partitionSchemas.indexOf(partitionSchema);
        if (index < 0) {
            this.partitionSchemas.add(partitionSchema);
        } else {
            PartitionSchema previous = this.partitionSchemas.get(index);
            previous.replaceMeta(partitionSchema);
        }
        this.setChanged();
    }

    public void addOrReplaceSlaveServer(SlaveServer slaveServer) {
        int index = this.slaveServers.indexOf(slaveServer);
        if (index < 0) {
            this.slaveServers.add(slaveServer);
        } else {
            SlaveServer previous = this.slaveServers.get(index);
            previous.replaceMeta(slaveServer);
        }
        this.setChanged();
    }

    public void addOrReplaceClusterSchema(ClusterSchema clusterSchema) {
        int index = this.clusterSchemas.indexOf(clusterSchema);
        if (index < 0) {
            this.clusterSchemas.add(clusterSchema);
        } else {
            ClusterSchema previous = this.clusterSchemas.get(index);
            previous.replaceMeta(clusterSchema);
        }
        this.setChanged();
    }

    public String getSharedObjectsFile() {
        return this.sharedObjectsFile;
    }

    public void setSharedObjectsFile(String sharedObjectsFile) {
        this.sharedObjectsFile = sharedObjectsFile;
    }

    @Override
    public boolean saveSharedObjects() {
        try {
            String soFile = this.environmentSubstitute(this.sharedObjectsFile);
            SharedObjects sharedObjects = new SharedObjects(soFile);
            ArrayList<Object> shared = new ArrayList<Object>();
            shared.addAll(this.databases);
            shared.addAll(this.steps);
            shared.addAll(this.partitionSchemas);
            shared.addAll(this.slaveServers);
            shared.addAll(this.clusterSchemas);
            for (SharedObjectInterface sharedObjectInterface : shared) {
                if (!sharedObjectInterface.isShared()) continue;
                sharedObjects.storeObject(sharedObjectInterface);
            }
            sharedObjects.saveToFile();
            return true;
        }
        catch (Exception e) {
            log.logError(this.toString(), "Unable to save shared ojects: " + e.toString(), new Object[0]);
            return false;
        }
    }

    public boolean isUsingThreadPriorityManagment() {
        return this.usingThreadPriorityManagment;
    }

    public void setUsingThreadPriorityManagment(boolean usingThreadPriorityManagment) {
        this.usingThreadPriorityManagment = usingThreadPriorityManagment;
    }

    public SlaveServer findSlaveServer(String serverString) {
        return SlaveServer.findSlaveServer(this.slaveServers, serverString);
    }

    public String[] getSlaveServerNames() {
        return SlaveServer.getSlaveServerNames(this.slaveServers);
    }

    @Override
    public List<SlaveServer> getSlaveServers() {
        return this.slaveServers;
    }

    public void setSlaveServers(List<SlaveServer> slaveServers) {
        this.slaveServers = slaveServers;
    }

    public StepMeta getRejectedStep() {
        return this.rejectedStep;
    }

    public void setRejectedStep(StepMeta rejectedStep) {
        this.rejectedStep = rejectedStep;
    }

    public void checkRowMixingStatically(StepMeta stepMeta, ProgressMonitorListener monitor) throws KettleRowException {
        int nrPrevious = this.findNrPrevSteps(stepMeta);
        if (nrPrevious > 1) {
            RowMetaInterface referenceRow = null;
            for (int i = 0; i < nrPrevious; ++i) {
                StepMeta previousStep = this.findPrevStep(stepMeta, i);
                try {
                    RowMetaInterface row = this.getStepFields(previousStep, monitor);
                    if (referenceRow == null) {
                        referenceRow = row;
                        continue;
                    }
                    if (stepMeta.getStepMetaInterface().excludeFromRowLayoutVerification()) continue;
                    BaseStep.safeModeChecking(referenceRow, row);
                    continue;
                }
                catch (KettleStepException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setInternalKettleVariables() {
        this.setInternalKettleVariables(this.variables);
    }

    public void setInternalKettleVariables(VariableSpace var) {
        if (!Const.isEmpty((String)this.filename)) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.filename);
                FileName fileName = fileObject.getName();
                var.setVariable("Internal.Transformation.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                var.setVariable("Internal.Transformation.Filename.Directory", fileDir.getURI());
            }
            catch (IOException e) {
                var.setVariable("Internal.Transformation.Filename.Directory", "");
                var.setVariable("Internal.Transformation.Filename.Name", "");
            }
        } else {
            var.setVariable("Internal.Transformation.Filename.Directory", "");
            var.setVariable("Internal.Transformation.Filename.Name", "");
        }
        var.setVariable("Internal.Transformation.Name", Const.NVL((String)this.name, (String)""));
        var.setVariable("Internal.Transformation.Repository.Directory", this.directory != null ? this.directory.getPath() : "");
        if (var.getVariable("Internal.Job.Filename.Directory") == null) {
            var.setVariable("Internal.Job.Filename.Directory", "Parent Job File Directory");
        }
        if (var.getVariable("Internal.Job.Filename.Name") == null) {
            var.setVariable("Internal.Job.Filename.Name", "Parent Job Filename");
        }
        if (var.getVariable("Internal.Job.Name") == null) {
            var.setVariable("Internal.Job.Name", "Parent Job Name");
        }
        if (var.getVariable("Internal.Transformation.Repository.Directory") == null) {
            var.setVariable("Internal.Transformation.Repository.Directory", "Parent Job Repository Directory");
        }
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public StepMeta findMappingInputStep(String stepname) throws KettleStepException {
        if (!Const.isEmpty((String)stepname)) {
            StepMeta stepMeta = this.findStep(stepname);
            if (stepMeta == null) {
                throw new KettleStepException(Messages.getString("TransMeta.Exception.StepNameNotFound", stepname));
            }
            return stepMeta;
        }
        StepMeta stepMeta = null;
        for (StepMeta mappingStep : this.steps) {
            if (!mappingStep.getStepID().equals("MappingInput")) continue;
            if (stepMeta == null) {
                stepMeta = mappingStep;
                continue;
            }
            if (stepMeta == null) continue;
            throw new KettleStepException(Messages.getString("TransMeta.Exception.OnlyOneMappingInputStepAllowed", "2"));
        }
        if (stepMeta == null) {
            throw new KettleStepException(Messages.getString("TransMeta.Exception.OneMappingInputStepRequired"));
        }
        return stepMeta;
    }

    public StepMeta findMappingOutputStep(String stepname) throws KettleStepException {
        if (!Const.isEmpty((String)stepname)) {
            StepMeta stepMeta = this.findStep(stepname);
            if (stepMeta == null) {
                throw new KettleStepException(Messages.getString("TransMeta.Exception.StepNameNotFound", stepname));
            }
            return stepMeta;
        }
        StepMeta stepMeta = null;
        for (StepMeta mappingStep : this.steps) {
            if (!mappingStep.getStepID().equals("MappingOutput")) continue;
            if (stepMeta == null) {
                stepMeta = mappingStep;
                continue;
            }
            if (stepMeta == null) continue;
            throw new KettleStepException(Messages.getString("TransMeta.Exception.OnlyOneMappingOutputStepAllowed", "2"));
        }
        if (stepMeta == null) {
            throw new KettleStepException(Messages.getString("TransMeta.Exception.OneMappingOutputStepRequired"));
        }
        return stepMeta;
    }

    public List<ResourceReference> getResourceDependencies() {
        ArrayList<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
        for (StepMeta stepMeta : this.steps) {
            resourceReferences.addAll(stepMeta.getResourceDependencies(this));
        }
        return resourceReferences;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            String fullname;
            String baseName;
            String originalPath;
            String extension = "ktr";
            if (Const.isEmpty((String)this.getFilename())) {
                originalPath = this.directory.getPath();
                baseName = this.getName();
                fullname = this.directory.getPath() + (this.directory.getPath().endsWith("/") ? "" : "/") + this.getName() + "." + extension;
            } else {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.getFilename()));
                originalPath = fileObject.getParent().getName().getPath();
                baseName = fileObject.getName().getBaseName();
                fullname = fileObject.getName().getPath();
            }
            String exportFileName = resourceNamingInterface.nameResource(baseName, originalPath, extension, ResourceNamingInterface.FileNamingType.TRANSFORMATION);
            ResourceDefinition definition = definitions.get(exportFileName);
            if (definition == null) {
                TransMeta transMeta = (TransMeta)this.realClone(false);
                for (StepMeta stepMeta : transMeta.getSteps()) {
                    stepMeta.exportResources(space, definitions, resourceNamingInterface, repository);
                }
                transMeta.setFilename(exportFileName);
                Map<String, String> directoryMap = resourceNamingInterface.getDirectoryMap();
                if (directoryMap != null) {
                    for (String directory : directoryMap.keySet()) {
                        String parameterName = directoryMap.get(directory);
                        transMeta.addParameterDefinition(parameterName, directory, "Data file path discovered during export");
                    }
                }
                String transMetaContent = transMeta.getXML();
                definition = new ResourceDefinition(exportFileName, transMetaContent);
                if (Const.isEmpty((String)this.getFilename())) {
                    definition.setOrigin(fullname);
                } else {
                    definition.setOrigin(this.getFilename());
                }
                definitions.put(fullname, definition);
            }
            return exportFileName;
        }
        catch (FileSystemException e) {
            throw new KettleException(Messages.getString("TransMeta.Exception.ErrorOpeningOrValidatingTheXMLFile", this.getFilename()), (Throwable)e);
        }
        catch (IOException e) {
            throw new KettleException(Messages.getString("TransMeta.Exception.ErrorOpeningOrValidatingTheXMLFile", this.getFilename()), (Throwable)e);
        }
    }

    public SlaveStepCopyPartitionDistribution getSlaveStepCopyPartitionDistribution() {
        return this.slaveStepCopyPartitionDistribution;
    }

    public void setSlaveStepCopyPartitionDistribution(SlaveStepCopyPartitionDistribution slaveStepCopyPartitionDistribution) {
        this.slaveStepCopyPartitionDistribution = slaveStepCopyPartitionDistribution;
    }

    public ClusterSchema findFirstUsedClusterSchema() {
        for (StepMeta stepMeta : this.steps) {
            if (stepMeta.getClusterSchema() == null) continue;
            return stepMeta.getClusterSchema();
        }
        return null;
    }

    public boolean isSlaveTransformation() {
        return this.slaveTransformation;
    }

    public void setSlaveTransformation(boolean slaveTransformation) {
        this.slaveTransformation = slaveTransformation;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public boolean isCapturingStepPerformanceSnapShots() {
        return this.capturingStepPerformanceSnapShots;
    }

    public void setCapturingStepPerformanceSnapShots(boolean capturingStepPerformanceSnapShots) {
        this.capturingStepPerformanceSnapShots = capturingStepPerformanceSnapShots;
    }

    public long getStepPerformanceCapturingDelay() {
        return this.stepPerformanceCapturingDelay;
    }

    public void setStepPerformanceCapturingDelay(long stepPerformanceCapturingDelay) {
        this.stepPerformanceCapturingDelay = stepPerformanceCapturingDelay;
    }

    public SharedObjects getSharedObjects() {
        return this.sharedObjects;
    }

    public void setSharedObjects(SharedObjects sharedObjects) {
        this.sharedObjects = sharedObjects;
    }

    private void clearStepFieldsCachce() {
        this.stepsFieldsCache.clear();
    }

    private void clearLoopCachce() {
        this.loopCache.clear();
    }

    public String getStepPerformanceLogTable() {
        return this.stepPerformanceLogTable;
    }

    public void setStepPerformanceLogTable(String stepPerformanceLogTable) {
        this.stepPerformanceLogTable = stepPerformanceLogTable;
    }

    public void addNameChangedListener(NameChangedListener listener) {
        if (this.nameChangedListeners == null) {
            this.nameChangedListeners = new ArrayList<NameChangedListener>();
        }
        this.nameChangedListeners.add(listener);
    }

    public void removeNameChangedListener(NameChangedListener listener) {
        this.nameChangedListeners.remove(listener);
    }

    public void addFilenameChangedListener(FilenameChangedListener listener) {
        if (this.filenameChangedListeners == null) {
            this.filenameChangedListeners = new ArrayList<FilenameChangedListener>();
        }
        this.filenameChangedListeners.add(listener);
    }

    public void removeFilenameChangedListener(FilenameChangedListener listener) {
        this.filenameChangedListeners.remove(listener);
    }

    private boolean nameChanged(String oldFilename, String newFilename) {
        if (oldFilename == null && newFilename == null) {
            return false;
        }
        if (oldFilename == null && newFilename != null) {
            return true;
        }
        return oldFilename.equals(newFilename);
    }

    private void fireFilenameChangedListeners(String oldFilename, String newFilename) {
        if (this.nameChanged(oldFilename, newFilename) && this.filenameChangedListeners != null) {
            for (FilenameChangedListener listener : this.filenameChangedListeners) {
                listener.filenameChanged(this, oldFilename, newFilename);
            }
        }
    }

    private void fireNameChangedListeners(String oldName, String newName) {
        if (this.nameChanged(oldName, newName) && this.nameChangedListeners != null) {
            for (NameChangedListener listener : this.nameChangedListeners) {
                listener.nameChanged(this, oldName, newName);
            }
        }
    }

    public void activateParameters() {
        String[] keys;
        for (String key : keys = this.listParameters()) {
            String defValue;
            String value;
            try {
                value = this.getParameterValue(key);
            }
            catch (UnknownParamException e) {
                value = "";
            }
            try {
                defValue = this.getParameterDefault(key);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            if (Const.isEmpty((String)value)) {
                this.setVariable(key, Const.NVL((String)defValue, (String)""));
                continue;
            }
            this.setVariable(key, Const.NVL((String)value, (String)""));
        }
    }

    public void addParameterDefinition(String key, String defaultValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defaultValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void eraseParameters() {
        this.namedParams.eraseParameters();
    }

    public void clearParameters() {
        this.namedParams.clearParameters();
    }

    public void copyParametersFrom(NamedParams params) {
        this.namedParams.copyParametersFrom(params);
    }

    public String getLogSizeLimit() {
        return this.logSizeLimit;
    }

    public void setLogSizeLimit(String logSizeLimit) {
        this.logSizeLimit = logSizeLimit;
    }
}

