/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;

public class MultipleArtifactsNotFoundException
extends ArtifactResolutionException {
    private final List<Artifact> resolvedArtifacts;
    private final List<Artifact> missingArtifacts;

    @Deprecated
    public MultipleArtifactsNotFoundException(Artifact originatingArtifact, List<Artifact> missingArtifacts, List<ArtifactRepository> remoteRepositories) {
        this(originatingArtifact, new ArrayList<Artifact>(), missingArtifacts, remoteRepositories);
    }

    public MultipleArtifactsNotFoundException(Artifact originatingArtifact, List<Artifact> resolvedArtifacts, List<Artifact> missingArtifacts, List<ArtifactRepository> remoteRepositories) {
        super(MultipleArtifactsNotFoundException.constructMessage(missingArtifacts), originatingArtifact, remoteRepositories);
        this.resolvedArtifacts = resolvedArtifacts;
        this.missingArtifacts = missingArtifacts;
    }

    public List<Artifact> getResolvedArtifacts() {
        return this.resolvedArtifacts;
    }

    public List<Artifact> getMissingArtifacts() {
        return this.missingArtifacts;
    }

    private static String constructMessage(List<Artifact> artifacts) {
        StringBuilder buffer2 = new StringBuilder(256);
        buffer2.append("Missing:\n");
        buffer2.append("----------\n");
        int counter = 0;
        for (Artifact artifact : artifacts) {
            String message = ++counter + ") " + artifact.getId();
            buffer2.append(MultipleArtifactsNotFoundException.constructMissingArtifactMessage(message, "  ", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier(), artifact.getDownloadUrl(), artifact.getDependencyTrail()));
        }
        buffer2.append("----------\n");
        int size = artifacts.size();
        buffer2.append(size).append(" required artifact");
        if (size > 1) {
            buffer2.append("s are");
        } else {
            buffer2.append(" is");
        }
        buffer2.append(" missing.\n\nfor artifact: ");
        return buffer2.toString();
    }
}

