/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class IndexFunction<K, V>
implements ListBucketBaseFunction<K, V, V> {
    public static final AdvancedExternalizer<IndexFunction> EXTERNALIZER = new Externalizer();
    private final long index;

    public IndexFunction(long index) {
        this.index = index;
    }

    public V apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            return ((ListBucket)existing.get()).index(this.index);
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<IndexFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends IndexFunction>> getTypeClasses() {
            return Collections.singleton(IndexFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.INDEX_FUNCTION;
        }

        public void writeObject(ObjectOutput output, IndexFunction object) throws IOException {
            output.writeLong(object.index);
        }

        public IndexFunction readObject(ObjectInput input) throws IOException {
            return new IndexFunction(input.readLong());
        }
    }
}

