/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.NativeResourceException;
import gnu.io.RXTXCommDriver;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import gnu.io.factory.RFC2217PortCreator;
import gnu.io.factory.RxTxPortCreator;
import gnu.io.rfc2217.TelnetSerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TooManyListenersException;

public class NRSerialPort {
    private SerialPort serial;
    private String port = null;
    private boolean connected = false;
    private int baud = 115200;
    private int parity = 0;
    private int dataBits = 8;
    private int stopBits = 1;

    public NRSerialPort(String port) {
        this.setPort(port);
    }

    public NRSerialPort(String port, int baud) {
        this.setPort(port);
        this.setBaud(baud);
    }

    public NRSerialPort(String port, int baud, int parity) {
        this.setPort(port);
        this.setBaud(baud);
        this.setParity(parity);
    }

    public NRSerialPort(String port, int baud, int parity, int dataBits) {
        this.setPort(port);
        this.setBaud(baud);
        this.setParity(parity);
        this.setDataBits(dataBits);
    }

    public NRSerialPort(String port, int baud, int parity, int dataBits, int stopBits) {
        this.setPort(port);
        this.setBaud(baud);
        this.setParity(parity);
        this.setDataBits(dataBits);
        this.setStopBits(stopBits);
    }

    public boolean connect() {
        if (this.isConnected()) {
            System.err.println(this.port + " is already connected.");
            return true;
        }
        try {
            this.serial = this.port.toLowerCase().startsWith("rfc2217") ? new RFC2217PortCreator().createPort(this.port) : new RxTxPortCreator().createPort(this.port);
            this.serial.setSerialPortParams(this.getBaud(), this.getDataBits(), this.getStopBits(), this.getParity());
            this.setConnected(true);
        }
        catch (NativeResourceException e) {
            throw new NativeResourceException(e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Failed to connect on port: " + this.port + " exception: ");
            e.printStackTrace();
            this.setConnected(false);
        }
        if (this.isConnected()) {
            this.serial.notifyOnDataAvailable(true);
        }
        return this.isConnected();
    }

    public InputStream getInputStream() {
        try {
            return this.serial.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.serial.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setPort(String port) {
        this.port = port;
    }

    public void disconnect() {
        try {
            try {
                this.getInputStream().close();
                this.getOutputStream().close();
                this.serial.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.serial = null;
            this.setConnected(false);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeResourceException(e.getMessage());
        }
    }

    public static Set<String> getAvailableSerialPorts() {
        HashSet<String> available = new HashSet<String>();
        try {
            RXTXCommDriver d = new RXTXCommDriver();
            Set<String> av = d.getPortIdentifiers();
            ArrayList<String> strs = new ArrayList<String>();
            for (String s : av) {
                strs.add(0, s);
            }
            for (String s : strs) {
                available.add(s);
            }
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            throw new NativeResourceException(e.getMessage());
        }
        return available;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        if (this.connected == connected) {
            return;
        }
        this.connected = connected;
    }

    public void setBaud(int baud) {
        this.baud = baud;
    }

    public int getBaud() {
        return this.baud;
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public int getParity() {
        return this.parity;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public void setDataBits(int dataBits) {
        this.dataBits = dataBits;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int enableRs485(boolean busEnableActiveLow, int delayBusEnableBeforeSendMs, int delayBusEnableAfterSendMs) {
        if (this.serial == null) {
            return -1;
        }
        if (RXTXPort.class.isInstance(this.serial)) {
            return ((RXTXPort)this.serial).enableRs485(busEnableActiveLow, delayBusEnableBeforeSendMs, delayBusEnableAfterSendMs);
        }
        return -1;
    }

    public void notifyOnDataAvailable(boolean b) {
        this.serial.notifyOnDataAvailable(b);
    }

    public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        this.serial.addEventListener(lsnr);
    }

    public void removeEventListener() {
        this.serial.removeEventListener();
    }

    public RXTXPort getSerialPortInstance() {
        if (RXTXPort.class.isInstance(this.serial)) {
            return (RXTXPort)this.serial;
        }
        return null;
    }

    public TelnetSerialPort getTelnetSerialPortInstance() {
        if (TelnetSerialPort.class.isInstance(this.serial)) {
            return (TelnetSerialPort)this.serial;
        }
        return null;
    }
}

