/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(-20l, -30l, true) => -30l
 * mix(-20l, -30l, false) => -20l
 * mix(-20l, 30l, true) => 30l
 * mix(-20l, 30l, false) => -20l
 * mix(20l, -30l, true) => -30l
 * mix(20l, -30l, false) => 20l
 * mix(20l, 30l, true) => 30l
 * mix(20l, 30l, false) => 20l
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[mix(-20l, -30l, true) == -30l ? 1 : -1] array0;
  float[mix(-20l, -30l, false) == -20l ? 1 : -1] array1;
  float[mix(-20l, 30l, true) == 30l ? 1 : -1] array2;
  float[mix(-20l, 30l, false) == -20l ? 1 : -1] array3;
  float[mix(20l, -30l, true) == -30l ? 1 : -1] array4;
  float[mix(20l, -30l, false) == 20l ? 1 : -1] array5;
  float[mix(20l, 30l, true) == 30l ? 1 : -1] array6;
  float[mix(20l, 30l, false) == 20l ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
