/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public final class InetSocketAddressUtil {
    @NotNull
    public static InetSocketAddress create(@NotNull String host, int port) {
        byte[] ipAddress = NetUtil.createByteArrayFromIpAddressString((String)host);
        if (ipAddress != null) {
            try {
                return new InetSocketAddress(InetAddress.getByAddress(ipAddress), port);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    private InetSocketAddressUtil() {
    }
}

