/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports.common;

import org.traccar.config.Keys;
import org.traccar.helper.model.AttributeUtil;

public class TripsConfig {
    private final double minimalTripDistance;
    private final long minimalTripDuration;
    private final long minimalParkingDuration;
    private final long minimalNoDataDuration;
    private final boolean useIgnition;
    private final boolean ignoreOdometer;

    public TripsConfig(AttributeUtil.Provider attributeProvider) {
        this(AttributeUtil.lookup(attributeProvider, Keys.REPORT_TRIP_MINIMAL_TRIP_DISTANCE).longValue(), AttributeUtil.lookup(attributeProvider, Keys.REPORT_TRIP_MINIMAL_TRIP_DURATION) * 1000L, AttributeUtil.lookup(attributeProvider, Keys.REPORT_TRIP_MINIMAL_PARKING_DURATION) * 1000L, AttributeUtil.lookup(attributeProvider, Keys.REPORT_TRIP_MINIMAL_NO_DATA_DURATION) * 1000L, AttributeUtil.lookup(attributeProvider, Keys.REPORT_TRIP_USE_IGNITION), AttributeUtil.lookup(attributeProvider, Keys.REPORT_IGNORE_ODOMETER));
    }

    public TripsConfig(double minimalTripDistance, long minimalTripDuration, long minimalParkingDuration, long minimalNoDataDuration, boolean useIgnition, boolean ignoreOdometer) {
        this.minimalTripDistance = minimalTripDistance;
        this.minimalTripDuration = minimalTripDuration;
        this.minimalParkingDuration = minimalParkingDuration;
        this.minimalNoDataDuration = minimalNoDataDuration;
        this.useIgnition = useIgnition;
        this.ignoreOdometer = ignoreOdometer;
    }

    public double getMinimalTripDistance() {
        return this.minimalTripDistance;
    }

    public long getMinimalTripDuration() {
        return this.minimalTripDuration;
    }

    public long getMinimalParkingDuration() {
        return this.minimalParkingDuration;
    }

    public long getMinimalNoDataDuration() {
        return this.minimalNoDataDuration;
    }

    public boolean getUseIgnition() {
        return this.useIgnition;
    }

    public boolean getIgnoreOdometer() {
        return this.ignoreOdometer;
    }
}

