/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket.jdk8;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.ice4j.ice.harvest.GoogleTurnSSLCandidateHarvester;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.HttpDemuxFilter;
import org.ice4j.socket.MuxServerSocketChannelFactory;
import org.ice4j.socket.jdk8.DatagramBuffer;
import org.ice4j.socket.jdk8.DelegatingServerSocketChannel;
import org.ice4j.socket.jdk8.MuxServerSocketChannel;
import org.ice4j.socket.jdk8.MuxingServerSocket;

class MuxingServerSocketChannel
extends DelegatingServerSocketChannel<ServerSocketChannel> {
    private static final InetAddress ANY_LOCAL_ADDRESS;
    private static Selector acceptSelector;
    private static Thread acceptThread;
    private static final List<MuxingServerSocketChannel> muxingServerSocketChannels;
    private static final int SELECTOR_SELECT_TIMEOUT = 15000;
    static final int SOCKET_CHANNEL_READ_TIMEOUT = 15000;
    private static final int SOCKET_CHANNEL_READ_CAPACITY;
    private final List<MuxServerSocketChannel> muxServerSocketChannels = new ArrayList<MuxServerSocketChannel>();
    private final Queue<SocketChannel> readQ = new LinkedList<SocketChannel>();
    private final Selector readSelector;
    private Thread readThread;
    private final Object syncRoot = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMuxingServerSocketChannel(MuxingServerSocketChannel channel) throws IOException {
        List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
        synchronized (list) {
            muxingServerSocketChannels.add(channel);
            muxingServerSocketChannels.notifyAll();
            MuxingServerSocketChannel.scheduleAccept(channel);
        }
    }

    public static void closeNoExceptions(Channel channel) {
        MuxServerSocketChannelFactory.closeNoExceptions(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MuxingServerSocketChannel findMuxingServerSocketChannel(SocketAddress localAddr) {
        MuxingServerSocketChannel channel = null;
        List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
        synchronized (list) {
            Iterator<MuxingServerSocketChannel> i = muxingServerSocketChannels.iterator();
            while (i.hasNext()) {
                MuxingServerSocketChannel aChannel = i.next();
                if (aChannel.isOpen()) {
                    boolean matches;
                    SocketAddress aLocalAddr;
                    try {
                        aLocalAddr = aChannel.getLocalAddress();
                    }
                    catch (ClosedChannelException cce) {
                        i.remove();
                        aLocalAddr = null;
                    }
                    catch (IOException ioe) {
                        aLocalAddr = null;
                    }
                    boolean bl = matches = aLocalAddr != null && aLocalAddr.equals(localAddr);
                    if (!matches && aLocalAddr instanceof InetSocketAddress && localAddr instanceof InetSocketAddress) {
                        InetSocketAddress aLocalInetAddr = (InetSocketAddress)aLocalAddr;
                        InetSocketAddress localInetAddr = (InetSocketAddress)localAddr;
                        boolean bl2 = matches = aLocalInetAddr.getAddress().equals(ANY_LOCAL_ADDRESS) && aLocalInetAddr.getPort() == localInetAddr.getPort();
                    }
                    if (!matches) continue;
                    channel = aChannel;
                    break;
                }
                i.remove();
            }
        }
        return channel;
    }

    private static void maybeCloseAcceptSelector() {
        if (acceptSelector != null) {
            if (acceptSelector.isOpen()) {
                try {
                    acceptSelector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            acceptSelector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MuxServerSocketChannel openAndBind(Map<String, Object> properties, SocketAddress endpoint, int backlog, DatagramPacketFilter filter) throws IOException {
        MuxingServerSocketChannel muxingChannel;
        Objects.requireNonNull(filter, "filter");
        List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
        synchronized (list) {
            muxingChannel = MuxingServerSocketChannel.findMuxingServerSocketChannel(endpoint);
            if (muxingChannel == null) {
                ServerSocketChannel channel = MuxServerSocketChannelFactory.openAndBindServerSocketChannel(properties, endpoint, backlog);
                muxingChannel = new MuxingServerSocketChannel(channel);
                MuxingServerSocketChannel.addMuxingServerSocketChannel(muxingChannel);
            }
        }
        return muxingChannel.createMuxServerSocketChannel(filter);
    }

    private static void runInAcceptThread() {
        MuxingServerSocketChannel.runInSelectorThread(muxingServerSocketChannels, new Supplier<Thread>(){

            @Override
            public Thread get() {
                return acceptThread;
            }
        }, new Supplier<Selector>(){

            @Override
            public Selector get() {
                return acceptSelector;
            }
        }, 16, muxingServerSocketChannels, new BiPredicate<MuxingServerSocketChannel, SelectionKey>(){

            @Override
            public boolean test(MuxingServerSocketChannel ch, SelectionKey sk) {
                try {
                    ch.accept();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends SelectableChannel> void runInSelectorThread(Object syncRoot, Supplier<Thread> threadSupplier, Supplier<Selector> selectorSupplier, int selectionKeyOps, Iterable<T> channels, BiPredicate<T, SelectionKey> predicate) {
        int selSelectTimeout = Math.min(15000, 15000);
        while (true) {
            Selector sel;
            boolean select = false;
            Object object = syncRoot;
            synchronized (object) {
                if (!Thread.currentThread().equals(threadSupplier.get())) {
                    break;
                }
                sel = selectorSupplier.get();
                if (sel == null || !sel.isOpen()) {
                    break;
                }
                Iterator<T> i = channels.iterator();
                while (i.hasNext()) {
                    SelectableChannel ch = (SelectableChannel)i.next();
                    boolean remove = false;
                    if (ch.isOpen()) {
                        SelectionKey sk = ch.keyFor(sel);
                        if (sk == null) {
                            try {
                                sk = ch.register(sel, selectionKeyOps);
                            }
                            catch (ClosedChannelException closedChannelException) {
                                // empty catch block
                            }
                        }
                        if (sk != null && sk.isValid() && (remove = predicate.test(ch, sk))) {
                            sk.cancel();
                        }
                    }
                    if (remove || !ch.isOpen()) {
                        i.remove();
                        continue;
                    }
                    select = true;
                }
                sel.selectedKeys().clear();
                if (!select) {
                    sel = null;
                    try {
                        syncRoot.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                sel.select(selSelectTimeout);
                continue;
            }
            catch (ClosedSelectorException cse) {
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleAccept(MuxingServerSocketChannel channel) throws IOException {
        List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
        synchronized (list) {
            if (acceptThread == null) {
                MuxingServerSocketChannel.maybeCloseAcceptSelector();
                try {
                    acceptSelector = channel.provider().openSelector();
                }
                catch (IOException ioe) {
                    acceptSelector = Selector.open();
                }
                acceptThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            MuxingServerSocketChannel.runInAcceptThread();
                        }
                        finally {
                            List list = muxingServerSocketChannels;
                            synchronized (list) {
                                if (Thread.currentThread().equals(acceptThread)) {
                                    acceptThread = null;
                                    MuxingServerSocketChannel.maybeCloseAcceptSelector();
                                }
                            }
                        }
                    }
                };
                acceptThread.setDaemon(true);
                acceptThread.setName(MuxingServerSocketChannel.class.getName() + ".acceptThread");
                acceptThread.start();
            } else {
                Selector sel = acceptSelector;
                if (sel != null) {
                    sel.wakeup();
                }
            }
        }
        channel.accept();
    }

    public MuxingServerSocketChannel(ServerSocketChannel delegate) throws IOException {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.configureBlocking(false);
        this.readSelector = this.provider().openSelector();
    }

    @Override
    public SocketChannel accept() throws IOException {
        SocketChannel ch = super.accept();
        this.closeAbandonedSocketChannels();
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMuxServerSocketChannel(MuxServerSocketChannel channel) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.muxServerSocketChannels.add(channel);
            this.syncRoot.notifyAll();
            this.scheduleRead(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAbandonedSocketChannels() {
        Object object = this.syncRoot;
        synchronized (object) {
            List<MuxServerSocketChannel> chs = this.muxServerSocketChannels;
            if (!chs.isEmpty()) {
                long now = System.currentTimeMillis();
                for (MuxServerSocketChannel ch : chs) {
                    ch.closeAbandonedSocketChannels(now);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuxServerSocketChannel createMuxServerSocketChannel(DatagramPacketFilter filter) {
        MuxServerSocketChannel channel;
        Objects.requireNonNull(filter, "filter");
        Object object = this.syncRoot;
        synchronized (object) {
            Iterator<MuxServerSocketChannel> i = this.muxServerSocketChannels.iterator();
            while (i.hasNext()) {
                MuxServerSocketChannel aChannel = i.next();
                if (aChannel.isOpen()) {
                    DatagramPacketFilter aFilter = aChannel.filter;
                    if (!filter.equals(aFilter) && !aFilter.equals(filter)) continue;
                    throw new IllegalArgumentException("filter");
                }
                i.remove();
            }
            channel = new MuxServerSocketChannel(this, filter);
            this.addMuxServerSocketChannel(channel);
        }
        this.muxServerSocketChannelAdded(channel);
        return channel;
    }

    private boolean filterAccept(DatagramPacket p, SocketChannel channel) {
        boolean b = false;
        Iterator<MuxServerSocketChannel> i = this.muxServerSocketChannels.iterator();
        while (i.hasNext()) {
            MuxServerSocketChannel muxChannel = i.next();
            if (muxChannel.isOpen()) {
                try {
                    b = muxChannel.filterAccept(p, channel);
                    if (!b) continue;
                    break;
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            i.remove();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SocketChannel implAccept(SocketChannel accepted) throws IOException {
        Object object = this.syncRoot;
        synchronized (object) {
            if (accepted != null && accepted.isOpen()) {
                accepted.configureBlocking(false);
                MuxServerSocketChannel oneAndOnly = null;
                for (MuxServerSocketChannel ch : this.muxServerSocketChannels) {
                    if (!ch.isOpen()) continue;
                    if (oneAndOnly == null) {
                        oneAndOnly = ch;
                        continue;
                    }
                    oneAndOnly = null;
                    break;
                }
                if (oneAndOnly != null && oneAndOnly.qAccept(accepted)) {
                    return null;
                }
                this.readQ.add(accepted);
                this.syncRoot.notifyAll();
                this.scheduleRead(accepted);
            }
        }
        return accepted;
    }

    @Override
    protected MuxingServerSocket implSocket(ServerSocket socket) throws IOException {
        return new MuxingServerSocket(socket, this);
    }

    protected int maybeRead(SocketChannel channel, ByteBuffer buf) {
        int read;
        if (buf.remaining() > 0) {
            try {
                read = channel.read(buf);
            }
            catch (IOException ioe) {
                read = 0;
            }
        } else {
            read = 0;
        }
        return read;
    }

    protected void muxServerSocketChannelAdded(MuxServerSocketChannel channel) {
    }

    protected void runInReadThread() {
        MuxingServerSocketChannel.runInSelectorThread(this.syncRoot, new Supplier<Thread>(){

            @Override
            public Thread get() {
                return MuxingServerSocketChannel.this.readThread;
            }
        }, new Supplier<Selector>(){

            @Override
            public Selector get() {
                return MuxingServerSocketChannel.this.readSelector;
            }
        }, 1, this.readQ, new BiPredicate<SocketChannel, SelectionKey>(){

            @Override
            public boolean test(SocketChannel ch, SelectionKey sk) {
                return MuxingServerSocketChannel.this.testRunInReadThreadPredicate(ch, sk);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleRead(SocketChannel channel) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.readThread == null) {
                this.readThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            MuxingServerSocketChannel.this.runInReadThread();
                        }
                        finally {
                            Object object = MuxingServerSocketChannel.this.syncRoot;
                            synchronized (object) {
                                if (Thread.currentThread().equals(MuxingServerSocketChannel.this.readThread)) {
                                    MuxingServerSocketChannel.this.readThread = null;
                                }
                            }
                        }
                    }
                };
                this.readThread.setDaemon(true);
                this.readThread.setName(MuxingServerSocketChannel.class.getName() + ".readThread");
                this.readThread.start();
            } else {
                Selector sel = this.readSelector;
                if (sel != null) {
                    sel.wakeup();
                }
            }
        }
    }

    private boolean testRunInReadThreadPredicate(SocketChannel ch, SelectionKey sk) {
        DatagramBuffer db = (DatagramBuffer)sk.attachment();
        if (db == null) {
            db = new DatagramBuffer(SOCKET_CHANNEL_READ_CAPACITY);
            sk.attach(db);
        }
        int read = this.maybeRead(ch, db.getByteBuffer());
        if (ch.isOpen()) {
            DatagramPacket p;
            int len;
            long now = System.currentTimeMillis();
            if (read > 0 || db.timestamp == -1L) {
                db.timestamp = now;
            }
            if ((len = (p = db.getDatagramPacket()).getLength()) > 0) {
                if (this.filterAccept(p, ch)) {
                    return true;
                }
                if (len >= SOCKET_CHANNEL_READ_CAPACITY) {
                    MuxingServerSocketChannel.closeNoExceptions(ch);
                    return false;
                }
            }
            if (read <= 0 && now - db.timestamp >= 15000L) {
                MuxingServerSocketChannel.closeNoExceptions(ch);
                return false;
            }
        }
        return false;
    }

    static {
        muxingServerSocketChannels = new LinkedList<MuxingServerSocketChannel>();
        SOCKET_CHANNEL_READ_CAPACITY = Math.max(GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length, Math.max(HttpDemuxFilter.REQUEST_METHOD_MAX_LENGTH + 1, 11));
        try {
            ANY_LOCAL_ADDRESS = InetAddress.getByName("::");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

