/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.util.test;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColRules;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitChangeType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestUtils;
import net.sf.freecol.util.test.MockPseudoRandom;

public class FreeColTestCase
extends TestCase {
    public static String[] STANDARD_MAPS = new String[]{"data/maps/M_Africa_Gilolat.fsm", "data/maps/S_AustraliaOceania_Gilolat.fsm", "data/maps/L_America_JsTheDude.fsm", "data/maps/S_Caribbean_Phil.fsm"};
    private static java.util.Map<String, Specification> specifications = new HashMap<String, Specification>();
    static Game game;
    static boolean updateLocale;

    protected void setUp() throws Exception {
        FreeColRules.loadRules();
        if (updateLocale) {
            updateLocale = false;
            Messages.loadMessageBundle(Locale.US);
        }
    }

    protected void tearDown() throws Exception {
        game = null;
    }

    public static Game getGame() {
        if (game == null) {
            game = FreeColTestCase.getStandardGame();
        }
        return game;
    }

    public static void setGame(Game newGame) {
        game = newGame;
    }

    public static Specification spec() {
        return FreeColTestCase.getSpecification("freecol");
    }

    public static Specification spec(String name) {
        return FreeColTestCase.getSpecification(name);
    }

    public static Specification getSpecification(String name) {
        Specification result = specifications.get(name);
        if (result == null) {
            FreeColRules.loadRules();
            try {
                FreeColModFile rules = FreeColRules.getFreeColRulesFile(name);
                result = FreeCol.loadSpecification(rules, null, "model.difficulty.medium");
                specifications.put(name, result);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return result;
    }

    public static Game getStandardGame() {
        return FreeColTestCase.getStandardGame("freecol");
    }

    public static Game getStandardGame(String specName) {
        Specification specification = FreeColTestCase.spec(specName);
        game = new ServerGame(specification);
        NationOptions nationOptions = new NationOptions(specification);
        for (Nation nation : specification.getEuropeanNations()) {
            nationOptions.setNationState(nation, NationOptions.NationState.AVAILABLE);
        }
        game.setNationOptions(nationOptions);
        specification.applyDifficultyLevel("model.difficulty.medium");
        for (Nation n : specification.getNations()) {
            if (n.isUnknownEnemy()) continue;
            ServerPlayer p = new ServerPlayer(game, false, n);
            boolean ai = !n.getType().isEuropean() || n.getType().isREF();
            p.setAI(ai);
            if (!ai && !game.canAddNewPlayer()) continue;
            game.addPlayer(p);
        }
        return game;
    }

    public static Map getTestMap() {
        MapBuilder builder = new MapBuilder(FreeColTestCase.getGame());
        return builder.build();
    }

    public static Map getTestMap(TileType tileType) {
        MapBuilder builder = new MapBuilder(FreeColTestCase.getGame());
        builder.setBaseTileType(tileType);
        return builder.build();
    }

    public static Map getTestMap(TileType tileType, boolean explored) {
        MapBuilder builder = new MapBuilder(FreeColTestCase.getGame());
        builder.setBaseTileType(tileType).setExploredByAll(explored);
        return builder.build();
    }

    public static Map getTestMap(boolean explored) {
        MapBuilder builder = new MapBuilder(FreeColTestCase.getGame());
        builder.setExploredByAll(explored);
        return builder.build();
    }

    public static Map getCoastTestMap(TileType landTileType) {
        return FreeColTestCase.getCoastTestMap(landTileType, false);
    }

    public static Map getCoastTestMap(TileType landTileType, boolean explored) {
        int y;
        int totalWidth = 20;
        int totalHeight = 15;
        TileType oceanType = FreeColTestCase.spec().getTileType("model.tile.ocean");
        MapBuilder builder = new MapBuilder(FreeColTestCase.getGame());
        builder.setDimensions(totalWidth, totalHeight).setBaseTileType(oceanType);
        if (explored) {
            builder.setExploredByAll(true);
        }
        int landWidth = (int)Math.floor(totalWidth / 2);
        for (int x = 0; x < landWidth; ++x) {
            for (y = 0; y < totalHeight; ++y) {
                builder.setTileType(x, y, landTileType);
            }
        }
        TileType highSeasType = FreeColTestCase.spec().getTileType("model.tile.highSeas");
        for (y = 0; y < totalHeight; ++y) {
            builder.setTileType(totalWidth - 1, y, highSeasType);
        }
        return builder.build();
    }

    public Colony getStandardColony() {
        return this.getStandardColony(1, 5, 8);
    }

    public Colony getStandardColony(int numberOfSettlers) {
        return this.getStandardColony(numberOfSettlers, 5, 8);
    }

    public Colony getStandardColony(int numberOfSettlers, int tileX, int tileY) {
        Game game = FreeColTestCase.getGame();
        Map map = game.getMap();
        Tile tile = map.getTile(tileX, tileY);
        FreeColTestUtils.ColonyBuilder builder = FreeColTestUtils.getColonyBuilder();
        builder.colonyTile(tile).initialColonists(numberOfSettlers);
        Colony ret = builder.build();
        ((ServerPlayer)ret.getOwner()).exploreForSettlement(ret);
        return ret;
    }

    public boolean clearWorkLocation(WorkLocation wl) {
        for (Unit u : wl.getUnitList()) {
            WorkLocation w = CollectionUtils.find(wl.getColony().getCurrentWorkLocations(), w2 -> w2 != wl && w2.canAdd(u));
            if (w == null) continue;
            u.setLocation(w);
        }
        return wl.isEmpty();
    }

    public void setProductionBonus(Colony colony, int value) {
        try {
            Field productionBonus = Colony.class.getDeclaredField("productionBonus");
            productionBonus.setAccessible(true);
            productionBonus.setInt(colony, value);
            colony.invalidateCache();
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            FreeColTestCase.fail((String)ex.toString());
        }
    }

    public void nonServerBuildColony(Unit builder, Colony colony) {
        colony.placeSettlement(true);
        colony.getOwner().invalidateCanSeeTiles();
        this.nonServerJoinColony(builder, colony);
    }

    public void nonServerJoinColony(Unit builder, Colony colony) {
        builder.setLocation(colony);
        builder.setMovesLeft(0);
    }

    public List<CombatModel.CombatEffectType> fakeAttackResult(CombatModel.CombatEffectType result, FreeColGameObject attacker, FreeColGameObject defender) {
        List<CombatModel.CombatEffectType> crs;
        double delta = 0.02;
        CombatModel combatModel = FreeColTestCase.getGame().getCombatModel();
        CombatModel.CombatOdds combatOdds = combatModel.calculateCombatOdds(attacker, defender);
        double p = combatOdds.win;
        MockPseudoRandom mr = new MockPseudoRandom();
        ArrayList<Integer> number = new ArrayList<Integer>();
        number.add(-1);
        do {
            double d = result == CombatModel.CombatEffectType.WIN ? -0.02 : 0.02;
            if ((p += d) < 0.0 || p >= 1.0) {
                throw new IllegalStateException("f out of range: " + Double.toString(p));
            }
            number.set(0, (int)(2.147483647E9 * p));
            mr.setNextNumbers(number, true);
        } while ((crs = combatModel.generateAttackResult(mr, attacker, defender).getEffects()).get(0) != result);
        return crs;
    }

    public void checkCombat(String name, List<CombatModel.CombatEffectType> crs, CombatModel.CombatEffectType ... results) {
        int i = 0;
        for (CombatModel.CombatEffectType cr : results) {
            CombatModel.CombatEffectType expect;
            CombatModel.CombatEffectType combatEffectType = expect = i < crs.size() ? crs.get(i) : null;
            if (expect != cr) break;
            ++i;
        }
        if (i == results.length) {
            if (crs.size() == i) {
                return;
            }
            ++i;
        }
        String err = name + ", failed at " + i + ":";
        for (CombatModel.CombatEffectType cr : results) {
            err = err + " " + cr;
        }
        err = err + " !=";
        for (CombatModel.CombatEffectType cr : crs) {
            err = err + " " + cr;
        }
        FreeColTestCase.fail((String)err);
    }

    public void checkGoods(String err, List<AbstractGoods> goods, AbstractGoods ... results) {
        ArrayList<AbstractGoods> check = new ArrayList<AbstractGoods>(goods);
        for (AbstractGoods ag : results) {
            FreeColTestCase.assertTrue((String)(err + " requires " + ag), (boolean)check.contains(ag));
            check.remove(ag);
        }
        FreeColTestCase.assertTrue((String)(err + " requires more goods"), (boolean)check.isEmpty());
    }

    public void addUnitTypeChange(String type, UnitType from, UnitType to, int probability, int turns) {
        UnitTypeChange utc = new UnitTypeChange(type + "." + from.getSuffix() + "-" + to.getSuffix(), FreeColTestCase.spec());
        utc.from = from;
        utc.to = to;
        utc.probability = probability;
        utc.turns = turns;
        UnitChangeType uct = FreeColTestCase.spec().getUnitChangeType(type);
        if (uct == null) {
            uct = new UnitChangeType(type, FreeColTestCase.spec());
            FreeColTestCase.spec().getUnitChangeTypeList().add(uct);
        }
        uct.addUnitTypeChange(utc);
    }

    public ServerPlayer getServerPlayer(Game game, String id) {
        return (ServerPlayer)game.getPlayerByNationId(id);
    }

    static {
        updateLocale = true;
    }

    public static class IndianSettlementBuilder {
        private static final String defaultIndianPlayer = "model.nation.tupi";
        private final Game game;
        private Player indianPlayer;
        private String skillTaught;
        private int initialBravesInCamp;
        private Tile settlementTile;
        private static int settlementNumber = 1;
        private boolean isCapital;
        private Unit residentMissionary;

        public IndianSettlementBuilder(Game game) {
            this.game = game;
            this.setStartingParams();
        }

        private void setStartingParams() {
            this.indianPlayer = null;
            this.initialBravesInCamp = 1;
            this.settlementTile = null;
            this.skillTaught = "model.unit.masterCottonPlanter";
            this.isCapital = false;
            this.residentMissionary = null;
        }

        public IndianSettlementBuilder player(Player player) {
            if (player == null || CollectionUtils.none(this.game.getPlayers(CollectionUtils.matchKey(player)))) {
                throw new RuntimeException("Indian player not in game");
            }
            this.indianPlayer = player;
            return this;
        }

        public IndianSettlementBuilder initialBravesInCamp(int nBraves) {
            if (nBraves <= 0) {
                throw new RuntimeException("Number of braves must be positive");
            }
            this.initialBravesInCamp = nBraves;
            return this;
        }

        public IndianSettlementBuilder settlementTile(Tile tile) {
            Tile tileOnMap = this.game.getMap().getTile(tile.getX(), tile.getY());
            if (tile != tileOnMap) {
                throw new RuntimeException("Given tile not on map");
            }
            this.settlementTile = tile;
            return this;
        }

        public IndianSettlementBuilder capital(boolean isCapital) {
            this.isCapital = isCapital;
            return this;
        }

        public IndianSettlementBuilder missionary(Unit missionary) {
            this.residentMissionary = missionary;
            return this;
        }

        public IndianSettlementBuilder skillToTeach(String skill) {
            this.skillTaught = skill;
            return this;
        }

        private String getSimpleName(Player player, boolean isCapital) {
            return isCapital ? player.getName() + "-capital" : "Settlement-" + settlementNumber++;
        }

        public IndianSettlement build() {
            UnitType skillToTeach = null;
            if (this.skillTaught != null) {
                skillToTeach = FreeColTestCase.spec().getUnitType(this.skillTaught);
            }
            if (this.indianPlayer == null) {
                this.indianPlayer = this.game.getPlayerByNationId(defaultIndianPlayer);
                if (this.indianPlayer == null) {
                    throw new RuntimeException("Default Indian player model.nation.tupi not in game");
                }
            }
            UnitType indianBraveType = FreeColTestCase.spec().getDefaultUnitType(this.indianPlayer);
            if (this.settlementTile == null) {
                this.settlementTile = this.game.getMap().getTile(5, 8);
                if (this.settlementTile == null) {
                    throw new RuntimeException("Default tile not in game");
                }
            }
            ServerIndianSettlement camp = new ServerIndianSettlement(this.game, this.indianPlayer, this.getSimpleName(this.indianPlayer, this.isCapital), this.settlementTile, this.isCapital, skillToTeach, this.residentMissionary);
            this.indianPlayer.addSettlement(camp);
            for (int i = 0; i < this.initialBravesInCamp; ++i) {
                ServerUnit brave = new ServerUnit(this.game, camp, this.indianPlayer, indianBraveType);
                if (brave == null) {
                    throw new RuntimeException("Null brave");
                }
                camp.addOwnedUnit(brave);
            }
            camp.placeSettlement(true);
            return camp;
        }

        public IndianSettlementBuilder reset() {
            this.setStartingParams();
            return this;
        }
    }

    public static class MapBuilder {
        private final Game game;
        private TileType[][] tileTypes = null;
        private int width;
        private int height;
        private TileType baseTile;
        private boolean exploredByAll;
        private boolean initiated;

        public MapBuilder(Game game) {
            this.game = game;
            this.setStartingParams();
        }

        private void setStartingParams() {
            this.width = 20;
            this.height = 15;
            this.baseTile = FreeColTestCase.spec().getTileType("model.tile.plains");
            this.exploredByAll = false;
            this.initiated = false;
            if (this.tileTypes == null) {
                this.tileTypes = new TileType[this.width][this.height];
            }
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.tileTypes[x][y] = null;
                }
            }
        }

        public MapBuilder setBaseTileType(TileType baseType) {
            if (baseType == null) {
                throw new NullPointerException("Base tile type cannot be null");
            }
            this.baseTile = baseType;
            return this;
        }

        public MapBuilder setDimensions(int width, int heigth) {
            if (width <= 0) {
                throw new RuntimeException("Width must be positive");
            }
            if (heigth <= 0) {
                throw new RuntimeException("Heigth must be positive");
            }
            if (this.initiated) {
                throw new IllegalStateException("Cannot resize map after setting a tile");
            }
            this.width = width;
            this.height = heigth;
            this.tileTypes = new TileType[width][this.height];
            return this;
        }

        public MapBuilder setExploredByAll(boolean exploredByAll) {
            this.exploredByAll = exploredByAll;
            return this;
        }

        public MapBuilder setTileType(int x, int y, TileType tileType) {
            if (x < 0 || y < 0) {
                throw new RuntimeException("Coordenates cannot be negative");
            }
            if (x >= this.width || y >= this.height) {
                throw new RuntimeException("Coordenate out of bounds");
            }
            if (tileType == null) {
                throw new NullPointerException("Tile type cannot be null");
            }
            this.tileTypes[x][y] = tileType;
            this.initiated = true;
            return this;
        }

        private void completeWorkingGrid() {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (this.tileTypes[x][y] != null) continue;
                    this.tileTypes[x][y] = this.baseTile;
                }
            }
            this.initiated = true;
        }

        public Map build() {
            this.completeWorkingGrid();
            Map map = new Map(this.game, this.width, this.height);
            Region region = new Region(this.game);
            map.populateTiles((x, y) -> {
                TileType tileType = this.tileTypes[x][y];
                Tile t = new Tile(this.game, tileType, (int)x, (int)y);
                t.setRegion(region);
                return t;
            });
            map.resetContiguity();
            map.resetHighSeasCount();
            if (this.exploredByAll) {
                map.forEachTile(t -> {
                    for (Player p : this.game.getLiveEuropeanPlayerList(new Player[0])) {
                        t.setExplored(p, true);
                    }
                });
            }
            return map;
        }

        public MapBuilder reset() {
            this.setStartingParams();
            return this;
        }
    }
}

