/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.time.Instant;
import java.util.function.Supplier;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.internal.CacheCleanupBuildOperationType;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;

class DefaultCacheCleanupStrategy
implements CacheCleanupStrategy {
    private final CleanupAction cleanupAction;
    private final Supplier<CleanupFrequency> cleanupFrequency;
    private final BuildOperationRunner buildOperationRunner;

    DefaultCacheCleanupStrategy(CleanupAction cleanupAction, Supplier<CleanupFrequency> cleanupFrequency, BuildOperationRunner buildOperationRunner) {
        this.cleanupAction = cleanupAction;
        this.cleanupFrequency = cleanupFrequency;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public void clean(final CleanableStore cleanableStore, final Instant lastCleanupTime) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                DefaultCleanupProgressMonitor progressMonitor = new DefaultCleanupProgressMonitor(context);
                DefaultCacheCleanupStrategy.this.cleanupAction.clean(cleanableStore, progressMonitor);
                context.setResult((Object)new CacheCleanupResult(progressMonitor.getDeleted(), lastCleanupTime));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Clean up " + cleanableStore.getDisplayName())).details((Object)new CacheCleanupDetails(cleanableStore.getBaseDir()));
            }
        });
    }

    @Override
    public CleanupFrequency getCleanupFrequency() {
        return this.cleanupFrequency.get();
    }

    private static class CacheCleanupResult
    implements CacheCleanupBuildOperationType.Result {
        private final long deletedEntriesCount;
        private final Instant previousCleanupTime;

        private CacheCleanupResult(long deletedEntriesCount, Instant previousCleanupTime) {
            this.deletedEntriesCount = deletedEntriesCount;
            this.previousCleanupTime = previousCleanupTime;
        }

        @Override
        public long getDeletedEntriesCount() {
            return this.deletedEntriesCount;
        }

        @Override
        public Instant getPreviousCleanupTime() {
            return this.previousCleanupTime;
        }
    }

    private static class CacheCleanupDetails
    implements CacheCleanupBuildOperationType.Details {
        private final File cacheLocation;

        public CacheCleanupDetails(File cacheLocation) {
            this.cacheLocation = cacheLocation;
        }

        @Override
        public File getCacheLocation() {
            return this.cacheLocation;
        }
    }
}

