/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

public final class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EnvironmentUtil.class);
    private static final AtomicReference<CompletableDeferred<Map<String, String>>> ourEnvGetter = new AtomicReference();
    private static final Pattern pattern = Pattern.compile("\\$(.*?)\\$");

    private EnvironmentUtil() {
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map map;
        CompletableDeferred<Map<String, String>> getter2 = ourEnvGetter.get();
        if (getter2 == null && !ourEnvGetter.compareAndSet(null, getter2 = CompletableDeferredKt.CompletableDeferred(EnvironmentUtil.getSystemEnv()))) {
            getter2 = ourEnvGetter.get();
        }
        try {
            map = (Map)FutureKt.asCompletableFuture((Deferred)getter2).join();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
        if (map == null) {
            EnvironmentUtil.$$$reportNull$$$0(0);
        }
        return map;
    }

    @NotNull
    private static Map<String, String> getSystemEnv() {
        if (SystemInfoRt.isWindows) {
            Map<String, String> map = Collections.unmodifiableMap(CollectionFactory.createCaseInsensitiveStringMap(System.getenv()));
            if (map == null) {
                EnvironmentUtil.$$$reportNull$$$0(2);
            }
            return map;
        }
        if (SystemInfoRt.isXWindow) {
            Map<String, String> env = System.getenv();
            if (env.containsKey("DESKTOP_STARTUP_ID")) {
                env = new HashMap<String, String>(env);
                env.remove("DESKTOP_STARTUP_ID");
                env = Collections.unmodifiableMap(env);
            }
            Map<String, String> map = env;
            if (map == null) {
                EnvironmentUtil.$$$reportNull$$$0(3);
            }
            return map;
        }
        Map<String, String> map = System.getenv();
        if (map == null) {
            EnvironmentUtil.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    public static String getValue(@NotNull String name2) {
        if (name2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(5);
        }
        return EnvironmentUtil.getEnvironmentMap().get(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentJob";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shell";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentMap";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemEnv";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildShellProcessCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnv";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocaleEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildShellProcessCommand";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "waitAndTerminateAfter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetVar";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnv";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCharsetVarDefined";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inlineParentOccurrences";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "testParser";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

