/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp8;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.cc.vp8.VP8Frame;
import org.json.simple.JSONObject;

class VP8QualityFilter {
    private final Logger logger;
    private static final Duration MIN_KEY_FRAME_WAIT = Duration.ofMillis(300L);
    private static final int SUSPENDED_ENCODING_ID = -1;
    @Nullable
    private Instant mostRecentKeyframeGroupArrivalTime = null;
    private boolean needsKeyframe = false;
    private int internalEncodingIdTarget = -1;
    private int currentEncodingId = -1;

    public VP8QualityFilter(Logger parentLogger) {
        this.logger = parentLogger.createChildLogger(VP8QualityFilter.class.getName());
    }

    boolean needsKeyframe() {
        return this.needsKeyframe;
    }

    synchronized boolean acceptFrame(@NotNull VP8Frame frame, int incomingEncoding, int externalTargetIndex, Instant receivedTime) {
        int externalTemporalLayerIdTarget = RtpLayerDesc.getTidFromIndex(externalTargetIndex);
        int externalEncodingIdTarget = RtpLayerDesc.getEidFromIndex(externalTargetIndex);
        if (externalEncodingIdTarget != this.internalEncodingIdTarget) {
            this.internalEncodingIdTarget = externalEncodingIdTarget;
            if (externalEncodingIdTarget > -1) {
                this.needsKeyframe = true;
            }
        }
        if (externalEncodingIdTarget < 0 || externalTemporalLayerIdTarget < 0) {
            this.currentEncodingId = -1;
            return false;
        }
        int temporalLayerIdOfFrame = frame.getTemporalLayer();
        if (temporalLayerIdOfFrame < 0) {
            temporalLayerIdOfFrame = 0;
        }
        if (frame.isKeyframe()) {
            this.logger.debug(() -> "Quality filter got keyframe for stream " + frame.getSsrc());
            return this.acceptKeyframe(incomingEncoding, receivedTime);
        }
        if (this.currentEncodingId > -1) {
            if (this.isOutOfSwitchingPhase(receivedTime) && this.isPossibleToSwitch(incomingEncoding)) {
                this.needsKeyframe = true;
            }
            if (incomingEncoding != this.currentEncodingId) {
                return false;
            }
            if (this.currentEncodingId > externalEncodingIdTarget) {
                return temporalLayerIdOfFrame < 1;
            }
            if (this.currentEncodingId < externalEncodingIdTarget) {
                return true;
            }
            return temporalLayerIdOfFrame <= externalTemporalLayerIdTarget;
        }
        return false;
    }

    private synchronized boolean isOutOfSwitchingPhase(@Nullable Instant receivedTime) {
        if (receivedTime == null) {
            return false;
        }
        if (this.mostRecentKeyframeGroupArrivalTime == null) {
            return true;
        }
        Duration delta = Duration.between(this.mostRecentKeyframeGroupArrivalTime, receivedTime);
        return delta.compareTo(MIN_KEY_FRAME_WAIT) > 0;
    }

    private synchronized boolean isPossibleToSwitch(int encodingId) {
        if (encodingId == -1) {
            return false;
        }
        if (encodingId > this.currentEncodingId && this.currentEncodingId < this.internalEncodingIdTarget) {
            return true;
        }
        return encodingId < this.currentEncodingId && this.currentEncodingId > this.internalEncodingIdTarget;
    }

    private synchronized boolean acceptKeyframe(int encodingIdOfKeyframe, @Nullable Instant receivedTime) {
        if (encodingIdOfKeyframe < 0) {
            this.logger.error("unable to get layer id from keyframe");
            return false;
        }
        this.logger.debug(() -> "Received a keyframe of encoding: " + encodingIdOfKeyframe);
        this.needsKeyframe = false;
        if (this.isOutOfSwitchingPhase(receivedTime)) {
            this.mostRecentKeyframeGroupArrivalTime = receivedTime;
            this.logger.debug(() -> "First keyframe in this kf group currentEncodingId: " + encodingIdOfKeyframe + ". Target is " + this.internalEncodingIdTarget);
            if (encodingIdOfKeyframe <= this.internalEncodingIdTarget) {
                this.currentEncodingId = encodingIdOfKeyframe;
                return true;
            }
            return false;
        }
        if (this.currentEncodingId <= encodingIdOfKeyframe && encodingIdOfKeyframe <= this.internalEncodingIdTarget) {
            this.currentEncodingId = encodingIdOfKeyframe;
            this.logger.debug(() -> "Upscaling to encoding " + encodingIdOfKeyframe + ". The target is " + this.internalEncodingIdTarget);
            return true;
        }
        if (encodingIdOfKeyframe <= this.internalEncodingIdTarget && this.internalEncodingIdTarget < this.currentEncodingId) {
            this.currentEncodingId = encodingIdOfKeyframe;
            this.logger.debug(() -> " Downscaling to encoding " + encodingIdOfKeyframe + ". The target is + " + this.internalEncodingIdTarget);
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        debugState.put("mostRecentKeyframeGroupArrivalTimeMs", this.mostRecentKeyframeGroupArrivalTime != null ? this.mostRecentKeyframeGroupArrivalTime.toEpochMilli() : -1L);
        debugState.put("needsKeyframe", this.needsKeyframe);
        debugState.put("internalEncodingIdTarget", this.internalEncodingIdTarget);
        debugState.put("currentEncodingId", this.currentEncodingId);
        return debugState;
    }
}

