/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.plaf.LAFUtilities;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.ImageUtils;

public class FreeColCheckBoxUI
extends MetalCheckBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new FreeColCheckBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        LAFUtilities.setProperties(g, c);
        super.paint(g, c);
    }

    public static Icon createCheckBoxIcon() {
        return new CheckBoxIcon();
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getWidgetSize() {
            return FontLibrary.getMainFont().getSize() * 3 / 2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            int mainFontSize = FontLibrary.getMainFont().getSize();
            ButtonModel model = ((JCheckBox)c).getModel();
            int widgetSize = this.getWidgetSize();
            ImageUtils.fillTexture((Graphics2D)g, ImageLibrary.getButtonBackground(), x, y, widgetSize, widgetSize);
            if (!model.isEnabled()) {
                g.setColor(MetalLookAndFeel.getControlDisabled());
                g.fillRect(x, y, widgetSize - 1, widgetSize - 1);
            } else if (model.isPressed() && model.isArmed()) {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(x, y, widgetSize - 1, widgetSize - 1);
            }
            if (model.isEnabled()) {
                FreeColImageBorder border = FreeColImageBorder.simpleButtonBorder;
                border.paintBorder(c, g, x, y, this.getWidgetSize(), this.getWidgetSize());
            }
            if (c.hasFocus()) {
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawRect(x, y, widgetSize - 1, widgetSize - 1);
            }
            if (model.isSelected()) {
                BufferedImage checkmarkImage = ResourceManager.getImage("image.ui.checkmark", new Dimension(mainFontSize, mainFontSize), false);
                Composite origComposite = g2d.getComposite();
                if (!model.isEnabled()) {
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                g.drawImage(checkmarkImage, x + (widgetSize - checkmarkImage.getWidth()) / 2, y + (widgetSize - checkmarkImage.getHeight()) / 2, null);
                g2d.setComposite(origComposite);
            }
        }

        @Override
        public int getIconWidth() {
            return this.getWidgetSize();
        }

        @Override
        public int getIconHeight() {
            return this.getWidgetSize();
        }
    }
}

