/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import jakarta.annotation.Priority;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@Priority(value=3200)
public class ProfileConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -6305289277993917313L;
    private final List<String> profiles;

    public ProfileConfigSourceInterceptor(String profile) {
        this(profile != null ? ProfileConfigSourceInterceptor.convertProfile(profile) : new ArrayList<String>());
    }

    public ProfileConfigSourceInterceptor(List<String> profiles) {
        ArrayList<String> reverseProfiles = new ArrayList<String>(profiles);
        Collections.reverse(reverseProfiles);
        this.profiles = reverseProfiles;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String normalizeName;
        ConfigValue profileValue;
        if (this.profiles.size() > 0 && (profileValue = this.getProfileValue(context, normalizeName = ProfileConfigSourceInterceptor.activeName(name, this.profiles))) != null) {
            ConfigValue originalValue = context.proceed(normalizeName);
            if (originalValue != null && ConfigValue.CONFIG_SOURCE_COMPARATOR.compare(originalValue, profileValue) > 0) {
                return originalValue;
            }
            return profileValue.withName(normalizeName);
        }
        return context.proceed(name);
    }

    public ConfigValue getProfileValue(ConfigSourceInterceptorContext context, String normalizeName) {
        for (String profile : this.profiles) {
            ConfigValue profileValue = context.proceed("%" + profile + "." + normalizeName);
            if (profileValue == null) continue;
            return profileValue.withProfile(profile);
        }
        return null;
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator<String> namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            names.add(ProfileConfigSourceInterceptor.activeName(namesIterator.next(), this.profiles));
        }
        return names.iterator();
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public static String activeName(String name, List<String> profiles) {
        block7: {
            if (name.isEmpty() || name.charAt(0) != '%') break block7;
            int profilesEnd = name.indexOf(46, 1);
            int multipleSplit = -1;
            for (int i = 1; i < profilesEnd; ++i) {
                if (name.charAt(i) != ',') continue;
                multipleSplit = i;
                break;
            }
            if (multipleSplit == -1) {
                for (String profile : profiles) {
                    if (profilesEnd != profile.length() + 1 || !name.regionMatches(1, profile, 0, profile.length())) continue;
                    return name.substring(profilesEnd + 1);
                }
            } else {
                int nextSplit = multipleSplit;
                int toOffset = 1;
                while (nextSplit != -1) {
                    for (String profile : profiles) {
                        char expectedEnd = name.charAt(toOffset + profile.length());
                        if (expectedEnd != '.' && expectedEnd != ',' || !name.regionMatches(toOffset, profile, 0, profile.length())) continue;
                        return name.substring(profilesEnd + 1);
                    }
                    toOffset = nextSplit + 1;
                    nextSplit = -1;
                    for (int i = toOffset; i < profilesEnd; ++i) {
                        if (name.charAt(i) != ',') continue;
                        nextSplit = i;
                        break;
                    }
                    if (toOffset >= profilesEnd || nextSplit != -1) continue;
                    nextSplit = profilesEnd;
                }
            }
        }
        return name;
    }

    public static List<String> convertProfile(String profile) {
        List<String> profiles = (List<String>)Converters.newCollectionConverter(Converters.newTrimmingConverter(Converters.STRING_CONVERTER), ArrayList::new).convert(profile);
        return profiles != null ? profiles : Collections.emptyList();
    }
}

