/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.BaseConditionModuleHandler;
import org.openhab.core.events.Event;
import org.openhab.core.events.TopicGlobEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GenericEventConditionHandler
extends BaseConditionModuleHandler {
    public static final String MODULETYPE_ID = "core.GenericEventCondition";
    public static final String CFG_TOPIC = "topic";
    public static final String CFG_TYPES = "types";
    public static final String CFG_SOURCE = "source";
    public static final String CFG_PAYLOAD = "payload";
    public final Logger logger = LoggerFactory.getLogger(GenericEventConditionHandler.class);
    private final String source;
    private final @Nullable TopicGlobEventFilter topicFilter;
    private final Set<String> types;
    private final @Nullable Pattern payloadPattern;

    public GenericEventConditionHandler(Condition module) {
        super(module);
        this.source = (String)module.getConfiguration().get(CFG_SOURCE);
        String topic = (String)module.getConfiguration().get(CFG_TOPIC);
        this.topicFilter = !topic.isBlank() ? new TopicGlobEventFilter(topic) : null;
        this.types = module.getConfiguration().get(CFG_TYPES) != null ? Set.of(((String)module.getConfiguration().get(CFG_TYPES)).split(",")) : Set.of();
        String payload = (String)module.getConfiguration().get(CFG_PAYLOAD);
        this.payloadPattern = !payload.isBlank() ? Pattern.compile(payload) : null;
    }

    @Override
    public boolean isSatisfied(Map<String, Object> inputs) {
        Event event;
        Event event2 = event = inputs.get("event") instanceof Event ? (Event)inputs.get("event") : null;
        if (event == null) {
            return false;
        }
        if (!this.types.isEmpty() && !this.types.contains(event.getType())) {
            return false;
        }
        TopicGlobEventFilter localTopicFilter = this.topicFilter;
        if (localTopicFilter != null && !localTopicFilter.apply(event)) {
            return false;
        }
        if (!this.source.isEmpty() && !this.source.equals(event.getSource())) {
            return false;
        }
        Pattern localPayloadPattern = this.payloadPattern;
        return localPayloadPattern == null || localPayloadPattern.matcher(event.getPayload()).find();
    }
}

