/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.SwitchElement;
import com.android.tools.smali.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import com.android.tools.smali.dexlib2.immutable.instruction.ImmutableInstruction;
import com.android.tools.smali.dexlib2.immutable.instruction.ImmutableSwitchElement;
import com.android.tools.smali.dexlib2.util.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ImmutablePackedSwitchPayload
extends ImmutableInstruction
implements PackedSwitchPayload {
    public static final Opcode OPCODE = Opcode.PACKED_SWITCH_PAYLOAD;
    protected final ImmutableList<? extends ImmutableSwitchElement> switchElements;

    public ImmutablePackedSwitchPayload(List<? extends SwitchElement> switchElements) {
        super(OPCODE);
        this.switchElements = Preconditions.checkSequentialOrderedKeys(ImmutableSwitchElement.immutableListOf(switchElements));
    }

    public static ImmutablePackedSwitchPayload of(PackedSwitchPayload instruction) {
        if (instruction instanceof ImmutablePackedSwitchPayload) {
            return (ImmutablePackedSwitchPayload)instruction;
        }
        return new ImmutablePackedSwitchPayload(instruction.getSwitchElements());
    }

    @Override
    public List<? extends SwitchElement> getSwitchElements() {
        return this.switchElements;
    }

    @Override
    public int getCodeUnits() {
        return 4 + this.switchElements.size() * 2;
    }

    @Override
    public Format getFormat() {
        return ImmutablePackedSwitchPayload.OPCODE.format;
    }
}

