/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;

public class CreateEnergonCubeAction
extends AbstractArchitectAction {
    private ImageIcon bg;
    private Icon[] frames;
    private Timer timer;

    public CreateEnergonCubeAction(ArchitectSwingSession session, PlayPen pp) {
        super(session, pp, "New Energon Cube...", "Create a new Energon Cube", (Icon)new ImageIcon(CreateEnergonCubeAction.class.getResource("energonCubeAdd.png")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.bg == null) {
            this.bg = new ImageIcon(this.getClass().getResource("energonCube_background.jpg"));
        }
        if (this.frames == null) {
            this.frames = new Icon[15];
            for (int i = 0; i < this.frames.length; ++i) {
                this.frames[i] = new ImageIcon(this.getClass().getResource("energonCube_anim_" + (i + 1) + ".png"));
            }
        }
        JLabel energon = new JLabel(this.bg);
        this.timer = new Timer(200, new FrameAdvancer(energon));
        JDialog d = SPSUtils.makeOwnedDialog((Component)this.getPlaypen(), (String)"New Energon Cube");
        d.setContentPane(energon);
        d.setModal(true);
        d.pack();
        this.timer.start();
        d.setVisible(true);
    }

    private static class CompositeIcon
    implements Icon {
        private final Icon bg;
        private final Icon overlay;

        CompositeIcon(Icon bg, Icon overlay) {
            this.bg = bg;
            this.overlay = overlay;
        }

        @Override
        public int getIconHeight() {
            return this.bg.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.bg.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.bg.paintIcon(c, g, x, y);
            this.overlay.paintIcon(c, g, x, y);
        }
    }

    private final class FrameAdvancer
    implements ActionListener {
        private final JLabel energon;
        int frame;

        private FrameAdvancer(JLabel energon) {
            this.energon = energon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.frame >= CreateEnergonCubeAction.this.frames.length) {
                CreateEnergonCubeAction.this.timer.stop();
                return;
            }
            this.energon.setIcon(new CompositeIcon(CreateEnergonCubeAction.this.bg, CreateEnergonCubeAction.this.frames[this.frame++]));
        }
    }
}

