/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.VersionSpecificCacheCleanupAction;
import org.gradle.cache.internal.WrapperDistributionCleanupAction;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.cache.MonitoredCleanupAction;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public class GradleUserHomeCleanupService
implements Stoppable {
    private final Deleter deleter;
    private final GradleUserHomeDirProvider userHomeDirProvider;
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    private final UsedGradleVersions usedGradleVersions;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final CacheConfigurationsInternal cacheConfigurations;
    private boolean alreadyCleaned;

    public GradleUserHomeCleanupService(Deleter deleter, GradleUserHomeDirProvider userHomeDirProvider, GlobalScopedCacheBuilderFactory cacheBuilderFactory, UsedGradleVersions usedGradleVersions, ProgressLoggerFactory progressLoggerFactory, CacheConfigurationsInternal cacheConfigurations) {
        this.deleter = deleter;
        this.userHomeDirProvider = userHomeDirProvider;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.usedGradleVersions = usedGradleVersions;
        this.progressLoggerFactory = progressLoggerFactory;
        this.cacheConfigurations = cacheConfigurations;
    }

    public void cleanup() {
        File cacheBaseDir = this.cacheBuilderFactory.getRootDir();
        boolean wasCleanedUp = this.execute(new VersionSpecificCacheCleanupAction(cacheBaseDir, this.cacheConfigurations.getReleasedWrappers().getRemoveUnusedEntriesOlderThanAsSupplier(), this.cacheConfigurations.getSnapshotWrappers().getRemoveUnusedEntriesOlderThanAsSupplier(), this.deleter, (CleanupFrequency)this.cacheConfigurations.getCleanupFrequency().get()));
        if (wasCleanedUp) {
            this.execute(new WrapperDistributionCleanupAction(this.userHomeDirProvider.getGradleUserHomeDirectory(), this.usedGradleVersions));
        }
        this.alreadyCleaned = true;
    }

    public void stop() {
        if (!this.alreadyCleaned) {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(MonitoredCleanupAction action) {
        ProgressLogger progressLogger = this.startNewOperation(action.getClass(), action.getDisplayName());
        try {
            boolean bl = action.execute((CleanupProgressMonitor)new DefaultCleanupProgressMonitor(progressLogger));
            return bl;
        }
        finally {
            progressLogger.completed();
        }
    }

    private ProgressLogger startNewOperation(Class<?> loggerClass, String description) {
        return this.progressLoggerFactory.newOperation(loggerClass).start(description, description);
    }
}

