/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.ArrayList;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;

public class ConstraintDescriptorList
extends ArrayList<ConstraintDescriptor> {
    private boolean scanned;

    public void setScanned(boolean scanned) {
        this.scanned = scanned;
    }

    public boolean getScanned() {
        return this.scanned;
    }

    public ConstraintDescriptor getConstraintDescriptor(UUID indexUUID) {
        ConstraintDescriptor retCD = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            KeyConstraintDescriptor keyCD;
            ConstraintDescriptor cd = this.elementAt(index);
            if (!(cd instanceof KeyConstraintDescriptor) || !(keyCD = (KeyConstraintDescriptor)cd).getIndexId().equals(indexUUID)) continue;
            retCD = cd;
            break;
        }
        return retCD;
    }

    public ConstraintDescriptor getConstraintDescriptorById(UUID uuid) {
        ConstraintDescriptor returnCD = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (!cd.getUUID().equals(uuid)) continue;
            returnCD = cd;
            break;
        }
        return returnCD;
    }

    public ConstraintDescriptor dropConstraintDescriptorById(UUID uuid) {
        ConstraintDescriptor cd = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            cd = this.elementAt(index);
            if (!cd.getUUID().equals(uuid)) continue;
            this.remove(cd);
            break;
        }
        return cd;
    }

    public ConstraintDescriptor getConstraintDescriptorByName(SchemaDescriptor sd, String name) {
        ConstraintDescriptor retCD = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (!cd.getConstraintName().equals(name) || sd != null && !sd.equals(cd.getSchemaDescriptor())) continue;
            retCD = cd;
            break;
        }
        return retCD;
    }

    public ReferencedKeyConstraintDescriptor getPrimaryKey() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (cd.getConstraintType() != 2) continue;
            return (ReferencedKeyConstraintDescriptor)cd;
        }
        return null;
    }

    public ConstraintDescriptorList getConstraintDescriptorList(boolean enforced) {
        ConstraintDescriptorList cdl = new ConstraintDescriptorList();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (cd.enforced() != enforced) continue;
            cdl.add(cd);
        }
        return cdl;
    }

    public ConstraintDescriptor elementAt(int n) {
        return (ConstraintDescriptor)this.get(n);
    }

    public ConstraintDescriptorList getSubList(int type) {
        ConstraintDescriptorList cdl = new ConstraintDescriptorList();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (cd.getConstraintType() != type) continue;
            cdl.add(cd);
        }
        return cdl;
    }
}

