/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.llvm.CXIdxEntityInfo;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxBaseClassInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BASE;
    public static final int CURSOR;
    public static final int LOC;

    public CXIdxBaseClassInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxBaseClassInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxEntityInfo const *")
    public CXIdxEntityInfo base() {
        return CXIdxBaseClassInfo.nbase(this.address());
    }

    public CXCursor cursor() {
        return CXIdxBaseClassInfo.ncursor(this.address());
    }

    public CXIdxLoc loc() {
        return CXIdxBaseClassInfo.nloc(this.address());
    }

    public static CXIdxBaseClassInfo create(long address) {
        return (CXIdxBaseClassInfo)CXIdxBaseClassInfo.wrap(CXIdxBaseClassInfo.class, (long)address);
    }

    @Nullable
    public static CXIdxBaseClassInfo createSafe(long address) {
        return address == 0L ? null : (CXIdxBaseClassInfo)CXIdxBaseClassInfo.wrap(CXIdxBaseClassInfo.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXIdxBaseClassInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXIdxBaseClassInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXIdxEntityInfo nbase(long struct) {
        return CXIdxEntityInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)BASE)));
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    public static CXIdxLoc nloc(long struct) {
        return CXIdxLoc.create(struct + (long)LOC);
    }

    static {
        Struct.Layout layout = CXIdxBaseClassInfo.__struct((Struct.Member[])new Struct.Member[]{CXIdxBaseClassInfo.__member((int)POINTER_SIZE), CXIdxBaseClassInfo.__member((int)CXCursor.SIZEOF, (int)CXCursor.ALIGNOF), CXIdxBaseClassInfo.__member((int)CXIdxLoc.SIZEOF, (int)CXIdxLoc.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BASE = layout.offsetof(0);
        CURSOR = layout.offsetof(1);
        LOC = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXIdxBaseClassInfo, Buffer> {
        private static final CXIdxBaseClassInfo ELEMENT_FACTORY = CXIdxBaseClassInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxBaseClassInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxEntityInfo const *")
        public CXIdxEntityInfo base() {
            return CXIdxBaseClassInfo.nbase(this.address());
        }

        public CXCursor cursor() {
            return CXIdxBaseClassInfo.ncursor(this.address());
        }

        public CXIdxLoc loc() {
            return CXIdxBaseClassInfo.nloc(this.address());
        }
    }
}

