/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExportMemoryAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    public VkExportMemoryAllocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExportMemoryAllocateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportMemoryAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportMemoryAllocateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int handleTypes() {
        return VkExportMemoryAllocateInfo.nhandleTypes(this.address());
    }

    public VkExportMemoryAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExportMemoryAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfo sType$Default() {
        return this.sType(1000072002);
    }

    public VkExportMemoryAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkExportMemoryAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfo handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExportMemoryAllocateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportMemoryAllocateInfo set(VkExportMemoryAllocateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExportMemoryAllocateInfo malloc() {
        return (VkExportMemoryAllocateInfo)VkExportMemoryAllocateInfo.wrap(VkExportMemoryAllocateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkExportMemoryAllocateInfo calloc() {
        return (VkExportMemoryAllocateInfo)VkExportMemoryAllocateInfo.wrap(VkExportMemoryAllocateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkExportMemoryAllocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkExportMemoryAllocateInfo)VkExportMemoryAllocateInfo.wrap(VkExportMemoryAllocateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkExportMemoryAllocateInfo create(long address) {
        return (VkExportMemoryAllocateInfo)VkExportMemoryAllocateInfo.wrap(VkExportMemoryAllocateInfo.class, (long)address);
    }

    @Nullable
    public static VkExportMemoryAllocateInfo createSafe(long address) {
        return address == 0L ? null : (VkExportMemoryAllocateInfo)VkExportMemoryAllocateInfo.wrap(VkExportMemoryAllocateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkExportMemoryAllocateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkExportMemoryAllocateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkExportMemoryAllocateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExportMemoryAllocateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkExportMemoryAllocateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkExportMemoryAllocateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkExportMemoryAllocateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkExportMemoryAllocateInfo mallocStack() {
        return VkExportMemoryAllocateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryAllocateInfo callocStack() {
        return VkExportMemoryAllocateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryAllocateInfo mallocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfo.malloc(stack);
    }

    @Deprecated
    public static VkExportMemoryAllocateInfo callocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryAllocateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExportMemoryAllocateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfo.calloc(capacity, stack);
    }

    public static VkExportMemoryAllocateInfo malloc(MemoryStack stack) {
        return (VkExportMemoryAllocateInfo)VkExportMemoryAllocateInfo.wrap(VkExportMemoryAllocateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportMemoryAllocateInfo calloc(MemoryStack stack) {
        return (VkExportMemoryAllocateInfo)VkExportMemoryAllocateInfo.wrap(VkExportMemoryAllocateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkExportMemoryAllocateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkExportMemoryAllocateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nhandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nhandleTypes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExportMemoryAllocateInfo.__struct((Struct.Member[])new Struct.Member[]{VkExportMemoryAllocateInfo.__member((int)4), VkExportMemoryAllocateInfo.__member((int)POINTER_SIZE), VkExportMemoryAllocateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExportMemoryAllocateInfo, Buffer>
    implements NativeResource {
        private static final VkExportMemoryAllocateInfo ELEMENT_FACTORY = VkExportMemoryAllocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkExportMemoryAllocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportMemoryAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportMemoryAllocateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int handleTypes() {
            return VkExportMemoryAllocateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMemoryAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000072002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMemoryAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExportMemoryAllocateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

